/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.launch.ui.tab;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jubula.launch.ui.i18n.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final Logger LOG = LoggerFactory.getLogger(AutLaunchConfigurationTab.class);
    private Text m_autIdText;
    private Label m_autIdLabel;

    public void createControl(Composite parent) {
        Image infoImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.m_autIdLabel = new Label(composite, 0);
        this.m_autIdLabel.setText(Messages.AutLaunchConfigurationTab_AutIdTextField_label);
        this.m_autIdText = new Text(composite, 2048);
        ControlDecoration autIdLabelDecoration = new ControlDecoration((Control)this.m_autIdText, 16512);
        autIdLabelDecoration.setDescriptionText(Messages.AutLaunchConfigurationTab_AutIdTextField_info);
        autIdLabelDecoration.setImage(infoImage);
        autIdLabelDecoration.setMarginWidth(2);
        autIdLabelDecoration.setShowOnlyOnFocus(false);
        GridDataFactory.fillDefaults().grab(true, false).indent(autIdLabelDecoration.getImage().getBounds().x + autIdLabelDecoration.getMarginWidth() * 2, 0).applyTo((Control)this.m_autIdText);
        this.m_autIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AutLaunchConfigurationTab.this.setDirty(true);
                AutLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControl((Control)composite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.jubula.launch.AUT_ID", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.m_autIdText.setText(configuration.getAttribute("org.eclipse.jubula.launch.AUT_ID", ""));
        }
        catch (CoreException ce) {
            LOG.error("An error occurred while initializing AUT ID text field.", (Throwable)ce);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.jubula.launch.AUT_ID", this.m_autIdText.getText());
    }

    public String getName() {
        return Messages.AutLaunchConfigurationTab_name;
    }
}

