/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.driver;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.KeyStroke;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.IEventMatcher;
import org.eclipse.jubula.rc.common.driver.IRobotEventConfirmer;
import org.eclipse.jubula.rc.common.driver.IRobotEventInterceptor;
import org.eclipse.jubula.rc.common.driver.InterceptorOptions;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class KeyTyper {
    public static final int[] NUMPAD_KEYCODES = new int[]{33, 34, 36, 35, 127, 155, 39, 37, 38, 40, 227, 226, 224, 225};
    private static final String VALID_INPUT = "[a-zA-z0-9]*";
    private static AutServerLogger log;
    private static KeyTyper instance;
    private Robot m_robot = new Robot();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.driver.KeyTyper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger(clazz);
        instance = null;
    }

    private KeyTyper() throws AWTException {
    }

    public static KeyTyper getInstance() throws AWTException {
        if (instance == null) {
            instance = new KeyTyper();
        }
        return instance;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void type(KeyStroke keyStroke, IRobotEventInterceptor interceptor, IEventMatcher keyDownMatcher, IEventMatcher keyUpMatcher) {
        try {
            Validate.notNull((Object)keyStroke);
            boolean waitForConfirm = interceptor != null && keyDownMatcher != null && keyUpMatcher != null;
            InterceptorOptions options = new InterceptorOptions(new long[]{8L});
            List keycodes = this.modifierKeyCodes(keyStroke);
            keycodes.add(new Integer(keyStroke.getKeyCode()));
            if (log.isDebugEnabled()) {
                String keyModifierText = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                String keyText = KeyEvent.getKeyText(keyStroke.getKeyCode());
                log.debug("Key stroke: " + keyStroke);
                log.debug("Modifiers, Key: " + keyModifierText + ", " + keyText);
                log.debug("number of keycodes: " + keycodes.size());
            }
            this.m_robot.setAutoWaitForIdle(true);
            boolean isNumLockToggled = this.hackWindowsNumpadKeys1(keyStroke.getKeyCode());
            HashSet<Integer> alreadyDown = new HashSet<Integer>();
            ListIterator i = keycodes.listIterator();
            try {
                while (i.hasNext()) {
                    Integer keycode = (Integer)i.next();
                    if (log.isDebugEnabled()) {
                        log.debug("trying to press: " + keycode);
                    }
                    if (alreadyDown.contains(keycode)) continue;
                    IRobotEventConfirmer confirmer = null;
                    if (waitForConfirm) {
                        confirmer = interceptor.intercept(options);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("pressing: " + keycode);
                    }
                    alreadyDown.add(keycode);
                    this.m_robot.keyPress(keycode);
                    if (!waitForConfirm) continue;
                    confirmer.waitToConfirm(null, keyDownMatcher);
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                this.releaseKeys(options, alreadyDown, i, interceptor, keyUpMatcher);
                if (!isNumLockToggled) throw throwable;
                this.hackWindowsNumpadKeys2();
                throw throwable;
            }
            {
                Object var13_17 = null;
                this.releaseKeys(options, alreadyDown, i, interceptor, keyUpMatcher);
                if (!isNumLockToggled) return;
                this.hackWindowsNumpadKeys2();
                return;
            }
        }
        catch (IllegalArgumentException e) {
            throw new RobotException(e);
        }
    }

    public void type(String keyStrokeSpec, IRobotEventInterceptor interceptor, IEventMatcher keyDownMatcher, IEventMatcher keyUpMatcher) {
        String trimmedKeyStrokeSpec;
        int indexOfKeySpec;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyStrokeSpec);
        if (keyStroke == null && (indexOfKeySpec = (trimmedKeyStrokeSpec = keyStrokeSpec.trim()).lastIndexOf(" ")) != -1) {
            String keySpec = trimmedKeyStrokeSpec.substring(indexOfKeySpec + 1, trimmedKeyStrokeSpec.length());
            KeyStroke checkKeyStroke = KeyStroke.getKeyStroke(keySpec);
            if (checkKeyStroke == null) {
                throw new StepExecutionException("invalid key spec", EventFactory.createActionError((String)"TestErrorEvent.InvalidKeySpec", (Object[])new String[]{keySpec}));
            }
            String invalidModifier = trimmedKeyStrokeSpec.substring(0, indexOfKeySpec).trim();
            throw new StepExecutionException("invalid modifier", EventFactory.createActionError((String)"TestErrorEvent.InvalidModifier", (Object[])new String[]{invalidModifier}));
        }
        this.type(keyStroke, interceptor, keyDownMatcher, keyUpMatcher);
    }

    private List modifierKeyCodes(KeyStroke keyStroke) {
        LinkedList<Integer> l = new LinkedList<Integer>();
        int modifiers = keyStroke.getModifiers();
        if ((modifiers & 8) != 0) {
            l.add(new Integer(18));
        }
        if ((modifiers & 0x20) != 0) {
            l.add(new Integer(65406));
        }
        if ((modifiers & 2) != 0) {
            l.add(new Integer(17));
        }
        if ((modifiers & 1) != 0) {
            l.add(new Integer(16));
        }
        if ((modifiers & 4) != 0) {
            l.add(new Integer(157));
        }
        return l;
    }

    private boolean hackWindowsNumpadKeys1(int keyCode) {
        boolean isNumpadKey = false;
        int i = 0;
        while (i < NUMPAD_KEYCODES.length) {
            if (NUMPAD_KEYCODES[i] == keyCode) {
                isNumpadKey = true;
                break;
            }
            ++i;
        }
        boolean wasNumLockToggled = false;
        if (isNumpadKey) {
            try {
                this.m_robot.keyPress(144);
                this.m_robot.keyRelease(144);
                this.m_robot.keyPress(144);
                this.m_robot.keyRelease(144);
                if (Toolkit.getDefaultToolkit().getLockingKeyState(144)) {
                    Toolkit.getDefaultToolkit().setLockingKeyState(144, false);
                    wasNumLockToggled = true;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                log.info("UnsupportedOperationException thrown by NumPad workaround. NumLock will not be toggled.");
            }
        }
        return wasNumLockToggled;
    }

    private void hackWindowsNumpadKeys2() {
        Toolkit.getDefaultToolkit().setLockingKeyState(144, true);
    }

    private void releaseKeys(InterceptorOptions options, Set alreadyDown, ListIterator i, IRobotEventInterceptor interceptor, IEventMatcher keyUpMatcher) {
        boolean waitForConfirm = interceptor != null && keyUpMatcher != null;
        HashSet<Integer> alreadyUp = new HashSet<Integer>();
        while (i.hasPrevious()) {
            Integer keycode = (Integer)i.previous();
            if (log.isDebugEnabled()) {
                log.debug("trying to release: " + keycode);
            }
            if (alreadyUp.contains(keycode) || !alreadyDown.contains(keycode)) continue;
            try {
                IRobotEventConfirmer confirmer = null;
                if (waitForConfirm) {
                    confirmer = interceptor.intercept(options);
                }
                if (log.isDebugEnabled()) {
                    log.debug("releasing: " + keycode);
                }
                alreadyUp.add(keycode);
                this.m_robot.keyRelease(keycode);
                if (!waitForConfirm) continue;
                confirmer.waitToConfirm(null, keyUpMatcher);
            }
            catch (RobotException e) {
                log.error("error releasing keys", (Throwable)((Object)e));
                if (i.hasPrevious()) continue;
                throw e;
            }
        }
    }

    public void nativeTypeString(String text) {
        if (MatchUtil.getInstance().match(text, VALID_INPUT, "matches")) {
            boolean isCapsLockOn = false;
            try {
                isCapsLockOn = Toolkit.getDefaultToolkit().getLockingKeyState(20);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                boolean holdShift = Character.isUpperCase(c) ^ isCapsLockOn;
                StringBuffer sb = new StringBuffer();
                if (holdShift) {
                    sb.append("shift ");
                }
                sb.append(Character.toUpperCase(c));
                this.type(sb.toString(), null, null, null);
                ++i;
            }
        } else {
            throw new StepExecutionException("Invalid input string (only ASCII alphanumeric strings are allowed)", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
    }
}

