/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.util.ArrayList;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.MenuUtilBase;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractUITester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuAdapter;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuItemAdapter;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.TimeUtil;

public abstract class AbstractMenuTester
extends AbstractUITester {
    private static AutServerLogger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.tester.AbstractMenuTester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger(clazz);
    }

    public static AutServerLogger getLog() {
        return log;
    }

    public IMenuAdapter getMenuAdapter() {
        return (IMenuAdapter)this.getComponent();
    }

    public void verifyEnabled(String menuItem, String operator, boolean enabled) {
        this.verifyEnabled(MenuUtilBase.splitPath(menuItem), operator, enabled);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyEnabled(String[] menuItem, String operator, boolean enabled) {
        this.checkPathLength(menuItem.length);
        IMenuItemAdapter item = this.navigateToMenuItem(this.getAndCheckMenu(), menuItem, operator);
        this.checkIsNull(item);
        try {
            Verifier.equals(enabled, item.isEnabled());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem, operator);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem, operator);
            return;
        }
    }

    private void checkIsNull(IMenuItemAdapter item) {
        if (item.getRealComponent() == null) {
            this.throwMenuItemNotFound();
        }
    }

    public void verifyEnabledByIndexpath(String menuItem, boolean enabled) {
        this.verifyEnabledByIndexpath(MenuUtilBase.splitIndexPath(menuItem), enabled);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyEnabledByIndexpath(int[] menuItem, boolean enabled) {
        this.checkPathLength(menuItem.length);
        IMenuItemAdapter item = this.navigateToMenuItem(this.getAndCheckMenu(), menuItem);
        this.checkIsNull(item);
        try {
            Verifier.equals(enabled, item.isEnabled());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem);
            return;
        }
    }

    public void verifyExists(String menuItem, String operator, boolean exists) {
        this.verifyExists(MenuUtilBase.splitPath(menuItem), operator, exists);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyExists(String[] menuItem, String operator, boolean exists) {
        this.checkPathLength(menuItem.length);
        IMenuItemAdapter item = this.navigateToMenuItem(this.getAndCheckMenu(), menuItem, operator);
        try {
            Verifier.equals(exists, item.isExisting());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem, operator);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem, operator);
            return;
        }
    }

    public void verifyExistsByIndexpath(String menuItem, boolean exists) {
        this.verifyExistsByIndexpath(MenuUtilBase.splitIndexPath(menuItem), exists);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyExistsByIndexpath(int[] menuItem, boolean exists) {
        this.checkPathLength(menuItem.length);
        IMenuItemAdapter item = this.navigateToMenuItem(this.getAndCheckMenu(), menuItem);
        try {
            Verifier.equals(exists, item.isExisting());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem);
            return;
        }
    }

    public void verifySelected(String menuItem, String operator, boolean selected) {
        this.verifySelected(MenuUtilBase.splitPath(menuItem), operator, selected);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifySelected(String[] menuItem, String operator, boolean selected) {
        this.checkPathLength(menuItem.length);
        IMenuItemAdapter item = this.navigateToMenuItem(this.getAndCheckMenu(), menuItem, operator);
        this.checkIsNull(item);
        try {
            Verifier.equals(selected, item.isSelected());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem, operator);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem, operator);
            return;
        }
    }

    public void verifySelectedByIndexpath(String menuItem, boolean selected) {
        this.verifySelectedByIndexpath(MenuUtilBase.splitIndexPath(menuItem), selected);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifySelectedByIndexpath(int[] menuItem, boolean selected) {
        this.checkPathLength(menuItem.length);
        IMenuItemAdapter item = this.navigateToMenuItem(this.getAndCheckMenu(), menuItem);
        this.checkIsNull(item);
        try {
            Verifier.equals(selected, item.isSelected());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.closeMenu(this.getAndCheckMenu(), menuItem);
            return;
        }
    }

    public void selectMenuItemByIndexpath(String indexPath) {
        int[] indexItems = MenuUtilBase.splitIndexPath(indexPath);
        this.checkPathLength(indexItems.length);
        try {
            IMenuItemAdapter item = this.navigateToMenuItem(this.getAndCheckMenu(), indexItems);
            this.checkIsNull(item);
            item.selectMenuItem();
        }
        catch (StepExecutionException stepExecutionException) {
            block4: {
                try {
                    this.closeMenu(this.getAndCheckMenu(), indexItems);
                }
                catch (StepExecutionException stepExecutionException2) {
                    if (!AbstractMenuTester.getLog().isInfoEnabled()) break block4;
                    AbstractMenuTester.getLog().info("Tried to close a disabled or already closed menu.");
                }
            }
            this.throwMenuItemNotFound();
        }
    }

    public void selectMenuItem(String namePath, String operator) {
        String[] menuItems = MenuUtilBase.splitPath(namePath);
        if (menuItems.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        IMenuItemAdapter item = this.navigateToMenuItem(this.getAndCheckMenu(), menuItems, operator);
        if (item == null) {
            try {
                this.closeMenu(this.getAndCheckMenu(), menuItems, operator);
            }
            catch (StepExecutionException stepExecutionException) {
                AbstractMenuTester.getLog().info("Tried to close a disabled or already closed menu.");
            }
            throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        item.selectMenuItem();
    }

    protected IMenuAdapter getAndCheckMenu() throws StepExecutionException {
        Object menu = this.getMenuAdapter().getRealComponent();
        if (menu == null) {
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoMenuBar"), EventFactory.createActionError((String)"TestErrorEvent.NoMenuBar"));
        }
        return this.getMenuAdapter();
    }

    private void throwMenuItemNotFound() {
        throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
    }

    protected void closeMenu(IMenuAdapter menuBar, String[] textPath, String operator) {
        IMenuItemAdapter menuitem = this.findMenu(menuBar, this.getIndexForName(menuBar, textPath[0], operator));
        if (menuitem.getRealComponent() != null) {
            this.getRobot().click(menuitem.getRealComponent(), null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
        }
    }

    protected void closeMenu(IMenuAdapter menuBar, int[] path) {
        IMenuItemAdapter menuitem = this.findMenu(menuBar, path[0]);
        if (menuitem.getRealComponent() != null) {
            this.getRobot().click(menuitem.getRealComponent(), null, ClickOptions.create().setClickType(ClickOptions.ClickType.RELEASED));
        }
    }

    protected int getIndexForName(IMenuAdapter menu, String name, String operator) {
        IMenuItemAdapter[] subElements = menu.getItems();
        int downcount = 0;
        int j = 0;
        while (j < subElements.length) {
            IMenuItemAdapter tempMenu = subElements[j];
            if (tempMenu.isSeparator()) {
                ++downcount;
            }
            if (tempMenu.isShowing() && MatchUtil.getInstance().match(tempMenu.getText(), name, operator)) {
                return j - downcount;
            }
            ++j;
        }
        return Integer.MAX_VALUE;
    }

    public void waitForComponent(int timeout, int delay) {
        if (this.getComponent().getRealComponent() == null) {
            long start = System.currentTimeMillis();
            do {
                RobotTiming.sleepWaitForComponentPollingDelay();
            } while (System.currentTimeMillis() - start < (long)timeout && this.getComponent().getRealComponent() == null);
            if (this.getComponent().getRealComponent() == null) {
                throw new StepExecutionException("No Menubar found.", EventFactory.createComponentNotFoundErrorEvent());
            }
        }
        TimeUtil.delay((long)delay);
    }

    protected IMenuItemAdapter navigateToMenuItem(IMenuAdapter menuBar, String[] path, String operator) {
        this.checkPathLength(path.length);
        IMenuAdapter currentmenu = menuBar;
        IMenuItemAdapter currentMenuItem = null;
        int pathLength = path.length;
        int beforeLast = pathLength - 1;
        int i = 0;
        while (i < path.length) {
            int pathIndex = this.getIndexForName(currentmenu, path[i], operator);
            currentMenuItem = this.getNextMenuItem(currentmenu, pathIndex);
            if (currentMenuItem.getRealComponent() == null && i < beforeLast) {
                return currentMenuItem;
            }
            if (i < beforeLast) {
                if (!currentMenuItem.hasSubMenu()) {
                    return this.newMenuItemAdapter(null);
                }
                currentmenu = currentMenuItem.openSubMenu();
            }
            ++i;
        }
        return currentMenuItem;
    }

    protected IMenuItemAdapter navigateToMenuItem(IMenuAdapter menubar, int[] path) {
        this.checkPathLength(path.length);
        IMenuAdapter currentmenu = menubar;
        IMenuItemAdapter currentMenuItem = null;
        int pathLength = path.length;
        int beforeLast = pathLength - 1;
        int i = 0;
        while (i < path.length) {
            int pathIndex = path[i];
            currentMenuItem = this.getNextMenuItem(currentmenu, pathIndex);
            if (currentMenuItem.getRealComponent() == null && i < beforeLast) {
                return currentMenuItem;
            }
            if (i < beforeLast) {
                if (!currentMenuItem.hasSubMenu()) {
                    return this.newMenuItemAdapter(null);
                }
                currentmenu = currentMenuItem.openSubMenu();
            }
            ++i;
        }
        return currentMenuItem;
    }

    private IMenuItemAdapter getNextMenuItem(IMenuAdapter currentmenu, int pathIndex) {
        if (pathIndex < 0) {
            AbstractMenuTester.throwInvalidPathException();
        }
        IMenuItemAdapter currentMenuItem = this.findMenu(currentmenu, pathIndex);
        return currentMenuItem;
    }

    private IMenuItemAdapter findMenu(IMenuAdapter menu, int idx) {
        ArrayList<IMenuItemAdapter> visibleSubMenus = new ArrayList<IMenuItemAdapter>();
        IMenuItemAdapter[] subElements = menu.getItems();
        int i = 0;
        while (i < subElements.length) {
            IMenuItemAdapter menuitem = subElements[i];
            if (menuitem.getRealComponent() != null && !menuitem.isSeparator() && menuitem.isShowing()) {
                visibleSubMenus.add(menuitem);
            }
            ++i;
        }
        if (idx >= visibleSubMenus.size() || idx < 0) {
            return this.newMenuItemAdapter(null);
        }
        return (IMenuItemAdapter)visibleSubMenus.get(idx);
    }

    private void checkPathLength(int length) {
        if (length < 1) {
            throw new StepExecutionException("empty path to menuitem is not allowed", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
    }

    private static void throwInvalidPathException() {
        throw new StepExecutionException("invalid path", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
    }

    protected abstract IMenuItemAdapter newMenuItemAdapter(Object var1);
}

