/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.AbstractTextInputSupportTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableAdapter;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public abstract class AbstractTableTester
extends AbstractTextInputSupportTester {
    private static AutServerLogger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.tester.AbstractTableTester");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger(clazz);
    }

    public static AutServerLogger getLog() {
        return log;
    }

    private Object getRealTable() {
        return this.getComponent().getRealComponent();
    }

    private ITableAdapter getTableAdapter() {
        return (ITableAdapter)this.getComponent();
    }

    public void gdVerifyText(String text) throws StepExecutionException {
        this.gdVerifyText(text, "equals");
    }

    public void gdVerifyText(String text, String operator) throws StepExecutionException {
        ITableAdapter adapter = this.getTableAdapter();
        Cell cell = adapter.getSelectedCell();
        int implRow = cell.getRow();
        int implCol = cell.getCol();
        this.checkRowColBounds(implRow, implCol);
        adapter.scrollCellToVisible(implRow, implCol);
        String current = this.getCellText(implRow, implCol);
        Verifier.match(current, text, operator);
    }

    public void gdVerifyText(String text, String operator, String row, String rowOperator, String col, String colOperator) throws StepExecutionException {
        String current;
        ITableAdapter adapter = this.getTableAdapter();
        int implRow = adapter.getRowFromString(row, rowOperator);
        int implCol = adapter.getColumnFromString(col, colOperator);
        if (implRow == -1 && implCol > -1) {
            current = adapter.getColumnName(implCol);
        } else {
            this.checkRowColBounds(implRow, implCol);
            adapter.scrollCellToVisible(implRow, implCol);
            current = this.getCellText(implRow, implCol);
        }
        Verifier.match(current, text, operator);
    }

    /*
     * Exception decompiling
     */
    public void gdSelectCell(String row, String rowOperator, String col, String colOperator, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection, int button) throws StepExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 257->261)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Object getSpecificRectangle(Rectangle rectangle) {
        return rectangle;
    }

    public void gdVerifyValueInColumn(String col, String colOperator, String value, String operator, String searchType, boolean exists) throws StepExecutionException {
        ITableAdapter adapter = this.getTableAdapter();
        int implCol = adapter.getColumnFromString(col, colOperator);
        boolean valueExists = this.isValueExisting(adapter, implCol, value, operator, searchType);
        Verifier.equals(exists, valueExists);
    }

    private boolean isValueExisting(ITableAdapter adapter, int implCol, String value, String operator, String searchType) {
        int rowCount = adapter.getRowCount();
        int i = this.getStartingRowIndex(searchType);
        while (i < rowCount) {
            if (MatchUtil.getInstance().match(this.getCellText(i, implCol), value, operator)) {
                return true;
            }
            ++i;
        }
        if (adapter.isHeaderVisible()) {
            String header = adapter.getColumnName(implCol);
            if (MatchUtil.getInstance().match(header, value, operator)) {
                return true;
            }
        }
        return false;
    }

    public void gdVerifyValueInRow(String row, String rowOperator, String value, String operator, String searchType, boolean exists) throws StepExecutionException {
        ITableAdapter adapter = this.getTableAdapter();
        int implRow = adapter.getRowFromString(row, rowOperator);
        boolean valueIsExisting = false;
        if (implRow == -1) {
            int k = this.getStartingColIndex(searchType);
            while (k < adapter.getColumnCount()) {
                if (MatchUtil.getInstance().match(adapter.getColumnName(k), value, operator)) {
                    valueIsExisting = true;
                    break;
                }
                ++k;
            }
        } else {
            int columnCount = adapter.getColumnCount();
            if (columnCount > 0) {
                int i = this.getStartingColIndex(searchType);
                while (i < columnCount) {
                    if (MatchUtil.getInstance().match(this.getCellText(implRow, i), value, operator)) {
                        valueIsExisting = true;
                        break;
                    }
                    ++i;
                }
            } else if (MatchUtil.getInstance().match(adapter.getRowName(implRow), value, operator)) {
                valueIsExisting = true;
            }
        }
        Verifier.equals(exists, valueIsExisting);
    }

    public void gdVerifyEditable(boolean editable, String row, String rowOperator, String col, String colOperator) {
        if (this.getTableAdapter().getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.gdSelectCell(row, rowOperator, col, colOperator, ClickOptions.create(), "no");
        this.gdVerifyEditable(editable);
    }

    private void gdSelectCell(String row, String rowOperator, String col, String colOperator, ClickOptions co, String extendSelection) {
        this.gdSelectCell(row, rowOperator, col, colOperator, co.getClickCount(), 50, "Percent", 50, "Percent", extendSelection, co.getMouseButton());
    }

    public void gdVerifyTextAtMousePosition(String text, String operator) throws StepExecutionException {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell cell = this.getCellAtMousePosition();
        this.gdVerifyText(text, operator, Integer.toString(IndexConverter.toUserIndex(cell.getRow())), "equals", Integer.toString(IndexConverter.toUserIndex(cell.getCol())), "equals");
    }

    public void gdVerifyEditableSelected(boolean editable) {
        this.gdVerifyEditable(editable);
    }

    public void gdVerifyEditable(boolean editable) {
        Cell cell = this.getTableAdapter().getSelectedCell();
        Verifier.equals(editable, this.getTableAdapter().isCellEditable(cell.getRow(), cell.getCol()));
    }

    public void gdVerifyEditableMousePosition(boolean editable) {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell cell = this.getCellAtMousePosition();
        boolean isEditable = this.getTableAdapter().isCellEditable(cell.getRow(), cell.getCol());
        Verifier.equals(editable, isEditable);
    }

    public void gdSelectRowByValue(String col, String colOperator, String value, String regexOp, int clickCount, String extendSelection, String searchType, int button) {
        this.gdSelectRowByValue(col, colOperator, value, regexOp, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    protected void gdSelectRowByValue(String col, String colOperator, String value, String regexOp, String extendSelection, String searchType, ClickOptions co) {
        ITableAdapter adapter = this.getTableAdapter();
        int implCol = adapter.getColumnFromString(col, colOperator);
        Integer implRow = null;
        int rowCount = adapter.getRowCount();
        int i = this.getStartingRowIndex(searchType);
        while (i < rowCount) {
            if (MatchUtil.getInstance().match(this.getCellText(i, implCol), value, regexOp)) {
                implRow = new Integer(i);
                break;
            }
            ++i;
        }
        if (implRow == null) {
            String header = adapter.getColumnName(implCol);
            if (MatchUtil.getInstance().match(header, value, regexOp)) {
                implRow = new Integer(-1);
            }
        }
        if (implRow == null) {
            throw new StepExecutionException("no such row found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String userIdxRow = new Integer(IndexConverter.toUserIndex(implRow)).toString();
        String userIdxCol = new Integer(IndexConverter.toUserIndex(implCol)).toString();
        this.gdSelectCell(userIdxRow, "equals", userIdxCol, colOperator, co, extendSelection);
    }

    public void gdSelectCellByColValue(String row, String rowOperator, String value, String regex, int clickCount, String extendSelection, String searchType, int button) {
        this.gdSelectCellByColValue(row, rowOperator, value, regex, extendSelection, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button));
    }

    protected void gdSelectCellByColValue(String row, String rowOperator, String value, String regex, String extendSelection, String searchType, ClickOptions co) {
        int i;
        ITableAdapter adapter = this.getTableAdapter();
        int implRow = adapter.getRowFromString(row, rowOperator);
        int colCount = adapter.getColumnCount();
        Integer implCol = null;
        if (implRow == -1) {
            i = this.getStartingColIndex(searchType);
            while (i < colCount) {
                if (MatchUtil.getInstance().match(adapter.getColumnName(i), value, regex)) {
                    implCol = new Integer(i);
                    break;
                }
                ++i;
            }
        } else {
            i = this.getStartingColIndex(searchType);
            while (i < colCount) {
                if (MatchUtil.getInstance().match(this.getCellText(implRow, i), value, regex)) {
                    implCol = new Integer(i);
                    break;
                }
                ++i;
            }
        }
        if (implCol == null) {
            throw new StepExecutionException("no such cell found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        String usrIdxRowStr = new Integer(IndexConverter.toUserIndex(implRow)).toString();
        String usrIdxColStr = new Integer(IndexConverter.toUserIndex(implCol)).toString();
        this.gdSelectCell(usrIdxRowStr, rowOperator, usrIdxColStr, "equals", co, extendSelection);
    }

    public String gdReadValue(String variable, String row, String rowOperator, String col, String colOperator) {
        ITableAdapter adapter = this.getTableAdapter();
        int implRow = adapter.getRowFromString(row, rowOperator);
        int implCol = adapter.getColumnFromString(col, colOperator);
        if (implRow == -1 && implCol > -1) {
            return adapter.getColumnName(implCol);
        }
        this.checkRowColBounds(implRow, implCol);
        adapter.scrollCellToVisible(implRow, implCol);
        return this.getCellText(implRow, implCol);
    }

    public String gdReadValueAtMousePosition(String variable) {
        Cell cellAtMousePosition = this.getTableAdapter().getSelectedCell();
        return this.getCellText(cellAtMousePosition.getRow(), cellAtMousePosition.getCol());
    }

    public void gdClick(int count, int button) {
        ITableAdapter adapter = this.getTableAdapter();
        Cell cell = null;
        if (this.isMouseOverCell()) {
            cell = this.getCellAtMousePosition();
        } else if (adapter.hasCellSelection()) {
            cell = adapter.getSelectedCell();
        }
        if (cell != null) {
            Rectangle cellRect = adapter.scrollCellToVisible(cell.getRow(), cell.getCol());
            Object robotSpecifcRectangle = this.getSpecificRectangle(cellRect);
            this.getRobot().click(this.getRealTable(), robotSpecifcRectangle, ClickOptions.create().setClickCount(count).setMouseButton(button));
        } else {
            super.gdClick(count, button);
        }
    }

    public void gdMove(String direction, int cellCount, int clickCount, int xPos, String xUnits, int yPos, String yUnits, String extendSelection) throws StepExecutionException {
        if (this.isMouseOnHeader()) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        Cell currCell = null;
        try {
            currCell = this.getCellAtMousePosition();
        }
        catch (StepExecutionException stepExecutionException) {
            currCell = this.getTableAdapter().getSelectedCell();
        }
        int newCol = currCell.getCol();
        int newRow = currCell.getRow();
        if ("up".equalsIgnoreCase(direction)) {
            newRow -= cellCount;
        } else if ("down".equalsIgnoreCase(direction)) {
            newRow += cellCount;
        } else if ("left".equalsIgnoreCase(direction)) {
            newCol -= cellCount;
        } else if ("right".equalsIgnoreCase(direction)) {
            newCol += cellCount;
        }
        newRow = IndexConverter.toUserIndex(newRow);
        newCol = IndexConverter.toUserIndex(newCol);
        String row = Integer.toString(newRow);
        String col = Integer.toString(newCol);
        this.gdSelectCell(row, "equals", col, "equals", clickCount, xPos, xUnits, yPos, yUnits, extendSelection, 1);
    }

    public void gdInputText(String text) throws StepExecutionException {
        this.inputText(text, false);
    }

    public void gdInputText(String text, String row, String rowOperator, String col, String colOperator) throws StepExecutionException {
        if (this.getTableAdapter().getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.gdSelectCell(row, rowOperator, col, colOperator, ClickOptions.create().setClickCount(1), "no");
        this.gdInputText(text);
    }

    public void gdReplaceText(String text) throws StepExecutionException {
        this.inputText(text, true);
    }

    public void gdReplaceText(String text, String row, String rowOperator, String col, String colOperator) {
        if (this.getTableAdapter().getRowFromString(row, rowOperator) == -1) {
            throw new StepExecutionException("Unsupported Header Action", EventFactory.createActionError((String)"TestErrorEvent.UnsupportedHeaderAction"));
        }
        this.gdSelectCell(row, rowOperator, col, colOperator, ClickOptions.create().setClickCount(1), "no");
        this.inputText(text, true);
    }

    public void gdDragCell(int mouseButton, String modifier, String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setDragComponent(null);
        this.gdSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, "no", 1);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCell(String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) throws StepExecutionException {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.gdSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, "no", 1);
            AbstractTableTester.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var11_13 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        }
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragRowByValue(int mouseButton, String modifier, String col, String colOperator, String value, String regexOp, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectRowByValue(col, colOperator, value, regexOp, 1, "no", searchType, 1);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropRowByValue(String col, String colOperator, String value, String regexOp, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.gdSelectRowByValue(col, colOperator, value, regexOp, "no", searchType, ClickOptions.create().setClickCount(0));
            AbstractTableTester.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        }
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragCellByColValue(int mouseButton, String modifier, String row, String rowOperator, String value, String regex, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.gdSelectCellByColValue(row, rowOperator, value, regex, "no", searchType, ClickOptions.create().setClickCount(0));
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCellByColValue(String row, String rowOperator, String value, String regex, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.gdSelectCellByColValue(row, rowOperator, value, regex, "no", searchType, ClickOptions.create().setClickCount(0));
            AbstractTableTester.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        }
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    private String getCellText(int row, int column) {
        return this.getTableAdapter().getCellText(row, column);
    }

    private void checkBounds(int value, int count) {
        if (value < 0 || value >= count) {
            throw new StepExecutionException("Invalid row/column: " + value, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndexOrHeader"));
        }
    }

    protected void checkRowColBounds(int row, int column) throws StepExecutionException {
        ITableAdapter adapter = this.getTableAdapter();
        this.checkBounds(row, adapter.getRowCount());
        int colCount = adapter.getColumnCount();
        if (colCount > 0 || column > 0) {
            this.checkBounds(column, colCount);
        }
    }

    private int getStartingColIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            startingIndex = this.getTableAdapter().getSelectedCell().getCol() + 1;
        }
        return startingIndex;
    }

    private int getStartingRowIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            startingIndex = this.getTableAdapter().getSelectedCell().getRow() + 1;
        }
        return startingIndex;
    }

    private void inputText(String text, boolean replace) throws StepExecutionException {
        ITableAdapter adapter = this.getTableAdapter();
        Cell cell = adapter.getSelectedCell();
        Rectangle rectangle = adapter.scrollCellToVisible(cell.getRow(), cell.getCol());
        Object editor = this.activateEditor(cell, rectangle);
        editor = this.setEditorToReplaceMode(editor, replace);
        this.getRobot().type(editor, text);
    }

    private boolean isMouseOverCell() {
        try {
            this.getCellAtMousePosition();
        }
        catch (StepExecutionException stepExecutionException) {
            return false;
        }
        return true;
    }

    protected abstract Object setEditorToReplaceMode(Object var1, boolean var2);

    protected abstract Object activateEditor(Cell var1, Rectangle var2);

    protected abstract int getExtendSelectionModifier();

    protected abstract Cell getCellAtMousePosition() throws StepExecutionException;

    protected abstract boolean isMouseOnHeader();
}

