/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeNodeTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.ChildTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.IndexNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.ParentTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.PathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.SelectTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.SiblingTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.StringNodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.rc.common.tester.WidgetTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITreeAdapter;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;
import org.eclipse.jubula.tools.utils.StringParsing;

public abstract class AbstractTreeTester
extends WidgetTester {
    public String[] getTextArrayFromComponent() {
        return null;
    }

    private ITreeAdapter getTreeAdapter() {
        return (ITreeAdapter)this.getComponent();
    }

    public abstract void gdVerifyTextAtMousePosition(String var1, String var2);

    protected String[] splitTextTreePath(String treePath) {
        return StringParsing.splitToArray((String)treePath, (char)'/', (char)'\\', (boolean)true);
    }

    protected Integer[] splitIndexTreePath(String treePath) throws StepExecutionException {
        Integer[] indexPath = null;
        String[] path = this.splitTextTreePath(treePath);
        if (path != null) {
            indexPath = new Integer[path.length];
            int i = 0;
            while (i < path.length) {
                indexPath[i] = new Integer(IndexConverter.intValue(path[i]));
                ++i;
            }
        }
        return IndexConverter.toImplementationIndices(indexPath);
    }

    protected INodePath createStringNodePath(String[] treePath, String operator) {
        return new StringNodePath(treePath, operator);
    }

    protected INodePath createIndexNodePath(Integer[] treePath) {
        return new IndexNodePath(treePath);
    }

    protected void traverseTreeByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        ITreeAdapter adapter = this.getTreeAdapter();
        AbstractTreeOperationContext context = adapter.getContext();
        PathBasedTraverser traverser = new PathBasedTraverser(context, treePath);
        ((AbstractTreeNodeTraverser)traverser).traversePath(operation, this.getStartNode(pathType, preAscend, context));
    }

    protected void traverseLastElementByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        Object startNode = this.getStartNode(pathType, preAscend, context);
        PathBasedTraverser traverser = new PathBasedTraverser(context, treePath, new TreeNodeOperationConstraint());
        ((AbstractTreeNodeTraverser)traverser).traversePath(operation, startNode);
    }

    private void selectByPath(String pathType, int preAscend, INodePath objectPath, ClickOptions co) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(co);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, selectOp);
    }

    protected Object getSelectedNode(AbstractTreeOperationContext context) {
        return context.getSelectedNode();
    }

    public void gdClick(int count, int button) {
        if (this.getRobot().isMouseInComponent(this.getTreeAdapter().getRealComponent())) {
            this.getRobot().clickAtCurrentPosition(this.getTreeAdapter().getRealComponent(), count, button);
        } else {
            this.getRobot().click(this.getTreeAdapter().getRealComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button));
        }
    }

    public void gdCollapse(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.traverseLastElementByPath(this.createStringNodePath(this.splitTextTreePath(treePath), operator), pathType, preAscend, new ExpandCollapseTreeNodeOperation(true));
    }

    public void gdCollapseByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        try {
            this.traverseLastElementByPath(this.createIndexNodePath(this.splitIndexTreePath(indexPath)), pathType, preAscend, new ExpandCollapseTreeNodeOperation(true));
        }
        catch (NumberFormatException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void gdExpand(String pathType, int preAscend, String treePath, String operator) throws StepExecutionException {
        this.traverseTreeByPath(this.createStringNodePath(this.splitTextTreePath(treePath), operator), pathType, preAscend, new ExpandCollapseTreeNodeOperation(false));
    }

    public void gdExpandByIndices(String pathType, int preAscend, String indexPath) throws StepExecutionException {
        try {
            this.traverseTreeByPath(this.createIndexNodePath(this.splitIndexTreePath(indexPath)), pathType, preAscend, new ExpandCollapseTreeNodeOperation(false));
        }
        catch (NumberFormatException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public void gdMove(String direction, int distance, int clickCount) throws StepExecutionException {
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        Object selectedNode = this.getSelectedNode(context);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(ClickOptions.create().setClickCount(clickCount));
        TreeNodeOperationConstraint constraint = new TreeNodeOperationConstraint();
        if ("up".equalsIgnoreCase(direction)) {
            ParentTraverser traverser = new ParentTraverser(context, distance, constraint);
            ((AbstractTreeNodeTraverser)traverser).traversePath(selectOp, selectedNode);
        } else if ("down".equalsIgnoreCase(direction)) {
            ExpandCollapseTreeNodeOperation expandOp = new ExpandCollapseTreeNodeOperation(false);
            ChildTraverser expandTraverser = new ChildTraverser(context, distance - 1);
            ((AbstractTreeNodeTraverser)expandTraverser).traversePath(expandOp, selectedNode);
            ChildTraverser selectTraverser = new ChildTraverser(context, distance, constraint);
            ((AbstractTreeNodeTraverser)selectTraverser).traversePath(selectOp, selectedNode);
        } else if ("next".equalsIgnoreCase(direction)) {
            SiblingTraverser traverser = new SiblingTraverser(context, distance, true, constraint);
            ((AbstractTreeNodeTraverser)traverser).traversePath(selectOp, selectedNode);
        } else if ("previous".equalsIgnoreCase(direction)) {
            SiblingTraverser traverser = new SiblingTraverser(context, distance, false, constraint);
            ((AbstractTreeNodeTraverser)traverser).traversePath(selectOp, selectedNode);
        }
    }

    public void gdSelect(String pathType, int preAscend, String treePath, String operator, int clickCount, int button, String extendSelection) throws StepExecutionException {
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    public void gdSelectByIndices(String pathType, int preAscend, String indexPath, int clickCount, int button, String extendSelection) throws StepExecutionException {
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button).setClickModifier(this.getClickModifier(extendSelection)));
    }

    public void gdVerifyPath(String pathType, int preAscend, String treePath, String operator, boolean exists) {
        try {
            this.gdExpand(pathType, preAscend, treePath, operator);
        }
        catch (StepExecutionException stepExecutionException) {
            if (exists) {
                throw new StepVerifyFailedException("Verify failed on tree-path: " + treePath, EventFactory.createVerifyFailed((String)treePath, (String)""));
            }
            return;
        }
        if (!exists) {
            throw new StepVerifyFailedException("Verify failed on tree-path: ", EventFactory.createVerifyFailed((String)"", (String)treePath));
        }
    }

    public void gdVerifyPathByIndices(String pathType, int preAscend, String treePath, boolean exists) {
        try {
            this.gdExpandByIndices(pathType, preAscend, treePath);
        }
        catch (StepExecutionException stepExecutionException) {
            if (exists) {
                throw new StepVerifyFailedException("Verify failed on tree-path: " + treePath, EventFactory.createVerifyFailed((String)treePath, (String)""));
            }
            return;
        }
        if (!exists) {
            throw new StepVerifyFailedException("Verify failed on tree-path: ", EventFactory.createVerifyFailed((String)"", (String)treePath));
        }
    }

    public String gdStoreSelectedNodeValue(String variable) {
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        Object selectedNode = this.getSelectedNode(context);
        if (selectedNode == null) {
            throw new StepExecutionException("No tree item selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        return context.getRenderedText(selectedNode);
    }

    public String gdStoreValueAtMousePosition(String variable) {
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        return context.getRenderedText(this.getNodeAtMousePosition());
    }

    protected abstract Object getNodeAtMousePosition() throws StepExecutionException;

    public void gdVerifySelectedValue(String selection) throws StepExecutionException {
        this.gdVerifySelectedValue(selection, "equals");
    }

    public void gdVerifySelectedValue(String pattern, String operator) throws StepExecutionException {
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        this.checkNodeText(this.getSelectedNode(context), pattern, operator);
    }

    protected void checkNodeText(Object node, String pattern, String operator) throws StepVerifyFailedException {
        AbstractTreeOperationContext context = this.getTreeAdapter().getContext();
        Collection nodeTextList = context.getNodeTextList(node);
        Iterator it = nodeTextList.iterator();
        boolean isMatched = false;
        while (it.hasNext() && !isMatched) {
            try {
                Verifier.match((String)it.next(), pattern, operator);
                isMatched = true;
            }
            catch (StepVerifyFailedException svfe) {
                if (it.hasNext()) continue;
                throw svfe;
            }
        }
    }

    protected Object getStartNode(String pathType, int preAscend, AbstractTreeOperationContext context) {
        Object startNode;
        ITreeAdapter tree = this.getTreeAdapter();
        if (pathType.equals("relative")) {
            Object child = startNode = this.getSelectedNode(context);
            int i = 0;
            while (i < preAscend) {
                if (startNode == null || tree.isRootVisible() && tree.getRootNode() == null) {
                    TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.TreeNodeNotFound");
                    throw new StepExecutionException("Tree node not found: Parent of " + child.toString(), event);
                }
                child = startNode;
                startNode = context.getParent(startNode);
                ++i;
            }
            if (startNode == null || tree.isRootVisible() && tree.getRootNode() == null) {
                startNode = null;
            }
        } else if (pathType.equals("absolute")) {
            startNode = null;
        } else {
            throw new StepExecutionException(String.valueOf(pathType) + " is not a valid Path Type", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
        }
        return startNode;
    }

    public abstract void gdDragByTextPath(int var1, String var2, String var3, int var4, String var5, String var6);

    public abstract void gdDropByTextPath(String var1, int var2, String var3, String var4, int var5);

    public abstract void gdDragByIndexPath(int var1, String var2, String var3, int var4, String var5);

    public abstract void gdDropByIndexPath(String var1, int var2, String var3, int var4);
}

