/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.tester.AbstractTextInputSupportTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComboBoxAdapter;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class ComboBoxTester
extends AbstractTextInputSupportTester {
    private IComboBoxAdapter getCBAdapter() {
        return (IComboBoxAdapter)this.getComponent();
    }

    public String[] getTextArrayFromComponent() {
        return new String[]{this.getText()};
    }

    public void gdVerifyEditable(boolean editable) {
        Verifier.equals(editable, this.getCBAdapter().isEditable());
    }

    public void gdVerifyContainsValue(String text) {
        Verifier.equals(true, this.containsValue(text, "equals"));
    }

    public void gdVerifyContainsValue(String value, String operator, boolean exists) {
        boolean contains = this.containsValue(value, operator);
        Verifier.equals(exists, contains);
    }

    private boolean containsValue(String value, String operator) {
        String[] comboValues = this.getCBAdapter().getValues();
        int i = 0;
        while (i < comboValues.length) {
            boolean contains = MatchUtil.getInstance().match(comboValues[i], value, operator);
            if (contains) {
                return contains;
            }
            ++i;
        }
        return false;
    }

    protected String getText() {
        return this.getCBAdapter().getText();
    }

    public void gdInputText(String text) {
        this.getCBAdapter().input(text, false);
    }

    public void gdReplaceText(String text) throws StepExecutionException {
        this.getCBAdapter().input(text, true);
    }

    public void gdSelectIndex(String index) {
        int implIdx = IndexConverter.toImplementationIndex(IndexConverter.intValue(index));
        this.getCBAdapter().select(implIdx);
    }

    public void gdSelectValue(String value, String operator, String searchType) {
        String[] comboValues = this.getCBAdapter().getValues();
        Validate.notNull((Object)value, (String)"text must not be null");
        int index = -1;
        int i = this.getStartingIndex(searchType);
        while (i < comboValues.length) {
            String str = comboValues[i];
            if (MatchUtil.getInstance().match(str, value, operator)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            throw new StepExecutionException("Text '" + value + "' not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.getCBAdapter().select(index);
    }

    public void gdVerifySelectedIndex(String index, boolean isSelected) {
        int implIdx = IndexConverter.toImplementationIndex(IndexConverter.intValue(index));
        int actual = this.getCBAdapter().getSelectedIndex();
        Verifier.equals(implIdx, actual, isSelected);
    }

    public void gdVerifyText(String text) {
        this.gdVerifyText(text, "equals");
    }

    private int getStartingIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            startingIndex = this.getCBAdapter().getSelectedIndex();
        }
        return startingIndex;
    }
}

