/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.eclipse.jubula.communication.Communicator;
import org.eclipse.jubula.communication.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.businessprocess.ReflectionBP;
import org.eclipse.jubula.rc.common.commands.ChangeAUTModeCommand;
import org.eclipse.jubula.rc.common.listener.AUTEventListener;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.factory.GUIAdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponentAdapter;
import org.eclipse.jubula.rc.swing.listener.BaseAWTEventListener;
import org.eclipse.jubula.rc.swing.listener.IEventListener;
import org.eclipse.jubula.rc.swing.listener.KeyAcceptor;
import org.eclipse.jubula.tools.exception.CommunicationException;

public abstract class AbstractAutSwingEventListener
extends BaseAWTEventListener
implements IEventListener,
AUTEventListener {
    protected static final int REPAINT_DELAY = 5;
    private static AutServerLogger log;
    private static final long[] EVENT_MASK;
    private Object m_componentLock = new Object();
    private Component m_currentComponent = null;
    private KeyAcceptor m_acceptor = new KeyAcceptor();
    private AWTEvent m_lastEvent;
    private boolean m_isHighLighted = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.listener.AbstractAutSwingEventListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
        EVENT_MASK = new long[]{16L, 32L, 8L, 512L, 128L, 1024L, 4L, 1L, 64L, 524288L, 262144L};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void eventDispatched(AWTEvent event) {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.handleEvent(event);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            Thread.currentThread().setContextClassLoader(oldCL);
            throw throwable;
        }
        {
            Object var3_5 = null;
            Thread.currentThread().setContextClassLoader(oldCL);
            return;
        }
    }

    protected abstract void handleEvent(AWTEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        Object object = this.m_componentLock;
        synchronized (object) {
            block9: {
                if (this.getCurrentComponent() != null) {
                    try {
                        IComponentAdapter adapter = GUIAdapterFactoryRegistry.getInstance().getAdapter((Object)this.getCurrentComponent());
                        if (adapter == null) break block9;
                        Class[] classArray = new Class[1];
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("java.awt.Component");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz;
                        ReflectionBP.invokeMethod((String)"lowLight", (Object)adapter, (Class[])classArray, (Object[])new Object[]{this.m_currentComponent});
                        this.setHighLighted(false);
                    }
                    catch (IllegalArgumentException iae) {
                        log.error((Object)iae);
                    }
                }
            }
        }
    }

    protected void changeCheckModeState(int mode) {
        ChangeAUTModeMessage msg = new ChangeAUTModeMessage();
        msg.setMode(mode);
        msg.setKey(AUTServerConfiguration.getInstance().getKey());
        msg.setKeyModifier(AUTServerConfiguration.getInstance().getKeyMod());
        msg.setKey2(AUTServerConfiguration.getInstance().getKey2());
        msg.setKey2Modifier(AUTServerConfiguration.getInstance().getKey2Mod());
        msg.setCheckModeKey(AUTServerConfiguration.getInstance().getCheckModeKey());
        msg.setCheckModeKeyModifier(AUTServerConfiguration.getInstance().getCheckModeKeyMod());
        msg.setCheckCompKey(AUTServerConfiguration.getInstance().getCheckCompKey());
        msg.setCheckCompKeyModifier(AUTServerConfiguration.getInstance().getCheckCompKeyMod());
        msg.setSingleLineTrigger(AUTServerConfiguration.getInstance().getSingleLineTrigger());
        msg.setMultiLineTrigger(AUTServerConfiguration.getInstance().getMultiLineTrigger());
        ChangeAUTModeCommand cmd = new ChangeAUTModeCommand();
        cmd.setMessage((Message)msg);
        try {
            Communicator clientCommunicator = AUTServer.getInstance().getCommunicator();
            if (clientCommunicator != null && clientCommunicator.getConnection() != null) {
                AUTServer.getInstance().getCommunicator().send(cmd.execute());
            }
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
    }

    public long[] getEventMask() {
        long[] eventMask = EVENT_MASK;
        return eventMask;
    }

    protected AWTEvent getLastEvent() {
        return this.m_lastEvent;
    }

    protected void setLastEvent(AWTEvent lastEvent) {
        this.m_lastEvent = lastEvent;
    }

    protected Object getComponentLock() {
        return this.m_componentLock;
    }

    protected Component getCurrentComponent() {
        return this.m_currentComponent;
    }

    protected void setCurrentComponent(Component currentComponent) {
        this.m_currentComponent = currentComponent;
    }

    protected KeyAcceptor getAcceptor() {
        return this.m_acceptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void highlight(Component source, Object implClass, Color highlightColor) {
        IComponentAdapter adapter = GUIAdapterFactoryRegistry.getInstance().getAdapter((Object)source);
        Object object = this.getComponentLock();
        synchronized (object) {
            if (this.getCurrentComponent() != null && this.getCurrentComponent() != source) {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.awt.Component");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                ReflectionBP.invokeMethod((String)"lowLight", (Object)adapter, (Class[])classArray, (Object[])new Object[]{this.getCurrentComponent()});
                this.setHighLighted(false);
            }
            this.setCurrentComponent(source);
            Window windowAncestor = SwingUtilities.getWindowAncestor(this.getCurrentComponent());
            if (windowAncestor != null && windowAncestor.getFocusOwner() != null) {
                Class[] classArray = new Class[2];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.awt.Component");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.awt.Color");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                ReflectionBP.invokeMethod((String)"highLight", (Object)adapter, (Class[])classArray, (Object[])new Object[]{this.getCurrentComponent(), highlightColor});
                this.setHighLighted(true);
            }
        }
    }

    protected void highlightClicked(Object implClass, final Color highlightColor) {
        Timer timer = new Timer(5, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Object object = AbstractAutSwingEventListener.this.getComponentLock();
                synchronized (object) {
                    if (AbstractAutSwingEventListener.this.getCurrentComponent() != null && AbstractAutSwingEventListener.this.getCurrentComponent().isShowing() && SwingUtilities.getWindowAncestor(AbstractAutSwingEventListener.this.getCurrentComponent()) != null && SwingUtilities.getWindowAncestor(AbstractAutSwingEventListener.this.getCurrentComponent()).getFocusOwner() != null) {
                        IComponentAdapter adapter = GUIAdapterFactoryRegistry.getInstance().getAdapter((Object)AbstractAutSwingEventListener.this.getCurrentComponent());
                        Class[] classArray = new Class[2];
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("java.awt.Component");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[0] = clazz;
                        Class<?> clazz2 = class$2;
                        if (clazz2 == null) {
                            try {
                                clazz2 = class$2 = Class.forName("java.awt.Color");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        classArray[1] = clazz2;
                        ReflectionBP.invokeMethod((String)"highLight", (Object)adapter, (Class[])classArray, (Object[])new Object[]{AbstractAutSwingEventListener.this.getCurrentComponent(), highlightColor});
                        AbstractAutSwingEventListener.this.setHighLighted(true);
                    }
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    protected void updateHighlighting(Component source, Object implClass, Color highlightColor) {
        if (this.isHighLighted()) {
            this.highlight(source, implClass, highlightColor);
        }
    }

    public boolean isHighLighted() {
        return this.m_isHighLighted;
    }

    protected void setHighLighted(boolean isHighLighted) {
        this.m_isHighLighted = isHighLighted;
    }
}

