/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.WindowEvent;
import java.util.EventListener;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.exception.ComponentNotManagedException;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.implclasses.IComponentFactory;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.components.AUTSwingHierarchy;
import org.eclipse.jubula.rc.swing.listener.BaseAWTEventListener;
import org.eclipse.jubula.tools.exception.InvalidDataException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;

public class ComponentHandler
extends BaseAWTEventListener
implements BaseAUTListener {
    private static AutServerLogger log;
    private static final long[] EVENT_MASK;
    private static AUTSwingHierarchy autHierarchy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.listener.ComponentHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
        EVENT_MASK = new long[]{64L, 2L, 1L};
        autHierarchy = new AUTSwingHierarchy();
    }

    public static IComponentIdentifier getIdentifier(Component component) throws NoIdentifierForComponentException {
        try {
            return autHierarchy.getComponentIdentifier(component);
        }
        catch (ComponentNotManagedException cnme) {
            log.warn((Object)cnme);
            throw new NoIdentifierForComponentException("unable to create an identifier for '" + component + "'", MessageIDs.E_COMPONENT_ID_CREATION);
        }
    }

    public static void addToHierarchy(IComponentFactory factory, String componentName, String technicalName) throws UnsupportedComponentException {
        autHierarchy.addToHierarchy(factory, componentName, technicalName);
    }

    public static IComponentIdentifier[] getAllComponentId() {
        return autHierarchy.getAllComponentId();
    }

    /*
     * Unable to fully structure code
     */
    public static Component findComponent(IComponentIdentifier componentIdentifier, boolean retry, int timeout) throws ComponentNotFoundException, IllegalArgumentException {
        block9: {
            start = System.currentTimeMillis();
            try {
                return ComponentHandler.autHierarchy.findComponent(componentIdentifier);
            }
            catch (ComponentNotManagedException cnme) {
                if (!retry) break block9;
                ** while (System.currentTimeMillis() - start < (long)timeout)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    Thread.sleep(500L);
                    return ComponentHandler.autHierarchy.findComponent(componentIdentifier);
                }
                catch (InterruptedException v0) {
                }
                catch (ComponentNotManagedException v1) {
                }
                catch (InvalidDataException v2) {}
                continue;
            }
        }
        throw new ComponentNotFoundException(cnme.getMessage(), MessageIDs.E_COMPONENT_NOT_FOUND);
        catch (IllegalArgumentException iae) {
            ComponentHandler.log.error((Object)iae);
            throw iae;
        }
        catch (InvalidDataException ide) {
            ComponentHandler.log.error((Object)ide);
            throw new ComponentNotFoundException(ide.getMessage(), MessageIDs.E_COMPONENT_NOT_FOUND);
        }
    }

    public long[] getEventMask() {
        long[] eventMask = EVENT_MASK;
        return eventMask;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void eventDispatched(AWTEvent event) {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)event.paramString());
                }
                int id = event.getID();
                switch (id) {
                    case 200: 
                    case 205: {
                        Window window = ((WindowEvent)event).getWindow();
                        autHierarchy.add(window);
                        break;
                    }
                    case 300: {
                        this.checkContainerListener((ContainerEvent)event);
                        break;
                    }
                    case 103: {
                        ComponentEvent componentEvent = (ComponentEvent)event;
                        Component component = componentEvent.getComponent();
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            Class<?> clazz2;
                            try {
                                clazz2 = Class.forName("java.awt.event.ComponentListener");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$1 = clazz2;
                        }
                        if (this.hasListener(component, clazz)) break;
                        autHierarchy.componentHidden(componentEvent);
                        break;
                    }
                    case 102: {
                        ComponentEvent componentEvent = (ComponentEvent)event;
                        Component component = componentEvent.getComponent();
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("java.awt.event.ComponentListener");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$1 = clazz3;
                        }
                        if (this.hasListener(component, clazz)) break;
                        autHierarchy.componentShown(componentEvent);
                        break;
                    }
                }
                if (AUTServer.getInstance().getMode() == 2) {
                    AUTServer.getInstance().updateHighLighter();
                }
            }
            catch (Throwable t) {
                log.error((Object)"exception during ComponentHandler", t);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Thread.currentThread().setContextClassLoader(originalCL);
            throw throwable;
        }
        {
            Object var6_10 = null;
            Thread.currentThread().setContextClassLoader(originalCL);
            return;
        }
    }

    private void checkContainerListener(ContainerEvent event) {
        Container container = event.getContainer();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.awt.event.ContainerListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!this.hasListener(container, clazz) && autHierarchy.getHierarchyContainer(event.getContainer()) != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"ComponentHandler called: autHierarchy.componentAdded");
            }
            autHierarchy.componentAdded(event);
        }
    }

    private boolean hasListener(Component component, Class listenerClass) {
        EventListener[] listener = component.getListeners(listenerClass);
        int length = listener.length;
        int i = 0;
        while (i < length) {
            if (listener[i] instanceof AUTSwingHierarchy) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static AUTSwingHierarchy getAutHierarchy() {
        return autHierarchy;
    }
}

