/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ContainerEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.adaptable.ITextRendererAdapter;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotFactory;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.swing.driver.RobotFactoryConfig;
import org.eclipse.jubula.rc.swing.swing.driver.KeyCodeConverter;
import org.eclipse.jubula.rc.swing.swing.implclasses.EventListener;
import org.eclipse.jubula.rc.swing.swing.implclasses.HighLighter;
import org.eclipse.jubula.rc.swing.swing.implclasses.IImplementationClass;
import org.eclipse.jubula.rc.swing.swing.implclasses.MenuUtil;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.TimeUtil;

public abstract class AbstractSwingImplClass
implements IImplementationClass {
    public static final String RENDERER_FALLBACK_TEXT_GETTER_METHOD_1 = "getTestableText";
    public static final String RENDERER_FALLBACK_TEXT_GETTER_METHOD_2 = "getText";
    public static final char INDEX_LIST_SEP_CHAR = ',';
    public static final char VALUE_SEPARATOR = ',';
    protected static final String POS_UNIT_PIXEL = "Pixel";
    protected static final String POS_UNI_PERCENT = "Percent";
    private static AutServerLogger log;
    private final HighLighter m_highLighter = new HighLighter();
    private IRobotFactory m_robotFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public abstract JComponent getComponent();

    protected IRobotFactory getRobotFactory() {
        if (this.m_robotFactory == null) {
            this.m_robotFactory = new RobotFactoryConfig().getRobotFactory();
        }
        return this.m_robotFactory;
    }

    protected IRobot getRobot() throws RobotException {
        return this.getRobotFactory().getRobot();
    }

    protected IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    protected void verify(boolean expected, String name, IRunnable runnable) throws StepVerifyFailedException {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait(name, runnable);
        Verifier.equals((boolean)expected, (boolean)actual);
    }

    public void highLight(Component component, Color border) {
        try {
            final Component comp = component;
            final Color col = border;
            this.getEventThreadQueuer().invokeLater("highLight", new Runnable(){

                public void run() {
                    AbstractSwingImplClass.this.m_highLighter.highLight(comp, col);
                }
            });
        }
        catch (StepExecutionException bsee) {
            log.error((Object)bsee);
        }
    }

    public void lowLight(Component component) {
        try {
            final Component comp = component;
            this.getEventThreadQueuer().invokeLater("lowLight", new Runnable(){

                public void run() {
                    AbstractSwingImplClass.this.m_highLighter.lowLight(comp);
                }
            });
        }
        catch (StepExecutionException bsee) {
            log.error((Object)bsee);
        }
    }

    public static String getRenderedText(Component renderer) throws StepExecutionException {
        String renderedText = AbstractSwingImplClass.resolveRenderedText(renderer);
        if (renderedText != null) {
            return renderedText;
        }
        throw new StepExecutionException("Renderer not supported: " + renderer.getClass(), EventFactory.createActionError((String)"TestErrorEvent.RendererNotSupported"));
    }

    public static String resolveRenderedText(Component renderer) {
        ITextRendererAdapter textRendererAdapter;
        if (renderer instanceof JLabel) {
            return ((JLabel)renderer).getText();
        }
        if (renderer instanceof JToggleButton) {
            return ((JToggleButton)renderer).isSelected() ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        }
        if (renderer instanceof AbstractButton) {
            return ((AbstractButton)renderer).getText();
        }
        if (renderer instanceof JTextComponent) {
            return ((JTextComponent)renderer).getText();
        }
        AdapterFactoryRegistry adapterFactoryRegistry = AdapterFactoryRegistry.getInstance();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jubula.rc.common.adaptable.ITextRendererAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((textRendererAdapter = (ITextRendererAdapter)adapterFactoryRegistry.getAdapter((Class)clazz, (Object)renderer)) != null) {
            return textRendererAdapter.getText();
        }
        if (renderer != null) {
            String[] methodNames = new String[]{RENDERER_FALLBACK_TEXT_GETTER_METHOD_1, RENDERER_FALLBACK_TEXT_GETTER_METHOD_2};
            int i = 0;
            while (i < methodNames.length) {
                String text = AbstractSwingImplClass.getTextFromComponent(renderer, methodNames[i]);
                if (text != null) {
                    return text;
                }
                ++i;
            }
        }
        return null;
    }

    private static String getTextFromComponent(Object obj, String getterName) {
        String text = null;
        try {
            Method getter = null;
            Class<?> objClass = obj.getClass();
            try {
                getter = objClass.getDeclaredMethod(getterName, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {}
            if (getter == null) {
                try {
                    getter = objClass.getMethod(getterName, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return text;
                }
                catch (SecurityException securityException) {
                    return text;
                }
            }
            getter.setAccessible(true);
            Object returnValue = getter.invoke(obj, null);
            if (returnValue instanceof String) {
                text = (String)returnValue;
            }
            return text;
        }
        catch (SecurityException securityException) {
            return text;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return text;
        }
        catch (IllegalAccessException illegalAccessException) {
            return text;
        }
        catch (InvocationTargetException invocationTargetException) {
            return text;
        }
    }

    protected String getRenderedText(final Component renderer, boolean queueInEventThread) throws StepExecutionException {
        if (queueInEventThread) {
            return (String)this.getEventThreadQueuer().invokeAndWait("getRenderedText", new IRunnable(){

                public Object run() {
                    return AbstractSwingImplClass.getRenderedText(renderer);
                }
            });
        }
        return AbstractSwingImplClass.getRenderedText(renderer);
    }

    protected abstract String getText();

    public void gdVerifyEnabled(boolean enabled) {
        this.verify(enabled, "isEnabled", new IRunnable(){

            public Object run() {
                return AbstractSwingImplClass.this.getComponent().isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyExists(boolean exists) {
        this.verify(exists, "exists", new IRunnable(){

            public Object run() {
                return AbstractSwingImplClass.this.getComponent().isShowing() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyFocus(boolean hasFocus) {
        this.verify(hasFocus, "hasFocus", new IRunnable(){

            public Object run() {
                return AbstractSwingImplClass.this.getComponent().hasFocus() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyProperty(String name, String value, String operator) {
        try {
            String propToStr = this.getRobot().getPropertyValue((Object)this.getComponent(), name);
            Verifier.match((String)propToStr, (String)value, (String)operator);
        }
        catch (RobotException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
        }
    }

    public String gdStorePropertyValue(String variableName, String propertyName) {
        String propertyValue = "";
        try {
            propertyValue = this.getRobot().getPropertyValue((Object)this.getComponent(), propertyName);
        }
        catch (RobotException e) {
            throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
        }
        return propertyValue;
    }

    public void gdClick(int count, int button) {
        this.getRobot().click((Object)this.getComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button));
    }

    public void gdClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.getRobot().click((Object)this.getComponent(), null, ClickOptions.create().setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase(POS_UNIT_PIXEL), yPos, yUnits.equalsIgnoreCase(POS_UNIT_PIXEL));
    }

    public void gdPopupSelectByIndexPath(String indexPath) throws StepExecutionException {
        this.gdPopupSelectByIndexPath(indexPath, 3);
    }

    public void gdPopupSelectByIndexPath(String indexPath, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(button);
        this.selectMenuItem(popup, MenuUtil.splitIndexPath(indexPath));
    }

    public void gdPopupSelectByIndexPath(int xPos, int yPos, String units, String indexPath) throws StepExecutionException {
        this.gdPopupSelectByIndexPath(xPos, units, yPos, units, indexPath, 3);
    }

    public void gdPopupSelectByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(xPos, xUnits, yPos, yUnits, button);
        this.selectMenuItem(popup, MenuUtil.splitIndexPath(indexPath));
    }

    public void gdWaitForComponent(int timeout, int delay) {
    }

    public void gdPopupSelectByTextPath(String textPath, String operator) throws StepExecutionException {
        this.gdPopupSelectByTextPath(textPath, operator, 3);
    }

    public void gdPopupSelectByTextPath(String textPath, String operator, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(button);
        this.selectMenuItem(popup, MenuUtil.splitPath(textPath), operator);
    }

    public void gdPopupSelectByTextPath(int xPos, int yPos, String units, String textPath, String operator) throws StepExecutionException {
        this.gdPopupSelectByTextPath(xPos, units, yPos, units, textPath, operator, 3);
    }

    public void gdPopupSelectByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(xPos, xUnits, yPos, yUnits, button);
        this.selectMenuItem(popup, MenuUtil.splitPath(textPath), operator);
    }

    public void gdPopupVerifyEnabledByIndexPath(String indexPath, boolean enabled, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(button);
        this.popupVerifyEnabledByIndexPath(indexPath, popup, enabled);
    }

    public void gdPopupVerifyEnabledByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean enabled, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyEnabledByIndexPath(indexPath, popup, enabled);
    }

    public void gdPopupVerifyEnabledByTextPath(String textPath, String operator, boolean enabled, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(button);
        this.popupVerifyEnabledByTextPath(textPath, operator, popup, enabled);
    }

    public void gdPopupVerifyEnabledByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean enabled, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyEnabledByTextPath(textPath, operator, popup, enabled);
    }

    public void gdPopupVerifyExistsByIndexPath(String indexPath, boolean exists, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(button);
        this.popupVerifyExistsByIndexPath(indexPath, popup, exists);
    }

    public void gdPopupVerifyExistsByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean exists, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyExistsByIndexPath(indexPath, popup, exists);
    }

    public void gdPopupVerifyExistsByTextPath(String textPath, String operator, boolean exists, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(button);
        this.popupVerifyExistsByTextPath(textPath, operator, popup, exists);
    }

    public void gdPopupVerifyExistsByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean exists, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyExistsByTextPath(textPath, operator, popup, exists);
    }

    public void gdPopupVerifySelectedByIndexPath(String indexPath, boolean selected, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(button);
        this.popupVerifySelectedByIndexPath(indexPath, popup, selected);
    }

    public void gdPopupVerifySelectedByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean selected, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(xPos, xUnits, yPos, yUnits, button);
        this.popupVerifySelectedByIndexPath(indexPath, popup, selected);
    }

    public void gdPopupVerifySelectedByTextPath(String textPath, String operator, boolean selected, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(button);
        this.popupVerifySelectedByTextPath(textPath, operator, popup, selected);
    }

    public void gdPopupVerifySelectedByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean selected, int button) throws StepExecutionException {
        JPopupMenu popup = this.showPopup(xPos, xUnits, yPos, yUnits, button);
        this.popupVerifySelectedByTextPath(textPath, operator, popup, selected);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyEnabledByIndexPath(String indexPath, JPopupMenu popup, boolean enabled) {
        block8: {
            block7: {
                Throwable throwable2;
                block10: {
                    block9: {
                        int[] menuItem = MenuUtil.splitIndexPath(indexPath);
                        if (menuItem.length == 0) {
                            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
                        }
                        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), popup, menuItem);
                        try {
                            if (item == null) {
                                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                            }
                            this.verify(enabled, "popupVerifyEnabledByIndexPath", new IRunnable(){

                                public Object run() {
                                    return item != null && item instanceof JMenuItem && item.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
                                }
                            });
                            Object var6_8 = null;
                            if (!true) break block7;
                            if (popup == null) return;
                            if (!popup.isVisible()) break block8;
                        }
                        catch (Throwable throwable2) {
                            Object var6_7 = null;
                            if (!true) break block9;
                            if (popup == null) throw throwable2;
                            if (!popup.isVisible()) break block10;
                        }
                    }
                    do {
                        MenuUtil.closePopupMenu(this.getRobot(), popup);
                        if (popup == null) throw throwable2;
                    } while (popup.isVisible());
                }
                throw throwable2;
            }
            do {
                MenuUtil.closePopupMenu(this.getRobot(), popup);
                if (popup == null) return;
            } while (popup.isVisible());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyEnabledByTextPath(String textPath, String operator, JPopupMenu popup, boolean enabled) throws StepExecutionException {
        block8: {
            block7: {
                Throwable throwable2;
                block10: {
                    block9: {
                        String[] itemPath = MenuUtil.splitPath(textPath);
                        if (itemPath.length == 0) {
                            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
                        }
                        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), popup, itemPath, operator);
                        try {
                            if (item == null) {
                                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                            }
                            this.verify(enabled, "popupVerifyEnabledByTextPath", new IRunnable(){

                                public Object run() {
                                    return item != null && item instanceof JMenuItem && item.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
                                }
                            });
                            Object var7_9 = null;
                            if (!true) break block7;
                            if (popup == null) return;
                            if (!popup.isVisible()) break block8;
                        }
                        catch (Throwable throwable2) {
                            Object var7_8 = null;
                            if (!true) break block9;
                            if (popup == null) throw throwable2;
                            if (!popup.isVisible()) break block10;
                        }
                    }
                    do {
                        MenuUtil.closePopupMenu(this.getRobot(), popup);
                        if (popup == null) throw throwable2;
                    } while (popup.isVisible());
                }
                throw throwable2;
            }
            do {
                MenuUtil.closePopupMenu(this.getRobot(), popup);
                if (popup == null) return;
            } while (popup.isVisible());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyExistsByIndexPath(String indexPath, JPopupMenu popup, boolean exists) {
        block7: {
            block6: {
                Throwable throwable2;
                block9: {
                    block8: {
                        int[] menuItem = MenuUtil.splitIndexPath(indexPath);
                        if (menuItem.length == 0) {
                            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
                        }
                        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), popup, menuItem);
                        try {
                            this.verify(exists, "popupVerifyExistsByIndexPath", new IRunnable(){

                                public Object run() {
                                    return item != null && item instanceof JMenuItem ? Boolean.TRUE : Boolean.FALSE;
                                }
                            });
                            Object var6_8 = null;
                            if (!true) break block6;
                            if (popup == null) return;
                            if (!popup.isVisible()) break block7;
                        }
                        catch (Throwable throwable2) {
                            Object var6_7 = null;
                            if (!true) break block8;
                            if (popup == null) throw throwable2;
                            if (!popup.isVisible()) break block9;
                        }
                    }
                    do {
                        MenuUtil.closePopupMenu(this.getRobot(), popup);
                        if (popup == null) throw throwable2;
                    } while (popup.isVisible());
                }
                throw throwable2;
            }
            do {
                MenuUtil.closePopupMenu(this.getRobot(), popup);
                if (popup == null) return;
            } while (popup.isVisible());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyExistsByTextPath(String textPath, String operator, JPopupMenu popup, boolean exists) throws StepExecutionException {
        block7: {
            block6: {
                Throwable throwable2;
                block9: {
                    block8: {
                        String[] menuItem = MenuUtil.splitPath(textPath);
                        if (menuItem.length == 0) {
                            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError((String)"TestErrorEvent.InvalidParameterValue"));
                        }
                        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), popup, menuItem, operator);
                        try {
                            this.verify(exists, "popupVerifyExistsByTextPath", new IRunnable(){

                                public Object run() {
                                    return item != null && item instanceof JMenuItem ? Boolean.TRUE : Boolean.FALSE;
                                }
                            });
                            Object var7_9 = null;
                            if (!true) break block6;
                            if (popup == null) return;
                            if (!popup.isVisible()) break block7;
                        }
                        catch (Throwable throwable2) {
                            Object var7_8 = null;
                            if (!true) break block8;
                            if (popup == null) throw throwable2;
                            if (!popup.isVisible()) break block9;
                        }
                    }
                    do {
                        MenuUtil.closePopupMenu(this.getRobot(), popup);
                        if (popup == null) throw throwable2;
                    } while (popup.isVisible());
                }
                throw throwable2;
            }
            do {
                MenuUtil.closePopupMenu(this.getRobot(), popup);
                if (popup == null) return;
            } while (popup.isVisible());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifySelectedByIndexPath(String indexPath, JPopupMenu popup, boolean selected) throws StepExecutionException {
        block8: {
            block7: {
                Throwable throwable2;
                block10: {
                    block9: {
                        int[] menuItem = MenuUtil.splitIndexPath(indexPath);
                        if (menuItem.length == 0) {
                            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
                        }
                        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), popup, menuItem);
                        try {
                            if (item == null) {
                                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                            }
                            this.verify(selected, "popupVerifySelectedByIndexPath", new IRunnable(){

                                public Object run() {
                                    return item != null && item instanceof JMenuItem && ((JMenuItem)item).isSelected() ? Boolean.TRUE : Boolean.FALSE;
                                }
                            });
                            Object var6_8 = null;
                            if (!true) break block7;
                            if (popup == null) return;
                            if (!popup.isVisible()) break block8;
                        }
                        catch (Throwable throwable2) {
                            Object var6_7 = null;
                            if (!true) break block9;
                            if (popup == null) throw throwable2;
                            if (!popup.isVisible()) break block10;
                        }
                    }
                    do {
                        MenuUtil.closePopupMenu(this.getRobot(), popup);
                        if (popup == null) throw throwable2;
                    } while (popup.isVisible());
                }
                throw throwable2;
            }
            do {
                MenuUtil.closePopupMenu(this.getRobot(), popup);
                if (popup == null) return;
            } while (popup.isVisible());
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifySelectedByTextPath(String textPath, String operator, JPopupMenu popup, boolean selected) throws StepExecutionException {
        block8: {
            block7: {
                Throwable throwable2;
                block10: {
                    block9: {
                        String[] menuItem = MenuUtil.splitPath(textPath);
                        if (menuItem.length == 0) {
                            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
                        }
                        final JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), popup, menuItem, operator);
                        try {
                            if (item == null) {
                                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                            }
                            this.verify(selected, "popupVerifySelectedByTextPath", new IRunnable(){

                                public Object run() {
                                    return item != null && item instanceof JMenuItem && ((JMenuItem)item).isSelected() ? Boolean.TRUE : Boolean.FALSE;
                                }
                            });
                            Object var7_9 = null;
                            if (!true) break block7;
                            if (popup == null) return;
                            if (!popup.isVisible()) break block8;
                        }
                        catch (Throwable throwable2) {
                            Object var7_8 = null;
                            if (!true) break block9;
                            if (popup == null) throw throwable2;
                            if (!popup.isVisible()) break block10;
                        }
                    }
                    do {
                        MenuUtil.closePopupMenu(this.getRobot(), popup);
                        if (popup == null) throw throwable2;
                    } while (popup.isVisible());
                }
                throw throwable2;
            }
            do {
                MenuUtil.closePopupMenu(this.getRobot(), popup);
                if (popup == null) return;
            } while (popup.isVisible());
        }
    }

    protected JPopupMenu showPopup(final int button) {
        Runnable showPopup = new Runnable(){

            public void run() {
                RobotTiming.sleepPreShowPopupDelay();
                ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(AbstractSwingImplClass.this.getComponent().getClass().getClassLoader());
                if (AbstractSwingImplClass.this.getRobot().isMouseInComponent((Object)AbstractSwingImplClass.this.getComponent())) {
                    AbstractSwingImplClass.this.getRobot().clickAtCurrentPosition((Object)AbstractSwingImplClass.this.getComponent(), 1, button);
                } else {
                    AbstractSwingImplClass.this.getRobot().click((Object)AbstractSwingImplClass.this.getComponent(), null, ClickOptions.create().setClickCount(1).setMouseButton(button));
                }
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        };
        return this.showPopup(showPopup);
    }

    private JPopupMenu showPopup(final int xPos, final String xUnits, final int yPos, final String yUnits, final int button) throws StepExecutionException {
        Runnable showPopup = new Runnable(){

            public void run() {
                RobotTiming.sleepPreShowPopupDelay();
                boolean isAbsoluteCoordinatesX = xUnits.equalsIgnoreCase(AbstractSwingImplClass.POS_UNIT_PIXEL);
                boolean isAbsoluteCoordinatesY = yUnits.equalsIgnoreCase(AbstractSwingImplClass.POS_UNIT_PIXEL);
                AbstractSwingImplClass.this.getRobot().click((Object)AbstractSwingImplClass.this.getComponent(), null, ClickOptions.create().setMouseButton(button), xPos, isAbsoluteCoordinatesX, yPos, isAbsoluteCoordinatesY);
            }
        };
        return this.showPopup(showPopup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JPopupMenu showPopup(Runnable showPopupOperation) {
        PopupShownCondition cond = new PopupShownCondition();
        EventLock lock = new EventLock();
        EventListener listener = new EventListener(lock, cond);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 2L);
        showPopupOperation.run();
        EventLock eventLock = lock;
        synchronized (eventLock) {
            try {
                try {
                    long timeout = 10000L;
                    long done = System.currentTimeMillis() + timeout;
                    while (!(lock.isReleased() && cond.getPopup() != null && cond.getPopup().isShowing() || timeout <= 0L)) {
                        lock.wait(timeout);
                        long now = System.currentTimeMillis();
                        timeout = done - now;
                    }
                }
                catch (InterruptedException interruptedException) {}
                Object var12_11 = null;
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                Toolkit.getDefaultToolkit().removeAWTEventListener(listener);
                throw throwable;
            }
        }
        if (lock.isReleased() && cond.getPopup() != null && cond.getPopup().isShowing()) {
            return cond.getPopup();
        }
        throw new StepExecutionException("popup not shown", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
    }

    private void selectMenuItem(JPopupMenu popup, String[] path, String operator) {
        if (path.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), popup, path, operator);
        if (item == null) {
            throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        MenuUtil.clickMenuItem(this.getRobot(), item);
    }

    private void selectMenuItem(JPopupMenu popup, int[] path) {
        if (path.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        JMenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), popup, path);
        if (item == null) {
            throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        MenuUtil.clickMenuItem(this.getRobot(), item);
    }

    protected boolean hasFocus() {
        Boolean hasFocus = (Boolean)this.getEventThreadQueuer().invokeAndWait("hasFocus", new IRunnable(){

            public Object run() {
                return AbstractSwingImplClass.this.getComponent().hasFocus() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return hasFocus;
    }

    public void gdShowText(String text, int textSize, int timePerWord, int windowWidth) {
        throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.UnsupportedOperation"), EventFactory.createActionError((String)"TestErrorEvent.UnsupportedOperation"));
    }

    public void gdDrag(int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        IRobot robot = this.getRobot();
        this.gdClickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
        this.pressOrReleaseModifiers(modifier, true);
        robot.mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDrop(int xPos, String xUnits, int yPos, String yUnits, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        String modifier = dndHelper.getModifier();
        int mouseButton = dndHelper.getMouseButton();
        try {
            this.gdClickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
            AbstractSwingImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.getRobot().mouseRelease(null, null, mouseButton);
            this.pressOrReleaseModifiers(modifier, false);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        this.getRobot().mouseRelease(null, null, mouseButton);
        this.pressOrReleaseModifiers(modifier, false);
    }

    protected void pressOrReleaseModifiers(String modifier, boolean press) {
        IRobot robot = this.getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString((String)modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = KeyCodeConverter.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    static void waitBeforeDrop(int delayBeforeDrop) {
        TimeUtil.delay((long)delayBeforeDrop);
    }

    protected ClickOptions.ClickModifier getClickModifier(String extendSelection) {
        ClickOptions.ClickModifier cm = ClickOptions.ClickModifier.create();
        if ("yes".equalsIgnoreCase(extendSelection)) {
            cm.add(1);
        }
        return cm;
    }

    private static class PopupShownCondition
    implements EventListener.Condition {
        private JPopupMenu m_popup = null;

        private PopupShownCondition() {
        }

        public JPopupMenu getPopup() {
            return this.m_popup;
        }

        public boolean isTrue(AWTEvent event) {
            if (event.getID() != 300) {
                return false;
            }
            ContainerEvent ce = (ContainerEvent)event;
            if (ce.getChild() instanceof JPopupMenu) {
                this.m_popup = (JPopupMenu)ce.getChild();
                return true;
            }
            if (ce.getChild() instanceof Container) {
                Container popupContainer = (Container)ce.getChild();
                int length = popupContainer.getComponents().length;
                int i = 0;
                while (i < length) {
                    if (popupContainer.getComponents()[i] instanceof JPopupMenu) {
                        this.m_popup = (JPopupMenu)popupContainer.getComponents()[i];
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

