/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swing.swing.implclasses.AbstractSwingImplClass;
import org.eclipse.jubula.rc.swing.swing.implclasses.JComboBoxHelper;
import org.eclipse.jubula.rc.swing.swing.interfaces.IJComboBox;
import org.eclipse.jubula.tools.utils.StringParsing;

public class JComboBoxImplClass
extends AbstractSwingImplClass
implements IJComboBox {
    public static final int NO_MAX_WIDTH = -1;
    private JComboBoxHelper m_comboBoxHelper;
    private JComboBox m_comboBox;
    static /* synthetic */ Class class$0;

    public void setComponent(Object graphicsComponent) {
        this.m_comboBox = (JComboBox)graphicsComponent;
    }

    public JComponent getComponent() {
        return this.m_comboBox;
    }

    public JComboBoxHelper getComboBoxHelper() {
        if (this.m_comboBoxHelper == null) {
            this.m_comboBoxHelper = new JComboBoxHelper(this);
        }
        return this.m_comboBoxHelper;
    }

    public void gdVerifyEditable(boolean editable) {
        Verifier.equals((boolean)editable, (boolean)this.getComboBoxHelper().isEditable());
    }

    public void gdVerifySelectedIndex(String index, boolean isSelected) {
        int implIdx = IndexConverter.toImplementationIndex((int)IndexConverter.intValue((String)index));
        IEventThreadQueuer iEventThreadQueuer = this.getEventThreadQueuer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JComboBoxImplClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Integer actual = (Integer)iEventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + ".getSelectedIndex", new IRunnable(){

            public Object run() {
                return new Integer(JComboBoxImplClass.this.m_comboBox.getSelectedIndex());
            }
        });
        Verifier.equals((int)implIdx, (int)actual, (boolean)isSelected);
    }

    public void gdVerifyText(String text, String operator) {
        Verifier.match((String)this.getComboBoxHelper().getText(), (String)text, (String)operator);
    }

    public void gdVerifyText(String text) {
        this.gdVerifyText(text, "equals");
    }

    public void gdVerifyContainsValue(String text) {
        Verifier.equals((boolean)true, (boolean)this.getComboBoxHelper().containsValue(text));
    }

    public void gdVerifyContainsValue(String value, String operator, boolean exists) {
        boolean contains = this.getComboBoxHelper().containsValue(value, operator);
        Verifier.equals((boolean)exists, (boolean)contains);
    }

    public void gdReplaceText(String text) {
        this.getComboBoxHelper().input(text, true);
    }

    public void gdInputText(String text) {
        if (!this.hasFocus()) {
            this.getComboBoxHelper().click(new Integer(1));
        }
        this.getComboBoxHelper().input(text, false);
    }

    public void gdSelectIndex(String index) {
        int implIdx = IndexConverter.toImplementationIndex((int)IndexConverter.intValue((String)index));
        double maxWidth = this.getMaxWidth();
        try {
            this.getComboBoxHelper().select(implIdx, maxWidth);
        }
        catch (StepExecutionException e) {
            this.m_comboBox.hidePopup();
            throw e;
        }
    }

    private double getMaxWidth() {
        double maxWidth = -1.0;
        Dimension d = this.getComponent().getPreferredSize();
        if (d != null) {
            maxWidth = d.getWidth();
        }
        return maxWidth;
    }

    private void gdSelectValue(String valueList, String separator, String operator, String searchType) {
        String[] values = this.split(valueList, separator);
        double maxWidth = this.getMaxWidth();
        try {
            this.getComboBoxHelper().select(values, operator, searchType, maxWidth);
        }
        catch (StepExecutionException e) {
            this.m_comboBox.hidePopup();
            throw e;
        }
        catch (IllegalArgumentException e) {
            this.m_comboBox.hidePopup();
            throw e;
        }
    }

    private String[] split(String values, String separator) {
        String[] list = StringParsing.splitToArray((String)values, (char)(separator == null || separator.length() == 0 ? (char)',' : separator.charAt(0)), (char)'\\');
        return list;
    }

    public void gdSelectValue(String valueList, String operator, String searchType) {
        this.gdSelectValue(valueList, String.valueOf(','), operator, searchType);
    }

    public String gdReadValue(String variable) {
        return this.getComboBoxHelper().getText();
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    protected String getText() {
        return this.getComboBoxHelper().getText();
    }

    public void gdVerifyFocus(boolean hasFocus) {
        this.verify(hasFocus, "hasFocus", new IRunnable(){

            public Object run() {
                boolean editorFocus;
                if (JComboBoxImplClass.this.m_comboBox.isEditable() && (editorFocus = JComboBoxImplClass.this.m_comboBox.getEditor().getEditorComponent().hasFocus())) {
                    return Boolean.TRUE;
                }
                return JComboBoxImplClass.this.getComponent().hasFocus() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }
}

