/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.tester;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import org.eclipse.jubula.rc.common.tester.AbstractMenuTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponentAdapter;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuAdapter;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IMenuItemAdapter;
import org.eclipse.jubula.rc.swing.swing.implclasses.WindowHelper;
import org.eclipse.jubula.rc.swing.swing.tester.adapter.JMenuItemAdapter;

public class JMenuBarTester
extends AbstractMenuTester {
    public String[] getTextArrayFromComponent() {
        return null;
    }

    private JMenuBar getMenuBarWorkaround(Container rootPane) {
        JMenuBar menuBar = null;
        ArrayList menuList = new ArrayList();
        this.collectMenuBarsWorkaround(rootPane, menuList);
        Iterator menuIter = menuList.iterator();
        while (menuIter.hasNext() && menuBar == null) {
            JMenuBar menu = (JMenuBar)menuIter.next();
            boolean hasAtLeastOneItem = false;
            MenuElement[] subElements = menu.getSubElements();
            int i = 0;
            while (i < subElements.length && !hasAtLeastOneItem) {
                if (subElements[i] instanceof JMenu) {
                    JMenu subMenu = (JMenu)subElements[i];
                    hasAtLeastOneItem = subMenu != null && subMenu.isShowing();
                }
                ++i;
            }
            if (!hasAtLeastOneItem) continue;
            menuBar = menu;
        }
        return menuBar;
    }

    private void collectMenuBarsWorkaround(Container container, List menuBarList) {
        Component[] children = container.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof JMenuBar && children[i].isShowing()) {
                menuBarList.add(children[i]);
            }
            ++i;
        }
        i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container && children[i].isVisible()) {
                this.collectMenuBarsWorkaround((Container)children[i], menuBarList);
            }
            ++i;
        }
    }

    public IComponentAdapter getComponent() {
        if (super.getComponent().getRealComponent() instanceof JPopupMenu) {
            return super.getComponent();
        }
        Window activeWindow = WindowHelper.getActiveWindow();
        if (activeWindow == null) {
            JMenuBarTester.getLog().warn((Object)"JMenuBarImplClass.getComponent(): No active window.");
        } else {
            JMenuBar menuBar = null;
            JRootPane rootPane = null;
            if (activeWindow instanceof JDialog) {
                JDialog dialog = (JDialog)activeWindow;
                menuBar = dialog.getJMenuBar();
                rootPane = dialog.getRootPane();
            } else if (activeWindow instanceof JFrame) {
                JFrame frame = (JFrame)activeWindow;
                menuBar = frame.getJMenuBar();
                rootPane = frame.getRootPane();
            }
            if (menuBar == null) {
                menuBar = this.getMenuBarWorkaround(rootPane);
            }
            this.setComponent(menuBar);
        }
        return super.getComponent();
    }

    protected void closeMenu(IMenuAdapter menuBar, String[] textPath, String operator) {
        if (menuBar.getRealComponent() instanceof JPopupMenu) {
            int i = 0;
            while (i < textPath.length) {
                if (((JPopupMenu)menuBar.getRealComponent()).isVisible()) {
                    this.getRobot().keyType(menuBar.getRealComponent(), 27);
                }
                ++i;
            }
            return;
        }
        super.closeMenu(menuBar, textPath, operator);
    }

    protected void closeMenu(IMenuAdapter menuBar, int[] path) {
        if (menuBar.getRealComponent() instanceof JPopupMenu) {
            int i = 0;
            while (i < path.length) {
                if (((JPopupMenu)menuBar.getRealComponent()).isVisible()) {
                    this.getRobot().keyType(menuBar.getRealComponent(), 27);
                }
                ++i;
            }
            return;
        }
        super.closeMenu(menuBar, path);
    }

    protected IMenuItemAdapter newMenuItemAdapter(Object component) {
        return new JMenuItemAdapter(component);
    }
}

