/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.tester.adapter;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComboBoxAdapter;
import org.eclipse.jubula.rc.swing.swing.tester.TesterUtil;
import org.eclipse.jubula.rc.swing.swing.tester.adapter.JListAdapter;
import org.eclipse.jubula.rc.swing.swing.tester.adapter.WidgetAdapter;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JComboBoxAdapter
extends WidgetAdapter
implements IComboBoxAdapter {
    public static final int NO_MAX_WIDTH = -1;
    private static AutServerLogger log;
    private JComboBox m_comboBox;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.tester.adapter.JComboBoxAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public JComboBoxAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_comboBox = (JComboBox)objectToAdapt;
    }

    public String getText() {
        String comboBoxText;
        if (this.m_comboBox.isEditable()) {
            comboBoxText = TesterUtil.getRenderedText(this.getComboBoxEditorComponent(this.m_comboBox), true);
        } else {
            final int selIndex = this.m_comboBox.getSelectedIndex();
            if (selIndex == -1) {
                comboBoxText = String.valueOf(this.m_comboBox.getSelectedItem());
            } else {
                final JList jlist = new JList(this.m_comboBox.getModel());
                Object o = this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

                    public Object run() {
                        Component disp = JComboBoxAdapter.this.m_comboBox.getRenderer().getListCellRendererComponent(jlist, jlist.getModel().getElementAt(selIndex), selIndex, true, JComboBoxAdapter.this.m_comboBox.hasFocus());
                        return TesterUtil.getRenderedText(disp, false);
                    }
                });
                comboBoxText = String.valueOf(o);
            }
        }
        return comboBoxText;
    }

    public boolean isEditable() {
        Boolean editable = (Boolean)this.getEventThreadQueuer().invokeAndWait("isEditable", new IRunnable(){

            public Object run() {
                return JComboBoxAdapter.this.m_comboBox.isEditable() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return editable;
    }

    public void selectAll() {
        this.click(new Integer(1));
        this.getRobot().keyStroke(String.valueOf(this.getRobot().getSystemModifierSpec()) + " A");
    }

    public int getSelectedIndex() {
        IEventThreadQueuer iEventThreadQueuer = this.getEventThreadQueuer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JComboBoxImplClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Integer actual = (Integer)iEventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + ".getSelectedIndex", new IRunnable(){

            public Object run() {
                return new Integer(JComboBoxAdapter.this.m_comboBox.getSelectedIndex());
            }
        });
        return actual;
    }

    public void select(int index) {
        JListAdapter list = new JListAdapter(this.findJList());
        list.clickOnIndex(new Integer(index), ClickOptions.create().setClickCount(1), this.getMaxWidth());
    }

    public void input(String text, boolean replace) throws StepExecutionException, IllegalArgumentException {
        Validate.notNull((Object)text, (String)"text must not be null");
        Component editor = this.getComboBoxEditorComponent(this.m_comboBox);
        if (editor == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        if (replace) {
            this.selectAll();
        }
        this.getRobot().type((Object)editor, text);
    }

    public void click(Integer count) {
        Component editor = this.getComboBoxEditorComponent(this.m_comboBox);
        if (editor == null) {
            throw new StepExecutionException("no editor found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        this.getRobot().click((Object)editor, null, ClickOptions.create().setClickCount(count.intValue()));
    }

    private Component getComboBoxEditorComponent(JComboBox component) throws StepExecutionException {
        ComboBoxEditor cbe = component.getEditor();
        if (cbe == null) {
            throw new StepExecutionException("no ComboBoxEditor found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        Component c = cbe.getEditorComponent();
        if (c == null) {
            throw new StepExecutionException("no EditorComponent found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        return c;
    }

    private JList findJList() {
        JList list;
        JPopupMenu jPopupMenu = this.openPopupMenu();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("javax.swing.JList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((list = (JList)this.getComponentViaHierarchy(jPopupMenu, clazz)) == null) {
            throw new StepExecutionException("list component not found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        return list;
    }

    private JPopupMenu openPopupMenu() {
        if (!this.isPopupVisible()) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("javax.swing.JButton");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Component c = this.getComponentViaHierarchy(this.m_comboBox, clazz);
            Rectangle r = null;
            if (c == null && !this.m_comboBox.isEditable()) {
                c = this.m_comboBox;
            } else if (c == null && this.m_comboBox.isEditable()) {
                c = this.m_comboBox;
                r = this.findArrowIconArea();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opening popup by clicking on: " + c));
            }
            this.getRobot().click((Object)c, r);
        }
        if (!this.isPopupVisible()) {
            log.debug((Object)"Dropdown list still not visible, must be an error");
            throw new StepExecutionException("dropdown list not visible", EventFactory.createActionError((String)"TestErrorEvent.DropdownListNotFound"));
        }
        return this.getPopupMenu(this.m_comboBox);
    }

    private JPopupMenu getPopupMenu(JComboBox component) throws StepExecutionException {
        AccessibleContext ac = component.getAccessibleContext();
        int i = 0;
        while (i < ac.getAccessibleChildrenCount()) {
            Accessible a = ac.getAccessibleChild(i);
            if (a instanceof JPopupMenu) {
                return (JPopupMenu)a;
            }
            ++i;
        }
        throw new StepExecutionException("cannot find dropdown list", EventFactory.createActionError((String)"TestErrorEvent.DropdownListNotFound"));
    }

    private Component getComponentViaHierarchy(Container component, Class c) {
        Component[] comps = component.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (c.isInstance(comps[i])) {
                return comps[i];
            }
            ++i;
        }
        i = 0;
        while (i < comps.length) {
            Component ct;
            if (comps[i] instanceof Container && (ct = this.getComponentViaHierarchy((Container)comps[i], c)) != null) {
                return ct;
            }
            ++i;
        }
        return null;
    }

    private boolean isPopupVisible() {
        IEventThreadQueuer iEventThreadQueuer = this.getEventThreadQueuer();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Boolean visible = (Boolean)iEventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "isPopupVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                return JComboBoxAdapter.this.m_comboBox.isPopupVisible() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return visible;
    }

    private Rectangle findArrowIconArea() {
        JComboBox comboBox = this.m_comboBox;
        Component editor = this.getComboBoxEditorComponent(comboBox);
        Rectangle r = null;
        if (editor == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        Rectangle[] ra = SwingUtilities.computeDifference(comboBox.getBounds(), editor.getBounds());
        if (ra == null || ra.length < 1) {
            throw new StepExecutionException("could not arrow icon", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        r = ra[0];
        double bestAreaIndex = Double.MAX_VALUE;
        int i = 0;
        while (i < ra.length) {
            if (ra[i].height > 0 && ra[i].width > 0) {
                double areaIndex = (double)ra[i].width / (double)ra[i].height - 1.0;
                if (areaIndex < 0.0) {
                    areaIndex *= -1.0;
                }
                if (areaIndex < bestAreaIndex) {
                    bestAreaIndex = areaIndex;
                    r = ra[i];
                }
            }
            ++i;
        }
        return r;
    }

    private double getMaxWidth() {
        double maxWidth = -1.0;
        Dimension d = this.m_comboBox.getPreferredSize();
        if (d != null) {
            maxWidth = d.getWidth();
        }
        return maxWidth;
    }

    public boolean hasFocus() {
        Boolean returnvalue = (Boolean)this.getEventThreadQueuer().invokeAndWait("hasFocus", new IRunnable(){

            public Object run() {
                boolean editorFocus;
                if (JComboBoxAdapter.this.m_comboBox.isEditable() && (editorFocus = JComboBoxAdapter.this.m_comboBox.getEditor().getEditorComponent().hasFocus())) {
                    return Boolean.TRUE;
                }
                return JComboBoxAdapter.this.m_comboBox.hasFocus() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return returnvalue;
    }

    public String[] getValues() {
        JListAdapter list = new JListAdapter(this.findJList());
        return list.getValues();
    }
}

