/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.swt.implclasses.IComboBoxHelper;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public abstract class AbstractComboBoxHelper
implements IComboBoxHelper {
    public static final int CLICK_COUNT_FOR_SELECTING_NONE = 3;

    public void select(String[] values, String operator, String searchType) throws StepExecutionException, IllegalArgumentException {
        int i = 0;
        while (i < values.length) {
            String text = values[i];
            Validate.notNull((Object)text, (String)"text must not be null");
            ++i;
        }
        Object[] indices = this.findIndicesOfValues(values, operator, searchType);
        Arrays.sort(indices);
        if (indices.length == 0) {
            throw new StepExecutionException("Text '" + Arrays.asList(values).toString() + "' not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.select((Integer)indices[0]);
    }

    public void select(int index) {
        int comboItemCount = this.getItemCount();
        if (index >= comboItemCount || index < 0) {
            throw new StepExecutionException("Combo Box index '" + index + "' is out of range", EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
        if (this.isComboEnabled()) {
            this.openDropdownList();
            this.selectImpl(index);
        }
    }

    protected abstract boolean isComboEnabled();

    protected abstract void selectImpl(int var1);

    protected abstract void openDropdownList();

    private Integer[] findIndicesOfValues(String[] values, String operator, String searchType) {
        HashSet<Integer> indexSet = new HashSet<Integer>();
        int i = this.getStartingIndex(searchType);
        while (i < this.getItemCount()) {
            String str = this.getItem(i);
            if (MatchUtil.getInstance().match(str, values, operator)) {
                indexSet.add(new Integer(i));
            }
            ++i;
        }
        Integer[] indices = new Integer[indexSet.size()];
        indexSet.toArray(indices);
        return indices;
    }

    private int getStartingIndex(String searchType) {
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative")) {
            startingIndex = this.getSelectedIndex();
        }
        return startingIndex;
    }

    public boolean containsValue(String value, String operator) {
        Integer[] indices = null;
        if (operator.equals("not equals")) {
            indices = this.findIndicesOfValues(new String[]{value}, "equals", "absolute");
            return indices.length == 0;
        }
        indices = this.findIndicesOfValues(new String[]{value}, operator, "absolute");
        return indices.length > 0;
    }

    public boolean containsValue(String value) {
        return this.containsValue(value, "equals");
    }

    protected abstract int getItemCount();

    protected abstract String getItem(int var1);
}

