/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import java.util.StringTokenizer;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRobotFactory;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.implclasses.IBaseImplementationClass;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.swt.driver.KeyCodeConverter;
import org.eclipse.jubula.rc.swt.driver.RobotFactoryConfig;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.eclipse.swt.widgets.Item;

public abstract class AbstractSwtImplClass
implements IBaseImplementationClass {
    public static final char INDEX_LIST_SEP_CHAR = ',';
    public static final char VALUE_SEPARATOR = ',';
    protected static final String POS_UNIT_PIXEL = "Pixel";
    protected static final String POS_UNI_PERCENT = "Percent";
    private IRobotFactory m_robotFactory;

    protected IRobotFactory getRobotFactory() {
        if (this.m_robotFactory == null) {
            this.m_robotFactory = new RobotFactoryConfig().getRobotFactory();
        }
        return this.m_robotFactory;
    }

    protected IRobot getRobot() throws RobotException {
        return AUTServer.getInstance().getRobot();
    }

    protected IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    public void pressOrReleaseModifiers(String modifier, boolean press) {
        IRobot robot = this.getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString((String)modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = KeyCodeConverter.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    public static void waitBeforeDrop(int delayBeforeDrop) {
        TimeUtil.delay((long)delayBeforeDrop);
    }

    protected final String[] getTextArrayFromItemArray(Item[] itemArray) {
        String[] itemTextArray;
        if (itemArray == null) {
            itemTextArray = null;
        } else {
            itemTextArray = new String[itemArray.length];
            int i = 0;
            while (i < itemArray.length) {
                Item item = itemArray[i];
                itemTextArray[i] = item == null ? null : SwtUtils.removeMnemonics(item.getText());
                ++i;
            }
        }
        return itemTextArray;
    }
}

