/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.driver.RobotSwtImpl;
import org.eclipse.jubula.rc.swt.implclasses.AbstractWidgetImplClass;
import org.eclipse.jubula.rc.swt.implclasses.MenuUtil;
import org.eclipse.jubula.rc.swt.interfaces.IMenu;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.TimeUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MenuImplClass
extends AbstractWidgetImplClass
implements IMenu {
    private static AutServerLogger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.implclasses.MenuImplClass");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public void selectMenuItem(String namePath, String operator) {
        String[] pathItems = MenuUtil.splitPath(namePath);
        if (pathItems.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        Menu menu = this.getAndCheckComponent();
        try {
            Rectangle nullBounds;
            Rectangle bounds;
            MenuItem item = MenuUtil.navigateToMenuItem(this.getRobot(), menu, pathItems, operator);
            if (item == null) {
                this.throwMenuItemNotFound();
            }
            if ((bounds = MenuUtil.getMenuItemBounds(item)).equals((Object)(nullBounds = new Rectangle(0, 0, 0, 0)))) {
                MenuUtil.selectProgramatically(item);
            } else {
                MenuUtil.clickMenuItem(this.getRobot(), item, 1);
            }
        }
        catch (StepExecutionException e) {
            block8: {
                try {
                    this.closeMenu(operator, pathItems);
                }
                catch (StepExecutionException stepExecutionException) {
                    if (!log.isInfoEnabled()) break block8;
                    log.info((Object)"Tried to close a disabled or already closed menu.");
                }
            }
            throw e;
        }
    }

    public void selectMenuItemByIndexpath(String indexPath) {
        int[] indexItems = MenuUtil.splitIndexPath(indexPath);
        if (indexItems.length == 0) {
            throw new StepExecutionException("empty path to menuitem not allowed", EventFactory.createActionError());
        }
        Menu menu = this.getAndCheckComponent();
        try {
            Rectangle nullBounds;
            Rectangle bounds;
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), menu, indexItems);
            if (menuItem == null) {
                this.throwMenuItemNotFound();
            }
            if ((bounds = MenuUtil.getMenuItemBounds(menuItem)).equals((Object)(nullBounds = new Rectangle(0, 0, 0, 0)))) {
                MenuUtil.selectProgramatically(menuItem);
            } else {
                MenuUtil.clickMenuItem(this.getRobot(), menuItem, 1);
            }
        }
        catch (StepExecutionException stepExecutionException) {
            block8: {
                try {
                    this.closeMenu(indexItems);
                }
                catch (StepExecutionException stepExecutionException2) {
                    if (!log.isInfoEnabled()) break block8;
                    log.info((Object)"Tried to close a disabled or already closed menu.");
                }
            }
            this.throwMenuItemNotFound();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyEnabled(String namePath, String operator, boolean enabled) {
        String[] pathItems = MenuUtil.splitPath(namePath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckComponent(), pathItems, operator);
            if (menuItem == null) {
                this.throwMenuItemNotFound();
            }
            boolean isEnabled = MenuUtil.isMenuItemEnabled(menuItem);
            Verifier.equals((boolean)enabled, (boolean)isEnabled);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                this.closeMenu(operator, pathItems);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {
                if (!log.isInfoEnabled()) throw throwable;
                log.info((Object)"Tried to close a disabled or already closed menu.");
            }
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            if (!log.isInfoEnabled()) return;
            log.info((Object)"Tried to close a disabled or already closed menu.");
            return;
        }
        this.closeMenu(operator, pathItems);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyEnabledByIndexpath(String indexPath, boolean enabled) {
        int[] indexItems = MenuUtil.splitIndexPath(indexPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckComponent(), indexItems);
            if (menuItem == null) {
                this.throwMenuItemNotFound();
            }
            boolean isEnabled = MenuUtil.isMenuItemEnabled(menuItem);
            Verifier.equals((boolean)enabled, (boolean)isEnabled);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                this.closeMenu(indexItems);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {
                if (!log.isInfoEnabled()) throw throwable;
                log.info((Object)"Tried to close a disabled or already closed menu.");
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            if (!log.isInfoEnabled()) return;
            log.info((Object)"Tried to close a disabled or already closed menu.");
            return;
        }
        this.closeMenu(indexItems);
    }

    protected void closeMenu(int[] indexItems) {
        MenuUtil.closeMenu(this.getRobot(), this.getAndCheckComponent(), indexItems[0], indexItems.length);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyExists(String namePath, String operator, boolean exists) {
        block7: {
            pathItems = MenuUtil.splitPath(namePath);
            isExisting = false;
            try {
                menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckComponent(), pathItems, operator);
                if (menuItem != null) {
                    isExisting = true;
                }
            }
            catch (Throwable var8_7) {
                var7_8 = null;
                try {
                    this.closeMenu(operator, pathItems);
                    throw var8_7;
                }
                catch (StepExecutionException v0) {
                    if (MenuImplClass.log.isInfoEnabled() == false) throw var8_7;
                    MenuImplClass.log.info((Object)"Tried to close a disabled or already closed menu.");
                }
                throw var8_7;
            }
            {
                var7_9 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 46->56)] { 
lbl20:
            // 1 sources

            this.closeMenu(operator, pathItems);
            break block7;
lbl22:
            // 1 sources

            catch (StepExecutionException v1) {
                if (!MenuImplClass.log.isInfoEnabled()) break block7;
                MenuImplClass.log.info((Object)"Tried to close a disabled or already closed menu.");
            }
        }
        Verifier.equals((boolean)exists, (boolean)isExisting);
    }

    protected void closeMenu(String operator, String[] pathItems) {
        MenuUtil.closeMenu(this.getRobot(), this.getAndCheckComponent(), pathItems[0], operator, pathItems.length);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifyExistsByIndexpath(String indexPath, boolean exists) {
        block7: {
            indexItems = MenuUtil.splitIndexPath(indexPath);
            isExisting = false;
            menu = this.getAndCheckComponent();
            try {
                menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), menu, indexItems);
                if (menuItem != null) {
                    isExisting = true;
                }
            }
            catch (Throwable var8_7) {
                var7_8 = null;
                try {
                    this.closeMenu(indexItems);
                    throw var8_7;
                }
                catch (StepExecutionException v0) {
                    if (MenuImplClass.log.isInfoEnabled() == false) throw var8_7;
                    MenuImplClass.log.info((Object)"Tried to close a disabled or already closed menu.");
                }
                throw var8_7;
            }
            {
                var7_9 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 47->55)] { 
lbl21:
            // 1 sources

            this.closeMenu(indexItems);
            break block7;
lbl23:
            // 1 sources

            catch (StepExecutionException v1) {
                if (!MenuImplClass.log.isInfoEnabled()) break block7;
                MenuImplClass.log.info((Object)"Tried to close a disabled or already closed menu.");
            }
        }
        Verifier.equals((boolean)exists, (boolean)isExisting);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifySelected(String namePath, String operator, boolean selected) {
        String[] pathItems = MenuUtil.splitPath(namePath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckComponent(), pathItems, operator);
            if (menuItem == null) {
                this.throwMenuItemNotFound();
            }
            boolean isSelected = MenuUtil.isMenuItemSelected(menuItem);
            Verifier.equals((boolean)selected, (boolean)isSelected);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                this.closeMenu(operator, pathItems);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {
                if (!log.isInfoEnabled()) throw throwable;
                log.info((Object)"Tried to close a disabled or already closed menu.");
            }
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            if (!log.isInfoEnabled()) return;
            log.info((Object)"Tried to close a disabled or already closed menu.");
            return;
        }
        this.closeMenu(operator, pathItems);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verifySelectedByIndexpath(String indexPath, boolean selected) {
        int[] indexItems = MenuUtil.splitIndexPath(indexPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), this.getAndCheckComponent(), indexItems);
            if (menuItem == null) {
                this.throwMenuItemNotFound();
            }
            boolean isSelected = MenuUtil.isMenuItemSelected(menuItem);
            Verifier.equals((boolean)selected, (boolean)isSelected);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                this.closeMenu(indexItems);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {
                if (!log.isInfoEnabled()) throw throwable;
                log.info((Object)"Tried to close a disabled or already closed menu.");
            }
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            if (!log.isInfoEnabled()) return;
            log.info((Object)"Tried to close a disabled or already closed menu.");
            return;
        }
        this.closeMenu(indexItems);
    }

    public Widget getComponent() {
        final Shell shell = ((RobotSwtImpl)this.getRobot()).getActiveWindow();
        if (shell == null) {
            this.setComponent(null);
        } else {
            EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
            queuer.invokeAndWait("setMenuBarComponent", new IRunnable(){

                public Object run() {
                    Menu menu = shell.getMenuBar();
                    MenuImplClass.this.setComponent(menu);
                    return null;
                }
            });
        }
        return super.getComponent();
    }

    public void waitForComponent(int timeout, int delay) {
        if (this.getComponent() == null) {
            long start = System.currentTimeMillis();
            do {
                RobotTiming.sleepWaitForComponentPollingDelay();
            } while (System.currentTimeMillis() - start < (long)timeout && this.getComponent() == null);
            if (this.getComponent() == null) {
                throw new StepExecutionException("No Menubar found.", EventFactory.createComponentNotFoundErrorEvent());
            }
        }
        TimeUtil.delay((long)delay);
    }

    private void throwMenuItemNotFound() {
        throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
    }

    private Menu getAndCheckComponent() throws StepExecutionException {
        if (((RobotSwtImpl)this.getRobot()).getActiveWindow() == null) {
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoActiveWindow"), EventFactory.createActionError((String)"TestErrorEvent.NoActiveWindow"));
        }
        Menu menu = (Menu)this.getComponent();
        if (menu == null) {
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoMenuBar"), EventFactory.createActionError((String)"TestErrorEvent.NoMenuBar"));
        }
        return menu;
    }

    public String[] getTextArrayFromComponent() {
        String[] componentTextArray;
        Menu menu = (Menu)this.getComponent();
        if (menu == null) {
            componentTextArray = null;
        } else {
            MenuItem[] itemArray = menu.getItems();
            componentTextArray = this.getTextArrayFromItemArray((Item[])itemArray);
        }
        return componentTextArray;
    }
}

