/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swt.implclasses.AbstractTabFolderImplClass;
import org.eclipse.jubula.rc.swt.interfaces.ITabFolder;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class TabFolderImplClass
extends AbstractTabFolderImplClass
implements ITabFolder {
    private TabFolder m_tabFolder;

    public void setComponent(Object graphicsComponent) {
        this.m_tabFolder = (TabFolder)graphicsComponent;
    }

    public Control getComponent() {
        return this.m_tabFolder;
    }

    public void gdVerifySelectedTabByIndex(int index, boolean selected) throws StepExecutionException {
        int implIdx = IndexConverter.toImplementationIndex((int)index);
        int selIndex = (Integer)this.getEventThreadQueuer().invokeAndWait("getSelectedIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(TabFolderImplClass.this.m_tabFolder.getSelectionIndex());
            }
        });
        if (selIndex == -1) {
            if (!selected) {
                return;
            }
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoSelection"), EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        Verifier.equals((boolean)selected, (selIndex == implIdx ? 1 : 0) != 0);
    }

    public void gdVerifySelectedTab(String tabTitlePattern, String operator, boolean selected) throws StepExecutionException {
        String selectedTabTitle = (String)this.getEventThreadQueuer().invokeAndWait("getSelectedTitle", new IRunnable(){

            public Object run() throws StepExecutionException {
                TabItem[] selectedItem = TabFolderImplClass.this.m_tabFolder.getSelection();
                if (selectedItem.length == 0) {
                    return null;
                }
                return SwtUtils.removeMnemonics(selectedItem[0].getText());
            }
        });
        if (selectedTabTitle == null) {
            if (!selected) {
                return;
            }
            throw new StepExecutionException(I18n.getString((String)"TestErrorEvent.NoSelection"), EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        Verifier.match((String)selectedTabTitle, (String)tabTitlePattern, (String)operator, (boolean)selected);
    }

    public void gdVerifyEnabled(String title, String operator, boolean isEnabled) throws StepExecutionException {
        final int tabIndex = this.getIndexOfTab(title, operator);
        this.verify(isEnabled, "isEnabledAt", new IRunnable(){

            public Object run() throws StepExecutionException {
                return TabFolderImplClass.this.m_tabFolder.getItem(tabIndex).getControl().isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void gdVerifyEnabledByIndex(int index, boolean enabled) throws StepExecutionException {
        final int implIdx = IndexConverter.toImplementationIndex((int)index);
        this.verifyIndexExists(implIdx);
        this.verify(enabled, "isEnabledAt", new IRunnable(){

            public Object run() throws StepExecutionException {
                return TabFolderImplClass.this.m_tabFolder.getItem(implIdx).getControl().isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    protected Rectangle getBoundsAt(final int index) {
        return (Rectangle)this.getEventThreadQueuer().invokeAndWait("getBoundsAt", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.getRelativeWidgetBounds((Widget)TabFolderImplClass.this.m_tabFolder.getItem(index), (Control)TabFolderImplClass.this.m_tabFolder);
            }
        });
    }

    protected int getIndexOfTab(final String title, final String operator) {
        int index = (Integer)this.getEventThreadQueuer().invokeAndWait("indexOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = 0;
                while (i < TabFolderImplClass.this.m_tabFolder.getItemCount()) {
                    if (MatchUtil.getInstance().match(SwtUtils.removeMnemonics(TabFolderImplClass.this.m_tabFolder.getItem(i).getText()), title, operator)) {
                        int j = TabFolderImplClass.this.m_tabFolder.indexOf(TabFolderImplClass.this.m_tabFolder.getItem(i));
                        return new Integer(j);
                    }
                    ++i;
                }
                return new Integer(-1);
            }
        });
        if (index == -1) {
            throw new StepExecutionException("Can not find tab: '" + title + "' using operator: '" + operator + "'", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        return index;
    }

    protected String getTitleOfTab(final int index) {
        String tabTitle = (String)this.getEventThreadQueuer().invokeAndWait("verifyTextOfTabByIndex", new IRunnable(){

            public Object run() throws StepExecutionException {
                TabFolderImplClass.this.verifyIndexExists(index);
                return TabFolderImplClass.this.m_tabFolder.getItem(index).getText();
            }
        });
        return tabTitle;
    }

    protected void verifyIndexExists(final int index) {
        Boolean exists = (Boolean)this.getEventThreadQueuer().invokeAndWait("indexOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                int i = TabFolderImplClass.this.m_tabFolder.getItemCount();
                return index >= 0 && index < i ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        if (!exists.booleanValue()) {
            throw new StepExecutionException("The tab index doesn't exist: " + index, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    public String[] getTextArrayFromComponent() {
        TabItem[] itemArray = this.m_tabFolder.getItems();
        String[] componentTextArray = this.getTextArrayFromItemArray((Item[])itemArray);
        return componentTextArray;
    }

    protected void ensureTabIsShowing(int index) {
    }

    protected boolean indexOrTitleOfTabExists(final String tab, final String operator) {
        int tabIndex = -1;
        try {
            tabIndex = IndexConverter.toImplementationIndex((int)Integer.parseInt(tab));
        }
        catch (NumberFormatException numberFormatException) {
            tabIndex = (Integer)this.getEventThreadQueuer().invokeAndWait("indexOrTitleOfTabExists", new IRunnable(){

                public Object run() throws StepExecutionException {
                    int i = 0;
                    while (i < TabFolderImplClass.this.m_tabFolder.getItemCount()) {
                        if (MatchUtil.getInstance().match(SwtUtils.removeMnemonics(TabFolderImplClass.this.m_tabFolder.getItem(i).getText()), tab, operator)) {
                            int j = TabFolderImplClass.this.m_tabFolder.indexOf(TabFolderImplClass.this.m_tabFolder.getItem(i));
                            return new Integer(j);
                        }
                        ++i;
                    }
                    return new Integer(-1);
                }
            });
        }
        final int index = tabIndex;
        Boolean tabExists = (Boolean)this.getEventThreadQueuer().invokeAndWait("verifyExistenceOfTab", new IRunnable(){

            public Object run() throws StepExecutionException {
                if (index < 0 || index >= TabFolderImplClass.this.m_tabFolder.getItemCount()) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
        });
        return tabExists;
    }
}

