/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.implclasses;

import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.implclasses.Verifier;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.implclasses.AbstractSwtImplClass;
import org.eclipse.jubula.rc.swt.implclasses.MenuUtil;
import org.eclipse.jubula.rc.swt.implclasses.PopupMenuImplClass;
import org.eclipse.jubula.rc.swt.implclasses.PopupMenuUtil;
import org.eclipse.jubula.rc.swt.implclasses.SimulatedTooltip;
import org.eclipse.jubula.rc.swt.interfaces.IToolItem;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolItemImplClass
extends AbstractSwtImplClass
implements IToolItem {
    private Menu m_menu;
    private Listener m_menuOpenListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.widget instanceof Menu) {
                ToolItemImplClass.this.m_menu = (Menu)event.widget;
                ToolItemImplClass.this.m_menu.getDisplay().removeFilter(22, (Listener)this);
                ToolItemImplClass.this.m_menu.addMenuListener((MenuListener)ToolItemImplClass.this.m_menuCloseListener);
            }
        }
    };
    private MenuAdapter m_menuCloseListener = new MenuAdapter(){

        public void menuHidden(MenuEvent e) {
            if (e.widget instanceof Menu) {
                Menu menu = (Menu)e.widget;
                menu.removeMenuListener((MenuListener)this);
                ToolItemImplClass.this.m_menu = null;
            }
        }
    };
    private ToolItem m_item = null;
    private PopupMenuImplClass m_menuUtil = new PopupMenuImplClass();

    public void gdClick(int count, int button) {
        this.getRobot().click((Object)this.m_item, null, ClickOptions.create().setClickCount(count).setMouseButton(button));
    }

    public void gdClick(int count) {
        this.gdClick(count, 1);
    }

    public void gdClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.getRobot().click((Object)this.m_item, null, ClickOptions.create().setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase("Pixel"), yPos, yUnits.equalsIgnoreCase("Pixel"));
    }

    public void setComponent(Object graphicsComponent) {
        this.m_item = (ToolItem)graphicsComponent;
    }

    public void selectMenuItem(String namePath, String operator) {
        this.openDropdownMenu();
        this.m_menuUtil.selectMenuItem(namePath, operator);
    }

    public void selectMenuItemByIndexpath(String indexPath) {
        this.openDropdownMenu();
        Menu menu = this.getDropdown();
        this.m_menuUtil.setComponent(menu);
        this.m_menuUtil.selectMenuItemByIndexpath(indexPath);
    }

    public void verifyEnabled(String namePath, String operator, boolean enabled) {
        this.openDropdownMenu();
        this.m_menuUtil.verifyEnabled(namePath, operator, enabled);
    }

    public void verifyEnabledByIndexpath(String indexPath, boolean enabled) {
        this.openDropdownMenu();
        this.m_menuUtil.verifyEnabledByIndexpath(indexPath, enabled);
    }

    public void verifyExists(String namePath, String operator, boolean exists) {
        this.openDropdownMenu();
        this.m_menuUtil.verifyExists(namePath, operator, exists);
    }

    public void gdVerifyExists(boolean exists) {
        this.verify(exists, "exists", new IRunnable(){

            public Object run() {
                return ToolItemImplClass.this.m_item.isDisposed() ? Boolean.FALSE : Boolean.TRUE;
            }
        });
    }

    public void verifyExistsByIndexpath(String indexPath, boolean exists) {
        this.openDropdownMenu();
        this.m_menuUtil.verifyExistsByIndexpath(indexPath, exists);
    }

    public void verifySelected(String namePath, String operator, boolean selected) {
        this.openDropdownMenu();
        this.m_menuUtil.verifySelected(namePath, operator, selected);
    }

    public void verifySelectedByIndexpath(String indexPath, boolean selected) {
        this.openDropdownMenu();
        this.m_menuUtil.verifySelectedByIndexpath(indexPath, selected);
    }

    public void gdVerifyFocus(boolean hasFocus) {
        Verifier.equals((boolean)hasFocus, (boolean)false);
    }

    public void gdVerifyProperty(String name, String value, String operator) {
        ToolItem bean = this.m_item;
        Object prop = this.getEventThreadQueuer().invokeAndWait("getProperty", new IRunnable((Item)bean, name){
            private final /* synthetic */ Item val$bean;
            private final /* synthetic */ String val$name;
            {
                this.val$bean = item;
                this.val$name = string;
            }

            public Object run() throws StepExecutionException {
                try {
                    return ToolItemImplClass.this.getRobot().getPropertyValue((Object)this.val$bean, this.val$name);
                }
                catch (RobotException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        String propToStr = String.valueOf(prop);
        Verifier.match((String)propToStr, (String)value, (String)operator);
    }

    public String gdStorePropertyValue(String variableName, String propertyName) {
        ToolItem bean = this.m_item;
        Object prop = this.getEventThreadQueuer().invokeAndWait("getProperty", new IRunnable((Item)bean, propertyName){
            private final /* synthetic */ Item val$bean;
            private final /* synthetic */ String val$propertyName;
            {
                this.val$bean = item;
                this.val$propertyName = string;
            }

            public Object run() throws StepExecutionException {
                try {
                    return ToolItemImplClass.this.getRobot().getPropertyValue((Object)this.val$bean, this.val$propertyName);
                }
                catch (RobotException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        return String.valueOf(prop);
    }

    public void gdVerifySelected(boolean selected) {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("isSelected", new IRunnable(){

            public Object run() {
                return ToolItemImplClass.this.m_item.getSelection() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        Verifier.equals((boolean)selected, (boolean)actual);
    }

    public void gdVerifyText(String text, String operator) {
        String value = (String)this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.removeMnemonics(ToolItemImplClass.this.m_item.getText());
            }
        });
        Verifier.match((String)value, (String)text, (String)operator);
    }

    public void gdVerifyText(String text) {
        this.gdVerifyText(text, "equals");
    }

    public void gdVerifyEnabled(boolean enabled) {
        boolean isEnabled = (Boolean)this.getEventThreadQueuer().invokeAndWait("isEnabled", new IRunnable(){

            public Object run() {
                return ToolItemImplClass.this.m_item.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        Verifier.equals((boolean)enabled, (boolean)isEnabled);
    }

    public String gdReadValue(String variable) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() throws StepExecutionException {
                return SwtUtils.removeMnemonics(ToolItemImplClass.this.m_item.getText());
            }
        });
    }

    private Menu openDropdownMenu() {
        Menu menu;
        int style = (Integer)this.getEventThreadQueuer().invokeAndWait("getStyle", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(ToolItemImplClass.this.m_item.getStyle());
            }
        });
        if ((style & 4) == 0) {
            throw new StepExecutionException("Component does not have a dropdown menu.", EventFactory.createActionError((String)"TestErrorEvent.DropdownNotFound"));
        }
        this.getEventThreadQueuer().invokeAndWait("addMenuOpenListener", new IRunnable(){

            public Object run() throws StepExecutionException {
                ToolItemImplClass.this.m_item.getDisplay().addFilter(22, ToolItemImplClass.this.m_menuOpenListener);
                return null;
            }
        });
        try {
            this.getRobot().click((Object)this.m_item, null, ClickOptions.create().left(), 95, false, 50, false);
            this.m_menuUtil.setComponent(this.m_menu);
            if (this.m_menu == null) {
                throw new StepExecutionException("Dropdown menu did not appear.", EventFactory.createActionError((String)"TestErrorEvent.DropdownNotFound"));
            }
            menu = this.m_menu;
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.getEventThreadQueuer().invokeAndWait("removeMenuOpenListener", new IRunnable(){

                public Object run() throws StepExecutionException {
                    ToolItemImplClass.this.m_item.getDisplay().removeFilter(22, ToolItemImplClass.this.m_menuOpenListener);
                    return null;
                }
            });
            throw throwable;
        }
        this.getEventThreadQueuer().invokeAndWait("removeMenuOpenListener", new /* invalid duplicate definition of identical inner class */);
        return menu;
    }

    private Menu getDropdown() {
        return this.m_menu;
    }

    public void gdPopupSelectByIndexPath(int xPos, int yPos, String units, String indexPath) throws StepExecutionException {
        this.gdPopupSelectByIndexPath(xPos, units, yPos, units, indexPath, 3);
    }

    public void gdPopupSelectByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        PopupMenuUtil.selectMenuItem(this.getRobot(), popup, MenuUtil.splitIndexPath(indexPath));
    }

    public void gdPopupSelectByIndexPath(String indexPath) throws StepExecutionException {
        this.gdPopupSelectByIndexPath(indexPath, 3);
    }

    public void gdPopupSelectByIndexPath(String indexPath, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), button);
        PopupMenuUtil.selectMenuItem(this.getRobot(), popup, MenuUtil.splitIndexPath(indexPath));
    }

    public void gdPopupSelectByTextPath(String textPath, String operator) throws StepExecutionException {
        this.gdPopupSelectByTextPath(textPath, operator, 3);
    }

    public void gdPopupSelectByTextPath(String textPath, String operator, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), button);
        PopupMenuUtil.selectMenuItem(this.getRobot(), popup, MenuUtil.splitPath(textPath), operator);
    }

    public void gdPopupSelectByTextPath(int xPos, int yPos, String units, String textPath, String operator) throws StepExecutionException {
        this.gdPopupSelectByTextPath(xPos, units, yPos, units, textPath, operator, 3);
    }

    public void gdPopupSelectByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        PopupMenuUtil.selectMenuItem(this.getRobot(), popup, MenuUtil.splitPath(textPath), operator);
    }

    public void gdPopupVerifyEnabledByIndexPath(String indexPath, boolean enabled, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), button);
        this.popupVerifyEnabledByIndexPath(indexPath, popup, enabled);
    }

    public void gdPopupVerifyEnabledByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean enabled, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyEnabledByIndexPath(indexPath, popup, enabled);
    }

    public void gdPopupVerifyEnabledByTextPath(String textPath, String operator, boolean enabled, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), button);
        this.popupVerifyEnabledByTextPath(textPath, operator, popup, enabled);
    }

    public void gdPopupVerifyEnabledByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean enabled, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyEnabledByTextPath(textPath, operator, popup, enabled);
    }

    public void gdPopupVerifyExistsByIndexPath(String indexPath, boolean exists, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), button);
        this.popupVerifyExistsByIndexPath(indexPath, popup, exists);
    }

    public void gdPopupVerifyExistsByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean exists, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyExistsByIndexPath(indexPath, popup, exists);
    }

    public void gdPopupVerifyExistsByTextPath(String textPath, String operator, boolean exists, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), button);
        this.popupVerifyExistsByTextPath(textPath, operator, popup, exists);
    }

    public void gdPopupVerifyExistsByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean exists, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifyExistsByTextPath(textPath, operator, popup, exists);
    }

    public void gdPopupVerifySelectedByIndexPath(String indexPath, boolean selected, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), button);
        this.popupVerifySelectedByIndexPath(indexPath, popup, selected);
    }

    public void gdPopupVerifySelectedByIndexPath(int xPos, String xUnits, int yPos, String yUnits, String indexPath, boolean selected, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifySelectedByIndexPath(indexPath, popup, selected);
    }

    public void gdPopupVerifySelectedByTextPath(String textPath, String operator, boolean selected, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), button);
        this.popupVerifySelectedByTextPath(textPath, operator, popup, selected);
    }

    public void gdPopupVerifySelectedByTextPath(int xPos, String xUnits, int yPos, String yUnits, String textPath, String operator, boolean selected, int button) throws StepExecutionException {
        Menu popup = PopupMenuUtil.showPopup((Widget)this.m_item, this.getRobot(), xPos, xUnits, yPos, yUnits, button);
        this.popupVerifySelectedByTextPath(textPath, operator, popup, selected);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyEnabledByIndexPath(String indexPath, Menu popup, boolean enabled) {
        int[] indexItems = MenuUtil.splitIndexPath(indexPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, indexItems);
            if (menuItem == null) {
                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
            boolean isEnabled = MenuUtil.isMenuItemEnabled(menuItem);
            Verifier.equals((boolean)enabled, (boolean)isEnabled);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                int pathLength = indexItems != null ? indexItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            return;
        }
        int pathLength = indexItems != null ? indexItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyEnabledByTextPath(String textPath, String operator, Menu popup, boolean enabled) throws StepExecutionException {
        String[] pathItems = MenuUtil.splitPath(textPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, pathItems, operator);
            if (menuItem == null) {
                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
            boolean isEnabled = MenuUtil.isMenuItemEnabled(menuItem);
            Verifier.equals((boolean)enabled, (boolean)isEnabled);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                int pathLength = pathItems != null ? pathItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            return;
        }
        int pathLength = pathItems != null ? pathItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyExistsByIndexPath(String indexPath, Menu popup, boolean exists) {
        int[] indexItems = MenuUtil.splitIndexPath(indexPath);
        boolean isExisting = false;
        Menu menu = popup;
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), menu, indexItems);
            if (menuItem != null) {
                isExisting = true;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                int pathLength = indexItems != null ? indexItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {}
        int pathLength = indexItems != null ? indexItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
        Verifier.equals((boolean)exists, (boolean)isExisting);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifyExistsByTextPath(String textPath, String operator, Menu popup, boolean exists) throws StepExecutionException {
        String[] pathItems = MenuUtil.splitPath(textPath);
        boolean isExisting = false;
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, pathItems, operator);
            if (menuItem != null) {
                isExisting = true;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                int pathLength = pathItems != null ? pathItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {}
        int pathLength = pathItems != null ? pathItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
        Verifier.equals((boolean)exists, (boolean)isExisting);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifySelectedByIndexPath(String indexPath, Menu popup, boolean selected) throws StepExecutionException {
        int[] indexItems = MenuUtil.splitIndexPath(indexPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, indexItems);
            if (menuItem == null) {
                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
            boolean isSelected = MenuUtil.isMenuItemSelected(menuItem);
            Verifier.equals((boolean)selected, (boolean)isSelected);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                int pathLength = indexItems != null ? indexItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            return;
        }
        int pathLength = indexItems != null ? indexItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void popupVerifySelectedByTextPath(String textPath, String operator, Menu popup, boolean selected) throws StepExecutionException {
        String[] pathItems = MenuUtil.splitPath(textPath);
        try {
            MenuItem menuItem = MenuUtil.navigateToMenuItem(this.getRobot(), popup, pathItems, operator);
            if (menuItem == null) {
                throw new StepExecutionException("no such menu item found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
            }
            boolean isSelected = MenuUtil.isMenuItemSelected(menuItem);
            Verifier.equals((boolean)selected, (boolean)isSelected);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                int pathLength = pathItems != null ? pathItems.length : 0;
                PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
                throw throwable;
            }
            catch (StepExecutionException stepExecutionException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (StepExecutionException stepExecutionException) {
            return;
        }
        int pathLength = pathItems != null ? pathItems.length : 0;
        PopupMenuUtil.closePopup(this.getRobot(), popup, pathLength);
    }

    public void gdWaitForComponent(int timeout, int delay) {
    }

    protected void verify(boolean expected, String name, IRunnable runnable) throws StepVerifyFailedException {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait(name, runnable);
        Verifier.equals((boolean)expected, (boolean)actual);
    }

    public void gdShowText(final String text, final int textSize, final int timePerWord, final int windowWidth) {
        final Rectangle bounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("gdShowText.getBounds", new IRunnable(){

            public Object run() {
                return SwtUtils.getWidgetBounds((Widget)ToolItemImplClass.this.m_item);
            }
        });
        SimulatedTooltip sp = (SimulatedTooltip)this.getEventThreadQueuer().invokeAndWait("gdShowText.initToolTip", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new SimulatedTooltip(timePerWord, text, windowWidth, textSize, bounds);
            }
        });
        sp.start();
        try {
            sp.join();
        }
        catch (InterruptedException e) {
            throw new StepExecutionException((Throwable)e);
        }
    }

    public void gdDrag(int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        this.gdClickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDrop(final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        String modifier = dndHelper.getModifier();
        final int mouseButton = dndHelper.getMouseButton();
        this.pressOrReleaseModifiers(modifier, true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDrop", new IRunnable(){

                public Object run() throws StepExecutionException {
                    ToolItemImplClass.this.getRobot().mousePress(null, null, mouseButton);
                    ToolItemImplClass.this.gdClickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
                    return null;
                }
            });
            ToolItemImplClass.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.getRobot().mouseRelease(null, null, mouseButton);
            this.pressOrReleaseModifiers(modifier, false);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        this.getRobot().mouseRelease(null, null, mouseButton);
        this.pressOrReleaseModifiers(modifier, false);
    }

    public String[] getTextArrayFromComponent() {
        return new String[]{SwtUtils.removeMnemonics(this.m_item.getText())};
    }
}

