/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.tester.AbstractTableTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableAdapter;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.adapter.TableAdapter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableTester
extends AbstractTableTester {
    private Table getTable() {
        return (Table)this.getComponent().getRealComponent();
    }

    public IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    public String[] getTextArrayFromComponent() {
        TableColumn[] itemArray = this.getTable().getColumns();
        String[] componentTextArray = this.getTextArrayFromItemArray((Item[])itemArray);
        return componentTextArray;
    }

    protected Object setEditorToReplaceMode(Object editor, boolean replace) {
        if (replace) {
            this.getRobot().clickAtCurrentPosition(editor, 3, 1);
        } else {
            this.getRobot().clickAtCurrentPosition(editor, 2, 1);
        }
        return editor;
    }

    protected Object activateEditor(Cell cell, Rectangle rectangle) {
        TableAdapter table = (TableAdapter)this.getComponent();
        return table.activateEditor(cell);
    }

    protected Rectangle scrollCellToVisible(final int row, final int col) throws StepExecutionException {
        final Table table = this.getTable();
        this.getEventThreadQueuer().invokeAndWait("scrollCellToVisible", new IRunnable(){

            public Object run() {
                if (table.getColumnCount() > 0 || col > 0) {
                    table.showColumn(table.getColumn(col));
                }
                table.showItem(table.getItem(row));
                return null;
            }
        });
        final Rectangle cellBoundsRelativeToParent = this.getCellBounds(row, col);
        this.getEventThreadQueuer().invokeAndWait("getCellBoundsRelativeToParent", new IRunnable(){

            public Object run() {
                Point cellOriginRelativeToParent = table.getDisplay().map((Control)table, (Control)table.getParent(), new Point(cellBoundsRelativeToParent.x, cellBoundsRelativeToParent.y));
                cellBoundsRelativeToParent.x = cellOriginRelativeToParent.x;
                cellBoundsRelativeToParent.y = cellOriginRelativeToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getEventThreadQueuer().invokeAndWait("getParent", new IRunnable(){

            public Object run() {
                table.getParent();
                return null;
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)cellBoundsRelativeToParent);
        return this.getVisibleBounds(this.getCellBounds(row, col));
    }

    protected int getExtendSelectionModifier() {
        return SWT.MOD1;
    }

    protected Cell getCellAtMousePosition() throws StepExecutionException {
        final Table table = this.getTable();
        final java.awt.Point awtMousePos = this.getRobot().getCurrentMousePosition();
        Cell returnvalue = (Cell)this.getEventThreadQueuer().invokeAndWait("getCellAtMousePosition", new IRunnable(){

            public Object run() throws StepExecutionException {
                Cell cell = null;
                int itemCount = table.getItemCount();
                int rowCount = table.getTopIndex();
                while (rowCount < itemCount) {
                    if (cell != null) break;
                    int columnCount = table.getColumnCount();
                    if (columnCount > 0) {
                        int col = 0;
                        while (col < columnCount) {
                            Rectangle itemBounds = TableTester.this.getCellBounds(rowCount, col);
                            Point absItemBounds = table.toDisplay(itemBounds.x, itemBounds.y);
                            Rectangle absRect = new Rectangle(absItemBounds.x, absItemBounds.y, itemBounds.width, itemBounds.height);
                            if (absRect.contains(awtMousePos)) {
                                cell = new Cell(rowCount, col);
                                break;
                            }
                            ++col;
                        }
                    } else {
                        Rectangle itemBounds = TableTester.this.getCellBounds(rowCount, 0);
                        Point absItemBounds = table.toDisplay(itemBounds.x, itemBounds.y);
                        Rectangle absRect = new Rectangle(absItemBounds.x, absItemBounds.y, itemBounds.width, itemBounds.height);
                        if (absRect.contains(awtMousePos)) {
                            cell = new Cell(rowCount, 0);
                        }
                    }
                    ++rowCount;
                }
                if (cell == null) {
                    throw new StepExecutionException("No cell under mouse position found!", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                return cell;
            }
        });
        return returnvalue;
    }

    protected boolean isMouseOnHeader() {
        final Table table = this.getTable();
        final ITableAdapter adapter = (ITableAdapter)this.getComponent();
        Boolean isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("isMouseOnHeader", new IRunnable(){

            public Object run() {
                return new Boolean(table.getHeaderVisible());
            }
        });
        if (!isVisible.booleanValue()) {
            return false;
        }
        Boolean isOnHeader = new Boolean(false);
        isOnHeader = (Boolean)this.getEventThreadQueuer().invokeAndWait("isMouseOnHeader", new IRunnable(){

            public Object run() {
                java.awt.Point awtMousePos = TableTester.this.getRobot().getCurrentMousePosition();
                Point mousePos = new Point(awtMousePos.x, awtMousePos.y);
                int j = 0;
                while (j < table.getColumnCount()) {
                    Rectangle constraints = adapter.getHeaderBounds(j);
                    org.eclipse.swt.graphics.Rectangle bounds = SwtUtils.getWidgetBounds((Widget)table);
                    if (constraints != null) {
                        Point convertedLocation = TableTester.this.getConvertedLocation(constraints);
                        bounds.x = convertedLocation.x;
                        bounds.y = convertedLocation.y;
                        bounds.height = constraints.height;
                        bounds.width = constraints.width;
                    }
                    if (bounds.contains(mousePos)) {
                        return new Boolean(true);
                    }
                    ++j;
                }
                return new Boolean(false);
            }
        });
        return isOnHeader;
    }

    protected final String[] getTextArrayFromItemArray(Item[] itemArray) {
        String[] itemTextArray;
        if (itemArray == null) {
            itemTextArray = null;
        } else {
            itemTextArray = new String[itemArray.length];
            int i = 0;
            while (i < itemArray.length) {
                Item item = itemArray[i];
                itemTextArray[i] = item == null ? null : SwtUtils.removeMnemonics(item.getText());
                ++i;
            }
        }
        return itemTextArray;
    }

    private Rectangle getVisibleBounds(Rectangle cellBounds) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getEventThreadQueuer().invokeAndWait("getVisibleCellBounds: " + cellBounds, new IRunnable(){

            public Object run() {
                return TableTester.this.getTable().getClientArea();
            }
        });
        Rectangle visibleTableBounds = new Rectangle(r.x, r.y, r.width, r.height);
        Rectangle visibleCellBounds = visibleTableBounds.intersection(cellBounds);
        return visibleCellBounds;
    }

    private Point getConvertedLocation(final Rectangle constraints) {
        Point convertedLocation = (Point)this.getEventThreadQueuer().invokeAndWait("toDisplay", new IRunnable(){

            public Object run() throws StepExecutionException {
                return TableTester.this.getTable().toDisplay(constraints.x, constraints.y);
            }
        });
        return convertedLocation;
    }

    private Rectangle getCellBounds(final int row, final int col) {
        final Table table = this.getTable();
        Rectangle cellBounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("evaluateCellBounds", new IRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                TableTester.this.checkRowColBounds(row, col);
                TableItem ti = table.getItem(row);
                int column = table.getColumnCount() > 0 || col > 0 ? col : 0;
                org.eclipse.swt.graphics.Rectangle r = ti.getBounds(column);
                String text = ti.getText(column);
                Image image = ti.getImage(column);
                if (text != null && text.length() != 0) {
                    GC gc = new GC((Drawable)table);
                    int charWidth = 0;
                    try {
                        FontMetrics fm = gc.getFontMetrics();
                        charWidth = fm.getAverageCharWidth();
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        gc.dispose();
                        throw throwable;
                    }
                    {
                        Object var9_11 = null;
                    }
                    gc.dispose();
                    r.width = text.length() * charWidth;
                    if (image != null) {
                        r.width += image.getBounds().width;
                    }
                } else if (image != null) {
                    r.width = image.getBounds().width;
                }
                if (column > 0) {
                    TableColumn tc = table.getColumn(column);
                    int alignment = tc.getAlignment();
                    if (alignment == 0x1000000) {
                        r.x = (int)((double)r.x + ((double)tc.getWidth() / 2.0 - (double)r.width / 2.0));
                    }
                    if (alignment == 131072) {
                        r.x += tc.getWidth() - r.width;
                    }
                }
                return new Rectangle(r.x, r.y, r.width, r.height);
            }
        });
        return cellBounds;
    }

    protected Object getSpecificRectangle(Rectangle rectangle) {
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void gdClickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        int correctedYPos = this.correctYPos(yPos, yUnits);
        super.gdClickDirect(count, button, xPos, xUnits, correctedYPos, yUnits);
    }

    private int correctYPos(int pos, String units) {
        int correctedPos = pos;
        int headerHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getHeaderHeight", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new Integer(((Table)TableTester.this.getComponent().getRealComponent()).getHeaderHeight());
            }
        });
        if ("Pixel".equalsIgnoreCase(units)) {
            correctedPos += headerHeight;
        } else {
            int totalHeight = (Integer)this.getEventThreadQueuer().invokeAndWait("getWidgetBounds", new IRunnable(){

                public Object run() throws StepExecutionException {
                    return new Integer(SwtUtils.getWidgetBounds((Widget)((Widget)TableTester.this.getComponent().getRealComponent())).height);
                }
            });
            long targetHeight = totalHeight - headerHeight;
            long targetPos = Math.round((double)targetHeight * (double)pos / 100.0);
            double heightPercentage = (double)(targetPos += (long)headerHeight) / (double)totalHeight * 100.0;
            correctedPos = (int)Math.round(heightPercentage);
            if (correctedPos > 100) {
                correctedPos = 100;
            }
        }
        return correctedPos;
    }

    public void gdDragCell(int mouseButton, String modifier, String row, String rowOperator, String col, String colOperator, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, "no", 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCell(final String row, final String rowOperator, final String col, final String colOperator, final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) throws StepExecutionException {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropCell", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    TableTester.this.gdSelectCell(row, rowOperator, col, colOperator, 0, xPos, xUnits, yPos, yUnits, "no", 1);
                    return null;
                }
            });
            TableTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragRowByValue(int mouseButton, String modifier, String col, String colOperator, String value, String regexOp, String searchType) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectRowByValue(col, colOperator, value, regexOp, 1, "no", searchType, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropRowByValue(final String col, final String colOperator, final String value, final String regexOp, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropRowByValue", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    TableTester.this.gdSelectRowByValue(col, colOperator, value, regexOp, "no", searchType, ClickOptions.create().setClickCount(0));
                    return null;
                }
            });
            TableTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void gdDragCellByColValue(int mouseButton, String modifier, String row, String rowOperator, String value, String regex, String searchType) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.gdSelectCellByColValue(row, rowOperator, value, regex, "no", searchType, ClickOptions.create().setClickCount(0));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDropCellByColValue(final String row, final String rowOperator, final String value, final String regex, final String searchType, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        this.pressOrReleaseModifiers(dndHelper.getModifier(), true);
        try {
            this.getEventThreadQueuer().invokeAndWait("gdDropCellByColValue", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
                    CAPUtil.shakeMouse();
                    TableTester.this.gdSelectCellByColValue(row, rowOperator, value, regex, "no", searchType, ClickOptions.create().setClickCount(0));
                    return null;
                }
            });
            TableTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        robot.mouseRelease((Object)dndHelper.getDragComponent(), null, dndHelper.getMouseButton());
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }
}

