/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.IndexConverter;
import org.eclipse.jubula.rc.common.implclasses.MatchUtil;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableAdapter;
import org.eclipse.jubula.rc.swt.listener.TableSelectionTracker;
import org.eclipse.jubula.rc.swt.tester.adapter.WidgetAdapter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableAdapter
extends WidgetAdapter
implements ITableAdapter {
    private static AutServerLogger log;
    private Table m_table;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.tester.adapter.TableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public TableAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_table = (Table)objectToAdapt;
    }

    public int getColumnCount() {
        Integer returnvalue = (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnCount", new IRunnable(){

            public Object run() {
                return new Integer(TableAdapter.this.m_table.getColumnCount());
            }
        });
        return returnvalue;
    }

    public int getRowCount() {
        Integer returnvalue = (Integer)this.getEventThreadQueuer().invokeAndWait("getRowCount", new IRunnable(){

            public Object run() {
                return new Integer(TableAdapter.this.m_table.getItemCount());
            }
        });
        return returnvalue;
    }

    public String getCellText(final int row, final int column) {
        String current = (String)this.getEventThreadQueuer().invokeAndWait("getCellText", new IRunnable(){

            public Object run() {
                String value = TableAdapter.this.m_table.getItem(row).getText(column);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting cell text:");
                    log.debug((Object)("Row, col: " + row + ", " + column));
                    log.debug((Object)("Value: " + value));
                }
                return value;
            }
        });
        return current;
    }

    public String getColumnName(final int column) {
        String current = (String)this.getEventThreadQueuer().invokeAndWait("getColumnName", new IRunnable(){

            public Object run() {
                String value = TableAdapter.this.m_table.getColumn(column).getText();
                return value;
            }
        });
        return current;
    }

    public int getColumnFromString(final String col, final String operator) {
        int column = -2;
        try {
            int usrIdxCol = Integer.parseInt(col);
            if (usrIdxCol == 0) {
                ++usrIdxCol;
            }
            column = IndexConverter.toImplementationIndex((int)usrIdxCol);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Boolean isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("getColumnFromString", new IRunnable(){

                    public Object run() {
                        return new Boolean(TableAdapter.this.m_table.getHeaderVisible());
                    }
                });
                if (!isVisible.booleanValue()) {
                    throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                }
                Integer implCol = (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnFromString", new IRunnable(){

                    public Object run() throws StepExecutionException {
                        int i = 0;
                        while (i < TableAdapter.this.m_table.getColumnCount()) {
                            TableColumn tblCol = TableAdapter.this.m_table.getColumn(i);
                            if (MatchUtil.getInstance().match(tblCol.getText(), col, operator)) {
                                return new Integer(i);
                            }
                            ++i;
                        }
                        return new Integer(-2);
                    }
                });
                column = implCol;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return column;
    }

    public String getRowName(final int row) {
        String current = (String)this.getEventThreadQueuer().invokeAndWait("getRowName", new IRunnable(){

            public Object run() {
                String value = TableAdapter.this.m_table.getItem(row).getText();
                return value;
            }
        });
        return current;
    }

    public int getRowFromString(final String row, final String operator) {
        int rowInt = -2;
        try {
            Boolean isVisible;
            rowInt = IndexConverter.toImplementationIndex((int)Integer.parseInt(row));
            if (rowInt == -1 && !(isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("getRowFromString", new IRunnable(){

                public Object run() {
                    return new Boolean(TableAdapter.this.m_table.getHeaderVisible());
                }
            })).booleanValue()) {
                throw new StepExecutionException("Header not visible", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            Integer implRow = (Integer)this.getEventThreadQueuer().invokeAndWait("getRowFromString", new IRunnable(){

                public Object run() throws StepExecutionException {
                    int i = 0;
                    while (i < TableAdapter.this.m_table.getItemCount()) {
                        String cellTxt = TableAdapter.this.getCellText(i, 0);
                        if (MatchUtil.getInstance().match(cellTxt, row, operator)) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                    return new Integer(-2);
                }
            });
            rowInt = implRow;
        }
        return rowInt;
    }

    public Rectangle getBounds() {
        Rectangle returnvalue = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getBounds", new IRunnable(){

            public Object run() throws StepExecutionException {
                return TableAdapter.this.m_table.getBounds();
            }
        });
        return returnvalue;
    }

    public Rectangle getHeaderBounds(final int col) {
        Rectangle cellBounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getHeaderBounds", new IRunnable(){

            public Object run() throws StepExecutionException {
                org.eclipse.swt.graphics.Rectangle rect = TableAdapter.this.m_table.getItem(0).getBounds(col);
                rect.y = ((TableAdapter)TableAdapter.this).m_table.getClientArea().y;
                return new Rectangle(rect.x, rect.y, rect.width, rect.height);
            }
        });
        return cellBounds;
    }

    public Cell getSelectedCell() throws StepExecutionException {
        Cell cell = (Cell)this.getEventThreadQueuer().invokeAndWait("getSelectedSell", new IRunnable(){

            public Object run() throws StepExecutionException {
                return TableSelectionTracker.getInstance().getSelectedCell(TableAdapter.this.m_table);
            }
        });
        return cell;
    }

    public boolean isHeaderVisible() {
        Boolean isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("isHeaderVisible", new IRunnable(){

            public Object run() {
                return new Boolean(TableAdapter.this.m_table.getHeaderVisible());
            }
        });
        return isVisible;
    }

    public boolean isCellEditable(int row, int col) {
        final Control cellEditor = (Control)this.activateEditor(new Cell(row, col));
        boolean isEditable = (Boolean)this.getEventThreadQueuer().invokeAndWait("isCellEditable", new IRunnable(){

            public Object run() {
                return TableAdapter.this.isEditable(cellEditor) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEditable;
    }

    public boolean hasCellSelection() {
        TableItem[] selItems = (TableItem[])this.getEventThreadQueuer().invokeAndWait("hasCellSelection", new IRunnable(){

            public Object run() {
                return TableAdapter.this.m_table.getSelection();
            }
        });
        return selItems.length > 0;
    }

    public Rectangle scrollCellToVisible(final int row, final int col) throws StepExecutionException {
        final Table table = this.m_table;
        this.getEventThreadQueuer().invokeAndWait("scrollCellToVisible", new IRunnable(){

            public Object run() {
                if (table.getColumnCount() > 0 || col > 0) {
                    table.showColumn(table.getColumn(col));
                }
                table.showItem(table.getItem(row));
                return null;
            }
        });
        final Rectangle cellBoundsRelativeToParent = this.getCellBounds(row, col);
        this.getEventThreadQueuer().invokeAndWait("getCellBoundsRelativeToParent", new IRunnable(){

            public Object run() {
                Point cellOriginRelativeToParent = table.getDisplay().map((Control)table, (Control)table.getParent(), new Point(cellBoundsRelativeToParent.x, cellBoundsRelativeToParent.y));
                cellBoundsRelativeToParent.x = cellOriginRelativeToParent.x;
                cellBoundsRelativeToParent.y = cellOriginRelativeToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getEventThreadQueuer().invokeAndWait("getParent", new IRunnable(){

            public Object run() {
                table.getParent();
                return null;
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)cellBoundsRelativeToParent);
        return this.getVisibleBounds(this.getCellBounds(row, col));
    }

    private Rectangle getCellBounds(final int row, final int col) {
        Rectangle cellBounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("evaluateCellBounds", new IRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                TableAdapter.this.checkRowColBounds(row, col);
                TableItem ti = TableAdapter.this.m_table.getItem(row);
                int column = TableAdapter.this.m_table.getColumnCount() > 0 || col > 0 ? col : 0;
                org.eclipse.swt.graphics.Rectangle r = ti.getBounds(column);
                String text = ti.getText(column);
                Image image = ti.getImage(column);
                if (text != null && text.length() != 0) {
                    GC gc = new GC((Drawable)TableAdapter.this.m_table);
                    int charWidth = 0;
                    try {
                        FontMetrics fm = gc.getFontMetrics();
                        charWidth = fm.getAverageCharWidth();
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        gc.dispose();
                        throw throwable;
                    }
                    {
                        Object var9_11 = null;
                    }
                    gc.dispose();
                    r.width = text.length() * charWidth;
                    if (image != null) {
                        r.width += image.getBounds().width;
                    }
                } else if (image != null) {
                    r.width = image.getBounds().width;
                }
                if (column > 0) {
                    TableColumn tc = TableAdapter.this.m_table.getColumn(column);
                    int alignment = tc.getAlignment();
                    if (alignment == 0x1000000) {
                        r.x = (int)((double)r.x + ((double)tc.getWidth() / 2.0 - (double)r.width / 2.0));
                    }
                    if (alignment == 131072) {
                        r.x += tc.getWidth() - r.width;
                    }
                }
                return new Rectangle(r.x, r.y, r.width, r.height);
            }
        });
        return cellBounds;
    }

    private void checkBounds(int value, int count) {
        if (value < 0 || value >= count) {
            throw new StepExecutionException("Invalid row/column: " + value, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndexOrHeader"));
        }
    }

    protected void checkRowColBounds(int row, int column) throws StepExecutionException {
        this.checkBounds(row, this.getRowCount());
        int colCount = this.getColumnCount();
        if (colCount > 0 || column > 0) {
            this.checkBounds(column, colCount);
        }
    }

    private Rectangle getVisibleBounds(Rectangle cellBounds) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getEventThreadQueuer().invokeAndWait("getVisibleCellBounds: " + cellBounds, new IRunnable(){

            public Object run() {
                return TableAdapter.this.m_table.getClientArea();
            }
        });
        Rectangle visibleTableBounds = new Rectangle(r.x, r.y, r.width, r.height);
        Rectangle visibleCellBounds = visibleTableBounds.intersection(cellBounds);
        return visibleCellBounds;
    }

    private boolean isEditable(Control cellEditor) {
        if (cellEditor == null || cellEditor instanceof TableCursor || cellEditor == this.m_table) {
            return false;
        }
        return (cellEditor.getStyle() & 8) == 0;
    }

    private boolean invokeIsEditable(final Control cellEditor) {
        boolean isEditable = (Boolean)this.getEventThreadQueuer().invokeAndWait("getSelectedCell", new IRunnable(){

            public Object run() {
                return TableAdapter.this.isEditable(cellEditor) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEditable;
    }

    public Object activateEditor(Cell cell) {
        Rectangle rect = this.scrollCellToVisible(cell.getRow(), cell.getCol());
        Control editor = this.getTableCellEditor(cell, rect);
        if (!this.invokeIsEditable(editor)) {
            org.eclipse.swt.graphics.Rectangle cellBounds = new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
            ClickOptions co = ClickOptions.create().setClickCount(2);
            Table clickTarget = editor == null || editor instanceof TableCursor ? this.m_table : editor;
            this.getRobot().click((Object)clickTarget, (Object)cellBounds, co);
            editor = this.getTableCellEditor(cell, rect);
        }
        return editor;
    }

    private Control getTableCellEditor(Cell cell, Rectangle rect) {
        org.eclipse.swt.graphics.Rectangle swtRect = new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
        this.getRobot().click((Object)this.m_table, (Object)swtRect, ClickOptions.create().setClickCount(1));
        return SwtUtils.getCursorControl();
    }

    public String getText() {
        Cell selectedCell = this.getSelectedCell();
        return this.getCellText(selectedCell.getRow(), selectedCell.getCol());
    }

    public Object getTableHeader() {
        return this.m_table;
    }
}

