/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.listener.EventLock;
import org.eclipse.jubula.rc.common.tester.AbstractMenuTester;
import org.eclipse.jubula.rc.common.tester.WidgetTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IWidgetAdapter;
import org.eclipse.jubula.rc.swt.driver.DragAndDropHelperSwt;
import org.eclipse.jubula.rc.swt.driver.EventThreadQueuerSwtImpl;
import org.eclipse.jubula.rc.swt.driver.KeyCodeConverter;
import org.eclipse.jubula.rc.swt.implclasses.EventListener;
import org.eclipse.jubula.rc.swt.implclasses.SimulatedTooltip;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.MenuTester;
import org.eclipse.jubula.rc.swt.tester.adapter.AbstractComponentAdapter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public abstract class WidgetAdapter
extends AbstractComponentAdapter
implements IWidgetAdapter {
    protected static final String POS_UNIT_PIXEL = "Pixel";
    protected static final String POS_UNI_PERCENT = "Percent";
    private Control m_component;

    protected WidgetAdapter(Object objectToAdapt) {
        this.m_component = (Control)objectToAdapt;
    }

    public Object getRealComponent() {
        return this.m_component;
    }

    protected IRobot getRobot() throws RobotException {
        return AUTServer.getInstance().getRobot();
    }

    public IEventThreadQueuer getEventThreadQueuer() {
        return this.getRobotFactory().getEventThreadQueuer();
    }

    public String getPropteryValue(final String propertyname) {
        Object prop = this.getEventThreadQueuer().invokeAndWait("getProperty", new IRunnable(){

            public Object run() throws StepExecutionException {
                try {
                    return WidgetAdapter.this.getRobot().getPropertyValue(WidgetAdapter.this.getRealComponent(), propertyname);
                }
                catch (RobotException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        return String.valueOf(prop);
    }

    public boolean isShowing() {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("isShowing", new IRunnable(){

            public Object run() {
                return WidgetAdapter.this.m_component.isVisible() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return actual;
    }

    public boolean isEnabled() {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("isEnabled", new IRunnable(){

            public Object run() {
                return WidgetAdapter.this.m_component.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return actual;
    }

    public boolean hasFocus() {
        Boolean actual = (Boolean)this.getEventThreadQueuer().invokeAndWait("hasFocus", new IRunnable(){

            public Object run() {
                return WidgetAdapter.this.m_component.isFocusControl() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return actual;
    }

    public AbstractMenuTester showPopup(int button) {
        Control component = this.m_component;
        if (SwtUtils.isMouseCursorInWidget((Widget)component)) {
            return this.showPopup((Widget)component, new Runnable((Widget)component, button){
                private final /* synthetic */ Widget val$component;
                private final /* synthetic */ int val$button;
                {
                    this.val$component = widget;
                    this.val$button = n;
                }

                public void run() {
                    RobotTiming.sleepPreShowPopupDelay();
                    WidgetAdapter.this.getRobot().clickAtCurrentPosition((Object)this.val$component, 1, this.val$button);
                }
            });
        }
        return this.showPopup(50, POS_UNI_PERCENT, 50, POS_UNI_PERCENT, button);
    }

    public AbstractMenuTester showPopup(int xPos, final String xUnits, int yPos, final String yUnits, int button) throws StepExecutionException {
        Control component = this.m_component;
        return this.showPopup((Widget)component, new Runnable((Widget)component, button, xPos, yPos){
            private final /* synthetic */ Widget val$component;
            private final /* synthetic */ int val$button;
            private final /* synthetic */ int val$xPos;
            private final /* synthetic */ int val$yPos;
            {
                this.val$component = widget;
                this.val$button = n;
                this.val$xPos = n2;
                this.val$yPos = n3;
            }

            public void run() {
                RobotTiming.sleepPreShowPopupDelay();
                boolean isAbsoluteUnitsX = WidgetAdapter.POS_UNIT_PIXEL.equalsIgnoreCase(xUnits);
                boolean isAbsoluteUnitsY = WidgetAdapter.POS_UNIT_PIXEL.equalsIgnoreCase(yUnits);
                WidgetAdapter.this.getRobot().click((Object)this.val$component, null, ClickOptions.create().setClickCount(1).setMouseButton(this.val$button), this.val$xPos, isAbsoluteUnitsX, this.val$yPos, isAbsoluteUnitsY);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractMenuTester showPopup(Widget component, Runnable showPopup) throws StepExecutionException {
        PopupShownCondition cond = new PopupShownCondition();
        EventLock lock = new EventLock();
        final EventListener listener = new EventListener(lock, cond);
        final Display d = component.getDisplay();
        EventThreadQueuerSwtImpl queuer = new EventThreadQueuerSwtImpl();
        queuer.invokeAndWait("addPopupShownListeners", new IRunnable(){

            public Object run() {
                d.addFilter(22, (Listener)listener);
                return null;
            }
        });
        try {
            try {
                showPopup.run();
                EventLock eventLock = lock;
                synchronized (eventLock) {
                    long timeout = 10000L;
                    long done = System.currentTimeMillis() + timeout;
                    while (true) {
                        block10: {
                            if (!lock.isReleased() && timeout > 0L) break block10;
                            break;
                        }
                        lock.wait(timeout);
                        long now = System.currentTimeMillis();
                        timeout = done - now;
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var15_13 = null;
            queuer.invokeAndWait("removePopupShownListeners", new IRunnable(d, listener){
                private final /* synthetic */ Display val$d;
                private final /* synthetic */ EventListener val$listener;
                {
                    this.val$d = display;
                    this.val$listener = eventListener;
                }

                public Object run() {
                    this.val$d.removeFilter(22, (Listener)this.val$listener);
                    return null;
                }
            });
            throw throwable;
        }
        {
            Object var15_14 = null;
        }
        queuer.invokeAndWait("removePopupShownListeners", new /* invalid duplicate definition of identical inner class */);
        if (!lock.isReleased()) {
            throw new StepExecutionException("popup not shown", EventFactory.createActionError((String)"TestErrorEvent.PopupNotFound"));
        }
        MenuTester contextMenu = new MenuTester();
        contextMenu.setComponent(cond.getPopup());
        contextMenu.setContextMenu(true);
        return contextMenu;
    }

    public void showToolTip(final String text, final int textSize, final int timePerWord, final int windowWidth) {
        final Rectangle bounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("gdShowText.getBounds", new IRunnable(){

            public Object run() {
                return SwtUtils.getWidgetBounds((Widget)WidgetAdapter.this.m_component);
            }
        });
        SimulatedTooltip sp = (SimulatedTooltip)this.getEventThreadQueuer().invokeAndWait("gdShowText.initToolTip", new IRunnable(){

            public Object run() throws StepExecutionException {
                return new SimulatedTooltip(timePerWord, text, windowWidth, textSize, bounds);
            }
        });
        sp.start();
        try {
            sp.join();
        }
        catch (InterruptedException e) {
            throw new StepExecutionException((Throwable)e);
        }
    }

    public void gdDrag(int mouseButton, String modifier, int xPos, String xUnits, int yPos, String yUnits) {
        DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        dndHelper.setDragComponent(null);
        this.clickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gdDrop(final int xPos, final String xUnits, final int yPos, final String yUnits, int delayBeforeDrop) {
        final DragAndDropHelperSwt dndHelper = DragAndDropHelperSwt.getInstance();
        final IRobot robot = this.getRobot();
        String modifier = dndHelper.getModifier();
        final int mouseButton = dndHelper.getMouseButton();
        try {
            CAPUtil.pressOrReleaseModifiers(modifier, true);
            this.getEventThreadQueuer().invokeAndWait("gdStartDrag", new IRunnable(){

                public Object run() throws StepExecutionException {
                    robot.mousePress((Object)dndHelper.getDragComponent(), null, mouseButton);
                    CAPUtil.shakeMouse();
                    WidgetAdapter.this.clickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
                    return null;
                }
            });
            WidgetTester.waitBeforeDrop((int)delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.getRobot().mouseRelease(null, null, mouseButton);
            CAPUtil.pressOrReleaseModifiers(modifier, false);
            throw throwable;
        }
        {
            Object var10_12 = null;
        }
        this.getRobot().mouseRelease(null, null, mouseButton);
        CAPUtil.pressOrReleaseModifiers(modifier, false);
    }

    protected void clickDirect(int count, int button, int xPos, String xUnits, int yPos, String yUnits) throws StepExecutionException {
        this.getRobot().click((Object)this.m_component, null, ClickOptions.create().setClickCount(count).setMouseButton(button), xPos, xUnits.equalsIgnoreCase(POS_UNIT_PIXEL), yPos, yUnits.equalsIgnoreCase(POS_UNIT_PIXEL));
    }

    public int getKeyCode(String mod) {
        return KeyCodeConverter.getKeyCode(mod);
    }

    protected static class PopupShownCondition
    implements EventListener.Condition {
        private Menu m_popup = null;

        protected PopupShownCondition() {
        }

        public Menu getPopup() {
            return this.m_popup;
        }

        public boolean isTrue(Event event) {
            if (event.type == 22 && event.widget instanceof Menu) {
                this.m_popup = (Menu)event.widget;
                return true;
            }
            return false;
        }
    }
}

