/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.dummyrecord.LastCellOfRowDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingCellDummyRecord;
import org.apache.poi.hssf.eventusermodel.dummyrecord.MissingRowDummyRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.NoteRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;

public final class MissingRecordAwareHSSFListener
implements HSSFListener {
    private HSSFListener childListener;
    private int lastRowRow;
    private int lastCellRow;
    private int lastCellColumn;

    public MissingRecordAwareHSSFListener(HSSFListener listener) {
        this.resetCounts();
        this.childListener = listener;
    }

    public void processRecord(Record record) {
        int thisColumn;
        int thisRow;
        if (record instanceof CellValueRecordInterface) {
            CellValueRecordInterface valueRec = (CellValueRecordInterface)((Object)record);
            thisRow = valueRec.getRow();
            thisColumn = valueRec.getColumn();
        } else {
            thisRow = -1;
            thisColumn = -1;
            switch (record.getSid()) {
                case 2057: {
                    BOFRecord bof = (BOFRecord)record;
                    if (bof.getType() != 5 && bof.getType() != 16) break;
                    this.resetCounts();
                    break;
                }
                case 520: {
                    RowRecord rowrec = (RowRecord)record;
                    if (this.lastRowRow + 1 < rowrec.getRowNumber()) {
                        int i = this.lastRowRow + 1;
                        while (i < rowrec.getRowNumber()) {
                            MissingRowDummyRecord dr = new MissingRowDummyRecord(i);
                            this.childListener.processRecord(dr);
                            ++i;
                        }
                    }
                    this.lastRowRow = rowrec.getRowNumber();
                    break;
                }
                case 1212: {
                    this.childListener.processRecord(record);
                    return;
                }
                case 28: {
                    NoteRecord nrec = (NoteRecord)record;
                    thisRow = nrec.getRow();
                    thisColumn = nrec.getColumn();
                }
            }
        }
        if (thisRow != this.lastCellRow && this.lastCellRow > -1) {
            int i = this.lastCellRow;
            while (i < thisRow) {
                int cols = -1;
                if (i == this.lastCellRow) {
                    cols = this.lastCellColumn;
                }
                this.childListener.processRecord(new LastCellOfRowDummyRecord(i, cols));
                ++i;
            }
        }
        if (this.lastCellRow != -1 && this.lastCellColumn != -1 && thisRow == -1) {
            this.childListener.processRecord(new LastCellOfRowDummyRecord(this.lastCellRow, this.lastCellColumn));
            this.lastCellRow = -1;
            this.lastCellColumn = -1;
        }
        if (thisRow != this.lastCellRow) {
            this.lastCellColumn = -1;
        }
        if (this.lastCellColumn != thisColumn - 1) {
            int i = this.lastCellColumn + 1;
            while (i < thisColumn) {
                this.childListener.processRecord(new MissingCellDummyRecord(thisRow, i));
                ++i;
            }
        }
        if (thisColumn != -1) {
            this.lastCellColumn = thisColumn;
            this.lastCellRow = thisRow;
        }
        this.childListener.processRecord(record);
    }

    private void resetCounts() {
        this.lastRowRow = -1;
        this.lastCellRow = -1;
        this.lastCellColumn = -1;
    }
}

