/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.rcp.businessprocess.AbstractActionBP;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractAction
implements IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    private Set<IAction> m_actPool = new HashSet<IAction>();

    public void dispose() {
        if (this.getActionBP() != null) {
            this.getActionBP().unregisterActionDelegate(this);
        }
    }

    protected AbstractActionBP getActionBP() {
        return null;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IAction action) {
        if (this.getActionBP() != null) {
            this.getActionBP().registerActionDelegate(this);
        }
        this.registerAction(action);
    }

    public abstract void runWithEvent(IAction var1, Event var2);

    public static boolean handleLockedObject(IPersistentObject po) {
        boolean result = false;
        IEditorPart editor = JBEditorHelper.findEditor2LockedObj(po);
        if (editor != null) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_LOCK_OBJ_1, (Object[])new Object[]{po.getName(), editor.getTitle()}, null);
            result = true;
        }
        return result;
    }

    public void setEnabledStatus(boolean enabled) {
        for (IAction action : this.m_actPool) {
            action.setEnabled(enabled);
        }
    }

    protected void registerAction(IAction proxy) {
        this.m_actPool.add(proxy);
        if (this.getActionBP() != null) {
            this.getActionBP().setEnabledStatus();
        }
    }
}

