/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.FindResponsibleNodesForComponentNameOp;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.query.ShowWhereUsedComponentNameQuery;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowResponsibleNodeForComponentName
extends ShowWhereUsedComponentNameQuery {
    private IAUTMainPO m_aut;

    public ShowResponsibleNodeForComponentName(IComponentNamePO compName, IAUTMainPO aut) {
        super(compName);
        this.m_aut = aut;
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTimestamp());
        sb.append(":");
        sb.append(" ");
        sb.append(Messages.UIJobSearchingResponsibleCompNames);
        sb.append(" ");
        sb.append("\"");
        sb.append(this.getCompName().getName());
        sb.append("\"");
        return sb.toString();
    }

    @Override
    public IStatus run(IProgressMonitor monitor) {
        this.calculateUseOfLogicalName(this.getCompName().getGuid(), monitor);
        return Status.OK_STATUS;
    }

    @Override
    protected void calculateUseOfLogicalName(String logicalName, IProgressMonitor monitor) {
        monitor.beginTask(NLS.bind((String)Messages.ShowResponsibleNodeOperation, (Object)this.getCompName().getName()), -1);
        Set<INodePO> compnameUsingNodes = ShowResponsibleNodeForComponentName.calculateListOfCompNameUsingNodes(logicalName, this.m_aut);
        ArrayList<BasicSearchResult.SearchResultElement> reuseLoc = new ArrayList<BasicSearchResult.SearchResultElement>(compnameUsingNodes.size());
        reuseLoc.addAll(this.getSearchResultList(compnameUsingNodes, "org.eclipse.jubula.client.ui.rcp.views.CompNamesView"));
        this.setSearchResult(reuseLoc);
        monitor.done();
    }

    public static Set<INodePO> calculateListOfCompNameUsingNodes(String logicalNameGUID, IAUTMainPO searchAUT) {
        HashSet<INodePO> compnameUsingNodes = new HashSet<INodePO>();
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites((IProjectPO)currentProject)) {
            IAUTMainPO aut = ts.getAut();
            if (aut == null || !ObjectUtils.equals((Object)aut.getGuid(), (Object)searchAUT.getGuid())) continue;
            FindResponsibleNodesForComponentNameOp op = new FindResponsibleNodesForComponentNameOp(logicalNameGUID);
            TreeTraverser traverser = new TreeTraverser((INodePO)ts, (ITreeNodeOperation)op);
            traverser.traverse(true);
            compnameUsingNodes.addAll(op.getNodes());
        }
        return compnameUsingNodes;
    }
}

