/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.MissingArgEval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.functions.CountUtils;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Count
implements Function {
    private static final CountUtils.I_MatchPredicate predicate = new CountUtils.I_MatchPredicate(){

        public boolean matches(Eval valueEval) {
            if (valueEval instanceof NumberEval) {
                return true;
            }
            return valueEval == MissingArgEval.instance;
        }
    };

    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        int nArgs = args.length;
        if (nArgs < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        if (nArgs > 30) {
            return ErrorEval.VALUE_INVALID;
        }
        int temp = 0;
        int i = 0;
        while (i < nArgs) {
            temp += CountUtils.countArg(args[i], predicate);
            ++i;
        }
        return new NumberEval(temp);
    }
}

