/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.converter;

import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.jubula.client.archive.converter.AbstractXmlConverter;
import org.eclipse.jubula.client.archive.schema.Aut;
import org.eclipse.jubula.client.archive.schema.ComponentName;
import org.eclipse.jubula.client.archive.schema.Project;

public class V4C001
extends AbstractXmlConverter {
    private static final String OLD_WEB_TOOLKIT_ID = "com.bredexsw.guidancer.WebToolkitPlugin";

    protected boolean conversionIsNecessary(Project xml) {
        return true;
    }

    protected void convertImpl(Project xml) {
        this.cleanComponentNameTypes(xml);
        this.removeWebAUTs(xml);
    }

    private void removeWebAUTs(Project xml) {
        LinkedList<Integer> positionsToRemove = new LinkedList<Integer>();
        for (Aut a : xml.getAutList()) {
            if (!a.getAutToolkit().equals(OLD_WEB_TOOLKIT_ID)) continue;
            int i = 0;
            while (i < xml.getAutList().size()) {
                if (xml.getAutArray(i) == a) {
                    positionsToRemove.add(new Integer(i));
                }
                ++i;
            }
        }
        Collections.sort(positionsToRemove);
        Collections.reverse(positionsToRemove);
        for (Integer i : positionsToRemove) {
            xml.removeAut(i);
        }
    }

    private void cleanComponentNameTypes(Project xml) {
        for (ComponentName cn : xml.getComponentNamesList()) {
            if (!cn.getCompType().equals("com.bredexsw.guidancer.autieserver.implclasses.GraphicApplication")) continue;
            cn.setCompType("guidancer.concrete.GraphicApplication");
        }
    }
}

