/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.model.AbstractGuidNamePO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

@Entity
@Table(name="COMPONENT_NAMES", uniqueConstraints={@UniqueConstraint(columnNames={"PARENT_PROJ", "GUID"})})
@AttributeOverride(name="hbmGuid", column=@Column(name="GUID"))
class ComponentNamePO
extends AbstractGuidNamePO
implements IComponentNamePO,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedRest {
    private Long m_parentProjectId;
    private String m_componentType;
    private String m_referencedGuid;
    private String m_creationContext;
    private transient Integer m_version;
    static final long serialVersionUID = 3403808964096020741L;

    ComponentNamePO() {
        this.m_parentProjectId = null;
        this.m_componentType = null;
        this.m_referencedGuid = null;
        this.m_creationContext = null;
    }

    ComponentNamePO(String guid, String name, String type, ComponentNamesBP.CompNameCreationContext creationContext) {
        this.m_parentProjectId = null;
        this.m_componentType = null;
        this.m_referencedGuid = null;
        this.m_creationContext = null;
        this.setHbmGuid(guid);
        this.setHbmName(name);
        this.setHbmComponentType(type);
        this.setHbmCreationContext(creationContext.toString());
    }

    @Basic
    @Column(name="COMP_TYPE")
    String getHbmComponentType() {
        return this.m_componentType;
    }

    void setHbmComponentType(String componentType) {
        this.m_componentType = componentType;
    }

    @Basic
    @Column(name="REF_GUID")
    String getHbmReferencedGuid() {
        return this.m_referencedGuid;
    }

    void setHbmReferencedGuid(String referencedGuid) {
        this.m_referencedGuid = referencedGuid;
    }

    @Transient
    public String getComponentType() {
        return this.getHbmComponentType();
    }

    public void setComponentType(String componentType) {
        this.setHbmComponentType(componentType);
    }

    @Transient
    public String getReferencedGuid() {
        return this.getHbmReferencedGuid();
    }

    public void setReferencedGuid(String referencedGuid) {
        this.setHbmReferencedGuid(referencedGuid);
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    void setHbmParentProjectId(Long parentProjectId) {
        this.m_parentProjectId = parentProjectId;
    }

    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
    }

    @Basic
    @Column(name="CREATION_CONTEXT")
    String getHbmCreationContext() {
        return this.m_creationContext;
    }

    @Transient
    public ComponentNamesBP.CompNameCreationContext getCreationContext() {
        return ComponentNamesBP.CompNameCreationContext.forName(this.getHbmCreationContext());
    }

    void setHbmCreationContext(String creationContext) {
        this.m_creationContext = creationContext;
    }

    public final boolean isNameEqual(ComponentNamePO compNamePO) {
        return this.getHbmGuid().equals(compNamePO.getHbmGuid());
    }

    public boolean equals(Object obj) {
        if (this.getHbmParentProjectId() == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof ComponentNamePO)) {
            return false;
        }
        ComponentNamePO c = (ComponentNamePO)obj;
        return new EqualsBuilder().append((Object)this.getHbmParentProjectId(), (Object)c.getHbmParentProjectId()).append((Object)this.getHbmGuid(), (Object)c.getHbmGuid()).isEquals();
    }

    public int hashCode() {
        Long hbmParentProjectId = this.getHbmParentProjectId();
        String hbmGuid = this.getHbmGuid();
        if (hbmParentProjectId == null || hbmGuid == null) {
            return super.hashCode();
        }
        return hbmParentProjectId.hashCode() + hbmGuid.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.getName()).append("type", (Object)this.getComponentType()).append("guid", (Object)this.getGuid()).append("parentProjectId", (Object)this.getParentProjectId()).toString();
    }

    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ComponentNamePO(persistenceObject);
    }

    public ComponentNamePO(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "hbmReferencedGuid") {
            return this.hbmReferencedGuid;
        }
        if (string == "hbmComponentType") {
            return this.hbmComponentType;
        }
        if (string == "hbmCreationContext") {
            return this.hbmCreationContext;
        }
        if (string == "version") {
            return this.version;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "hbmReferencedGuid") {
            this.hbmReferencedGuid = (String)object;
            return;
        }
        if (string == "hbmComponentType") {
            this.hbmComponentType = (String)object;
            return;
        }
        if (string == "hbmCreationContext") {
            this.hbmCreationContext = (String)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

