/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.NodePO;
import org.eclipse.jubula.client.core.model.WrapperPO;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="EXEC_CONT")
public class ExecObjContPO
extends WrapperPO
implements IExecObjContPO,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedRest {
    private List<IExecPersistable> m_execObjList;
    static final long serialVersionUID = 4303405273256863839L;

    ExecObjContPO() {
        this.m_execObjList = new ArrayList<IExecPersistable>();
    }

    @Override
    @Transient
    public String getName() {
        return "ExecObjContPO";
    }

    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=NodePO.class)
    @OrderColumn(name="IDX")
    @BatchFetch(value=BatchFetchType.JOIN)
    List<IExecPersistable> getHbmExecObjList() {
        return this.m_execObjList;
    }

    @Override
    @Transient
    public List<IExecPersistable> getExecObjList() {
        for (IExecPersistable exec : this.m_execObjList) {
            exec.setParentNode(TSB_ROOT_NODE);
        }
        return Collections.unmodifiableList(this.getHbmExecObjList());
    }

    private void setHbmExecObjList(List<IExecPersistable> execObjList) {
        this.m_execObjList = execObjList;
    }

    @Override
    public void addExecObject(IExecPersistable execObj) {
        this.getHbmExecObjList().add(execObj);
        execObj.setParentNode(TSB_ROOT_NODE);
        execObj.setParentProjectId(this.getParentProjectId());
    }

    @Override
    public void removeExecObject(IExecPersistable execObj) {
        this.getHbmExecObjList().remove(execObj);
        execObj.setParentNode(null);
    }

    @Override
    public void setParentProjectId(Long projectId) {
        super.setParentProjectId(projectId);
        for (IExecPersistable exec : this.getExecObjList()) {
            exec.setParentProjectId(projectId);
        }
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return super.getParentProjectId();
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ExecObjContPO(persistenceObject);
    }

    public ExecObjContPO(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "hbmExecObjList") {
            return this.hbmExecObjList;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "hbmExecObjList") {
            this.hbmExecObjList = (List)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

