/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.CompNamesPairPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IEventHandlerContainer;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.TestCasePO;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.annotations.Index;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="E")
class ExecTestCasePO
extends TestCasePO
implements IEventHandlerContainer,
IExecTestCasePO,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedRest {
    private static final Logger LOG = LoggerFactory.getLogger(ExecTestCasePO.class);
    private transient ISpecTestCasePO m_cachedSpecTestCase = null;
    private boolean m_hasReferencedTD = true;
    private Map<String, Boolean> m_refEventTcMap = new HashMap<String, Boolean>(4);
    private Map<String, ICompNamesPairPO> m_compNamesMap;
    private String m_projectGuid;
    private String m_specTestCaseGuid;
    static final long serialVersionUID = 5862614027984778762L;

    ExecTestCasePO() {
        this.m_compNamesMap = new HashMap<String, ICompNamesPairPO>();
    }

    ExecTestCasePO(ISpecTestCasePO specTestCase, boolean isGenerated) {
        super(null, isGenerated);
        this.setSpecTestCase(specTestCase);
        this.m_compNamesMap = new HashMap<String, ICompNamesPairPO>();
    }

    ExecTestCasePO(ISpecTestCasePO specTestCase, String guid, boolean isGenerated) {
        super(null, guid, isGenerated);
        this.setSpecTestCase(specTestCase);
        this.m_compNamesMap = new HashMap<String, ICompNamesPairPO>();
    }

    ExecTestCasePO(String specTestCaseGuid, String projectGuid, String guid, boolean isGenerated) {
        super(null, guid, isGenerated);
        this.setSpecTestCaseGuid(specTestCaseGuid);
        this.setProjectGuid(projectGuid);
        this.m_compNamesMap = new HashMap<String, ICompNamesPairPO>();
    }

    ExecTestCasePO(String specTestCaseGuid, String projectGuid, boolean isGenerated) {
        super(null, isGenerated);
        this.setSpecTestCaseGuid(specTestCaseGuid);
        this.setProjectGuid(projectGuid);
        this.m_compNamesMap = new HashMap<String, ICompNamesPairPO>();
    }

    @Override
    @Transient
    public String getName() {
        String name = super.getName();
        if (name == null || name.equals("")) {
            if (this.getSpecTestCase() != null) {
                return this.getSpecTestCase().getName();
            }
            String reusedProjectName = ProjectNameBP.getInstance().getName(this.m_projectGuid);
            if (reusedProjectName != null && reusedProjectName.length() != 0) {
                return NLS.bind((String)Messages.ExecTestCasePOMissingReferenceWithProjectName, (Object)reusedProjectName);
            }
            return Messages.ExecTestCasePOMissingReference;
        }
        return name;
    }

    @Override
    @Transient
    public String getComment() {
        String comment = super.getComment();
        if ((comment == null || comment.equals("")) && this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getComment();
        }
        return comment;
    }

    @Override
    @Transient
    public String getDataFile() {
        String dataFile = super.getDataFile();
        if ((dataFile == null || dataFile.equals("")) && this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getDataFile();
        }
        return dataFile;
    }

    @Override
    @Transient
    public ISpecTestCasePO getSpecTestCase() {
        if (this.m_cachedSpecTestCase != null) {
            return this.m_cachedSpecTestCase;
        }
        ISpecTestCasePO specTc = null;
        try {
            if (this.getParentProjectId() != null) {
                if (this.getProjectGuid() == null || this.getProjectGuid().equals(ProjectPM.getGuidOfProjectId(this.getParentProjectId()))) {
                    specTc = NodePM.getSpecTestCase(this.getParentProjectId(), this.getSpecTestCaseGuid());
                } else {
                    HashSet<IReusedProjectPO> reusedProjects = new HashSet<IReusedProjectPO>();
                    reusedProjects.addAll(ProjectPM.loadReusedProjectsRO(this.getParentProjectId()));
                    specTc = NodePM.getSpecTestCase(reusedProjects, this.getProjectGuid(), this.getSpecTestCaseGuid());
                }
            }
        }
        catch (JBException e) {
            LOG.warn("Could not retrieve referenced Test Case.", (Throwable)e);
        }
        this.m_cachedSpecTestCase = specTc;
        return specTc;
    }

    @Override
    public void setSpecTestCase(ISpecTestCasePO specTestCase) {
        if (specTestCase != null) {
            if (this.getId() == null) {
                this.m_cachedSpecTestCase = specTestCase;
            }
            this.setSpecTestCaseGuid(specTestCase.getGuid());
            if (specTestCase.getParentProjectId() != this.getParentProjectId()) {
                try {
                    this.setProjectGuid(ProjectPM.loadProjectById(specTestCase.getParentProjectId()).getGuid());
                }
                catch (JBException jBException) {}
            } else {
                this.setProjectGuid(null);
            }
        }
    }

    @Override
    @Transient
    public List<IParamDescriptionPO> getParameterList() {
        if (this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getParameterList();
        }
        return new ArrayList<IParamDescriptionPO>();
    }

    @Override
    @Transient
    public ListIterator<IParamDescriptionPO> getParameterListIter() {
        if (this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getParameterListIter();
        }
        List emptyList = Collections.emptyList();
        return emptyList.listIterator();
    }

    @Override
    @Transient
    public int getParameterListSize() {
        if (this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getParameterListSize();
        }
        return 0;
    }

    @Override
    @Transient
    public ITDManager getDataManager() {
        if (this.getReferencedDataCube() == null && this.getHasReferencedTD() && this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getDataManager();
        }
        return super.getDataManager();
    }

    @Override
    public boolean hasReferencedTestData() {
        return super.hasReferencedTestData() || this.getHasReferencedTD() && this.getSpecTestCase() != null;
    }

    @Override
    @Transient
    public IParameterInterfacePO getReferencedDataCube() {
        if (this.getHasReferencedTD() && this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getReferencedDataCube();
        }
        return super.getReferencedDataCube();
    }

    @Transient
    private ITDManager getOwnDataManager() {
        return super.getDataManager();
    }

    @Override
    public void setDataManager(ITDManager dataManager) {
        super.setDataManager(dataManager);
        this.setHasReferencedTD(false);
    }

    @Override
    public void setParentProjectId(Long projectId) {
        super.setParentProjectId(projectId);
        for (ICompNamesPairPO compNamesPair : this.getCompNamesPairs()) {
            compNamesPair.setParentProjectId(projectId);
        }
    }

    @Override
    public ITDManager resolveTDReference() {
        if (this.getHasReferencedTD()) {
            ITDManager specTDMan = this.getSpecTestCase().getDataManager();
            ITDManager execTDMan = super.getHbmDataManager();
            ITDManager modifiedExecTDMan = specTDMan.deepCopy(execTDMan);
            this.setDataManager(modifiedExecTDMan);
        }
        return this.getDataManager();
    }

    @Override
    @Transient
    public Iterator<INodePO> getNodeListIterator() {
        if (this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getNodeListIterator();
        }
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    @Override
    @Transient
    public int getNodeListSize() {
        if (this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getNodeListSize();
        }
        return 0;
    }

    @Override
    @Basic
    @Column(name="REF_FLAG")
    @Index(name="PI_NODE_REF_FLAG")
    public boolean getHasReferencedTD() {
        return this.m_hasReferencedTD;
    }

    @Override
    public void setHasReferencedTD(boolean hasReferencedTD) {
        this.m_hasReferencedTD = hasReferencedTD;
    }

    @Override
    @Transient
    public Map<String, IEventExecTestCasePO> getEventMap() {
        return Collections.unmodifiableMap(this.getSpecTestCase().getEventExecTcMap());
    }

    @Override
    public IEventExecTestCasePO getEventExecTC(String eventType) {
        return this.getFlagForRefEventTc(eventType) ? this.getSpecTestCase().getEventExecTC(eventType) : this.getEventExecTC(eventType);
    }

    @Transient
    private Map<String, Boolean> getRefEventTcMap() {
        return this.m_refEventTcMap;
    }

    private void setRefEventTcMap(Map<String, Boolean> refEventTcMap) {
        this.m_refEventTcMap = refEventTcMap;
    }

    @Override
    public void setFlagForRefEventTc(String eventType, boolean flag) {
        this.getRefEventTcMap().put(eventType, flag);
    }

    @Override
    public boolean getFlagForRefEventTc(String eventType) {
        Boolean value = this.m_refEventTcMap.get(eventType);
        return value == null ? true : value;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, targetEntity=CompNamesPairPO.class)
    @MapKeyColumn(name="MK_EXECTC_COMPNAMES")
    @JoinColumn(name="FK_EXECTC")
    @BatchFetch(value=BatchFetchType.JOIN)
    private Map<String, ICompNamesPairPO> getHbmCompNamesMap() {
        return this.m_compNamesMap;
    }

    private void setHbmCompNamesMap(Map<String, ICompNamesPairPO> compNameMap) {
        this.m_compNamesMap = compNameMap;
    }

    @Override
    public void addCompNamesPair(ICompNamesPairPO pair) {
        String key = pair.getFirstName();
        if (!this.getHbmCompNamesMap().containsKey(key)) {
            this.getHbmCompNamesMap().put(key, pair);
            pair.setParentProjectId(this.getParentProjectId());
        }
    }

    @Override
    public void removeCompNamesPair(String firstName) {
        this.getHbmCompNamesMap().remove(firstName);
    }

    @Override
    public ICompNamesPairPO getCompNamesPair(String firstName) {
        return this.getHbmCompNamesMap().get(firstName);
    }

    @Override
    @Transient
    public Collection<ICompNamesPairPO> getCompNamesPairs() {
        return Collections.unmodifiableCollection(this.getHbmCompNamesMap().values());
    }

    @Override
    @Transient
    public String getRealName() {
        return super.getName();
    }

    @Override
    @Basic
    @Column(name="PARENT_PROJ_GUID")
    @Index(name="PI_NODE_PARENT_PROJECT_GUID")
    public String getProjectGuid() {
        return this.m_projectGuid;
    }

    @Override
    @Basic
    @Column(name="SPEC_TC_GUID")
    @Index(name="PI_NODE_SPEC_TC_GUID")
    public String getSpecTestCaseGuid() {
        return this.m_specTestCaseGuid;
    }

    private void setProjectGuid(String projectGuid) {
        this.m_projectGuid = projectGuid;
    }

    private void setSpecTestCaseGuid(String testCaseGuid) {
        this.m_specTestCaseGuid = testCaseGuid;
    }

    @Override
    @Transient
    public String getToolkitLevel() {
        return this.getSpecTestCase().getToolkitLevel();
    }

    @Override
    public void setToolkitLevel(String toolkitLevel) {
        ISpecTestCasePO specTestCase = this.getSpecTestCase();
        if (specTestCase != null) {
            specTestCase.setToolkitLevel(toolkitLevel);
        }
    }

    @Override
    public void clearCachedSpecTestCase() {
        this.m_cachedSpecTestCase = null;
    }

    @Override
    public void setCachedSpecTestCase(ISpecTestCasePO spec) {
        if (ObjectUtils.equals((Object)this.getSpecTestCaseGuid(), (Object)spec.getGuid())) {
            this.m_cachedSpecTestCase = spec;
        }
    }

    @Override
    public boolean isTestDataComplete(Locale locale) {
        if (this.getSpecTestCase() == null) {
            return false;
        }
        return super.isTestDataComplete(locale);
    }

    @Override
    public IParamDescriptionPO getParameterForName(String paramName) {
        if (this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getParameterForName(paramName);
        }
        return null;
    }

    @Override
    public IParamDescriptionPO getParameterForUniqueId(String uniqueId) {
        if (this.getSpecTestCase() != null) {
            return this.getSpecTestCase().getParameterForUniqueId(uniqueId);
        }
        return null;
    }

    @Override
    public void synchronizeParameterIDs() {
        if (this.getReferencedDataCube() == null) {
            ITDManager tdMan = this.getDataManager();
            List<IParamDescriptionPO> params = this.getParameterList();
            ArrayList<String> origParamIDs = new ArrayList<String>();
            ArrayList<String> header = new ArrayList<String>(tdMan.getUniqueIds());
            for (IParamDescriptionPO param : params) {
                origParamIDs.add(param.getUniqueId());
            }
            for (String origId : origParamIDs) {
                if (header.contains(origId)) continue;
                tdMan.addUniqueId(origId);
            }
            header = new ArrayList<String>(tdMan.getUniqueIds());
            for (String tdManParamId : header) {
                if (origParamIDs.contains(tdManParamId)) continue;
                tdMan.removeUniqueId(tdManParamId);
            }
        }
    }

    @Override
    public boolean checkHasUnusedTestData() {
        for (String colId : this.getDataManager().getUniqueIds()) {
            boolean hasColIdParam = false;
            ListIterator<IParamDescriptionPO> paramListIter = this.getParameterListIter();
            while (paramListIter.hasNext()) {
                IParamDescriptionPO paramDescr = paramListIter.next();
                if (!colId.equals(paramDescr.getUniqueId())) continue;
                hasColIdParam = true;
                break;
            }
            if (hasColIdParam) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ExecTestCasePO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "hbmCompNamesMap") {
            return this.hbmCompNamesMap;
        }
        if (string == "hasReferencedTD") {
            return this.hasReferencedTD;
        }
        if (string == "projectGuid") {
            return this.projectGuid;
        }
        if (string == "specTestCaseGuid") {
            return this.specTestCaseGuid;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "hbmCompNamesMap") {
            this.hbmCompNamesMap = (Map)object;
            return;
        }
        if (string == "hasReferencedTD") {
            this.hasReferencedTD = (Boolean)object;
            return;
        }
        if (string == "projectGuid") {
            this.projectGuid = (String)object;
            return;
        }
        if (string == "specTestCaseGuid") {
            this.specTestCaseGuid = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

