/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.model.CheckConfContPO;
import org.eclipse.jubula.client.core.model.ICheckConfContPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.LanguageHelper;
import org.eclipse.jubula.client.core.model.ReusedProjectPO;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="PROJECT_PROPERTIES")
class ProjectPropertiesPO
implements IProjectPropertiesPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedRest {
    private transient Long m_id = null;
    private Long m_parentProjectId = null;
    private transient Integer m_version = null;
    private String m_defaultLanguage;
    private Set<IReusedProjectPO> m_usedProjects = new HashSet<IReusedProjectPO>();
    private Set<String> m_projectLanguageList = new TreeSet<String>();
    private LanguageHelper m_langHelper = new LanguageHelper(this);
    private ICheckConfContPO m_checkConfCont;
    private transient boolean m_isModified = true;
    private String m_toolkit = null;
    private Integer m_majorNumber = null;
    private Integer m_minorNumber = null;
    private boolean m_isReusable = false;
    private boolean m_isProtected = false;
    private Integer m_testResultCleanupInterval = 5;
    static final long serialVersionUID = -4520354098118643203L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient List _persistence_relationshipInfo;

    ProjectPropertiesPO() {
        this(1, 0);
    }

    ProjectPropertiesPO(Integer majorNumber, Integer minorNumber) {
        this.setMajorNumber(majorNumber);
        this.setMinorNumber(minorNumber);
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public String getName() {
        return "Project properties";
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.m_parentProjectId;
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
        for (IReusedProjectPO reusedProj : this.getHbmUsedProjects()) {
            reusedProj.setParentProjectId(projectId);
        }
        if (this.getCheckConfCont() != null) {
            this.getCheckConfCont().setParentProjectId(projectId);
        }
    }

    @Override
    public void addLangToList(String lang) {
        this.getProjectLanguageList().add(lang);
    }

    @Override
    public void clearLangList() {
        this.getProjectLanguageList().clear();
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="PROJ_LANGUAGES")
    @Column(name="LANGUAGE")
    @OrderBy
    private Set<String> getProjectLanguageList() {
        return this.m_projectLanguageList;
    }

    @Override
    @Transient
    public Set<String> getHbmLanguageList() {
        return this.getProjectLanguageList();
    }

    private void setProjectLanguageList(Set<String> langList) {
        this.m_projectLanguageList = langList;
        this.m_isModified = true;
    }

    @Override
    @Transient
    public LanguageHelper getLangHelper() {
        return this.m_langHelper;
    }

    @Override
    @Transient
    public boolean isModified() {
        return this.m_isModified;
    }

    @Override
    public void setModified(boolean isModified) {
        this.m_isModified = isModified;
    }

    @Override
    public void addUsedProject(IReusedProjectPO reusedProject) {
        reusedProject.setParentProjectId(this.getParentProjectId());
        this.getHbmUsedProjects().add(reusedProject);
    }

    @Override
    public void removeUsedProject(IReusedProjectPO project) {
        this.getHbmUsedProjects().remove(project);
    }

    @Override
    @Basic
    @Column(name="IS_REUSABLE")
    public boolean getIsReusable() {
        return this.m_isReusable;
    }

    @Override
    @Basic
    @Column(name="IS_PROTECTED")
    public boolean getIsProtected() {
        return this.m_isProtected;
    }

    @Override
    @Transient
    public String getToolkit() {
        return this.getHbmToolkit();
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=ReusedProjectPO.class, fetch=FetchType.EAGER)
    @JoinColumn(name="FK_PROJ_PROPERTIES")
    private Set<IReusedProjectPO> getHbmUsedProjects() {
        return this.m_usedProjects;
    }

    private void setHbmUsedProjects(Set<IReusedProjectPO> reusedProjects) {
        this.m_usedProjects = reusedProjects;
    }

    @Override
    @Transient
    public Set<IReusedProjectPO> getUsedProjects() {
        return Collections.unmodifiableSet(this.getHbmUsedProjects());
    }

    @Override
    @Transient
    public Locale getDefaultLanguage() {
        return LocaleUtils.toLocale((String)this.getHbmDefaultLanguage());
    }

    @Override
    public void setDefaultLanguage(Locale defaultLanguage) {
        Validate.notNull((Object)defaultLanguage);
        this.setHbmDefaultLanguage(defaultLanguage.toString());
    }

    @Basic
    @Column(name="DEFAULT_LANGUAGE")
    private String getHbmDefaultLanguage() {
        return this.m_defaultLanguage;
    }

    private void setHbmDefaultLanguage(String defaultLanguage) {
        this.m_defaultLanguage = defaultLanguage;
    }

    @Override
    public void setIsReusable(boolean isReusable) {
        this.m_isReusable = isReusable;
    }

    @Override
    public void setIsProtected(boolean isProtected) {
        this.m_isProtected = isProtected;
    }

    @Override
    public void setToolkit(String toolkit) {
        this.setHbmToolkit(toolkit);
    }

    @Basic
    @Column(name="TOOLKIT")
    private String getHbmToolkit() {
        return this.m_toolkit;
    }

    private void setHbmToolkit(String toolkit) {
        this.m_toolkit = toolkit;
    }

    @Override
    @Basic
    @Column(name="MAJOR_NUMBER")
    public Integer getMajorNumber() {
        return this.m_majorNumber;
    }

    @Override
    @Basic
    @Column(name="MINOR_NUMBER")
    public Integer getMinorNumber() {
        return this.m_minorNumber;
    }

    private void setMajorNumber(Integer majorNumber) {
        this.m_majorNumber = majorNumber;
    }

    private void setMinorNumber(Integer minorNumber) {
        this.m_minorNumber = minorNumber;
    }

    @Override
    public void clearUsedProjects() {
        this.getHbmUsedProjects().clear();
    }

    @Override
    @Basic
    @Column(name="TRD_CLEANUP_INTERVAL")
    public Integer getTestResultCleanupInterval() {
        return this.m_testResultCleanupInterval;
    }

    @Override
    public void setTestResultCleanupInterval(Integer noOfDays) {
        this.m_testResultCleanupInterval = noOfDays;
    }

    @Override
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=CheckConfContPO.class)
    @JoinColumn(name="CHECK_CONF_CONT", unique=true)
    public ICheckConfContPO getCheckConfCont() {
        return this.m_checkConfCont;
    }

    public void setCheckConfCont(ICheckConfContPO checkConfCont) {
        this.m_checkConfCont = checkConfCont;
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ProjectPropertiesPO();
    }

    public Object _persistence_get(String string) {
        if (string == "projectLanguageList") {
            return this.projectLanguageList;
        }
        if (string == "isReusable") {
            return this.isReusable;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "hbmUsedProjects") {
            return this.hbmUsedProjects;
        }
        if (string == "hbmToolkit") {
            return this.hbmToolkit;
        }
        if (string == "hbmDefaultLanguage") {
            return this.hbmDefaultLanguage;
        }
        if (string == "minorNumber") {
            return this.minorNumber;
        }
        if (string == "testResultCleanupInterval") {
            return this.testResultCleanupInterval;
        }
        if (string == "majorNumber") {
            return this.majorNumber;
        }
        if (string == "checkConfCont") {
            return this.checkConfCont;
        }
        if (string == "isProtected") {
            return this.isProtected;
        }
        if (string == "version") {
            return this.version;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "projectLanguageList") {
            this.projectLanguageList = (Set)object;
            return;
        }
        if (string == "isReusable") {
            this.isReusable = (Boolean)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "hbmUsedProjects") {
            this.hbmUsedProjects = (Set)object;
            return;
        }
        if (string == "hbmToolkit") {
            this.hbmToolkit = (String)object;
            return;
        }
        if (string == "hbmDefaultLanguage") {
            this.hbmDefaultLanguage = (String)object;
            return;
        }
        if (string == "minorNumber") {
            this.minorNumber = (Integer)object;
            return;
        }
        if (string == "testResultCleanupInterval") {
            this.testResultCleanupInterval = (Integer)object;
            return;
        }
        if (string == "majorNumber") {
            this.majorNumber = (Integer)object;
            return;
        }
        if (string == "checkConfCont") {
            this.checkConfCont = (ICheckConfContPO)object;
            return;
        }
        if (string == "isProtected") {
            this.isProtected = (Boolean)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }
}

