/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Transient;
import org.eclipse.jubula.client.core.model.AUTConfigPO;
import org.eclipse.jubula.client.core.model.AUTMainPO;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodePO;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@DiscriminatorValue(value="T")
class TestSuitePO
extends NodePO
implements ITestSuitePO,
PersistenceWeaved,
PersistenceObject,
PersistenceWeavedRest {
    private transient boolean m_isEditable = true;
    private int m_stepDelay;
    private IAUTMainPO m_aut;
    private String m_cmdLineParameter;
    private IAUTConfigPO m_autConfig;
    private transient boolean m_isStarted = false;
    private Map<String, Integer> m_defaultEventHandler = new HashMap<String, Integer>(4);
    static final long serialVersionUID = 2256566978297804166L;

    TestSuitePO() {
    }

    TestSuitePO(String testSuiteName, boolean isGenerated) {
        super(testSuiteName, isGenerated);
        this.init();
    }

    TestSuitePO(String testSuiteName, String guid, boolean isGenerated) {
        super(testSuiteName, guid, isGenerated);
        this.init();
    }

    private void init() {
        Map map = ComponentBuilder.getInstance().getCompSystem().getEventTypes();
        Set mapKeySet = map.keySet();
        for (Object object : mapKeySet) {
            String key = (String)object;
            this.getDefaultEventHandler().put(key, (Integer)map.get(key));
        }
    }

    @Override
    @Basic
    public int getStepDelay() {
        return this.m_stepDelay;
    }

    @Override
    public void setStepDelay(int stepDelay) {
        this.m_stepDelay = stepDelay;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER, targetEntity=AUTMainPO.class)
    @JoinColumn(name="AUT")
    @BatchFetch(value=BatchFetchType.JOIN)
    public IAUTMainPO getAut() {
        return this.m_aut;
    }

    @Override
    public void setAut(IAUTMainPO aut) {
        this.m_aut = aut;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestSuitePO) && !(obj instanceof ITestSuitePO)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    @Transient
    public boolean isStarted() {
        return this.m_isStarted;
    }

    @Override
    public void setStarted(boolean isStarted) {
        this.m_isStarted = isStarted;
    }

    @Override
    @Basic
    @Column(name="CMD_LINE_PAR")
    public String getCmdLineParameter() {
        return this.m_cmdLineParameter;
    }

    @Override
    public void setCmdLineParameter(String cmdLineParameter) {
        this.m_cmdLineParameter = cmdLineParameter;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER, targetEntity=AUTConfigPO.class)
    @JoinColumn(name="AUTCONF")
    @BatchFetch(value=BatchFetchType.JOIN)
    public IAUTConfigPO getAutConfig() {
        return this.m_autConfig;
    }

    @Override
    public void setAutConfig(IAUTConfigPO autConf) {
        this.m_autConfig = autConf;
    }

    @Override
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="DEF_EVENTH")
    @MapKeyColumn(name="EVENT_TYPE")
    @Column(name="REENTRY")
    public Map<String, Integer> getDefaultEventHandler() {
        return this.m_defaultEventHandler;
    }

    @Override
    public void setDefaultEventHandler(Map<String, Integer> defaultEventHandler) {
        if (defaultEventHandler != null) {
            this.m_defaultEventHandler = defaultEventHandler;
        }
    }

    @Override
    @Transient
    public boolean isEditable() {
        return this.m_isEditable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.m_isEditable = editable;
    }

    public int compareTo(Object o) {
        ITestSuitePO ts = (ITestSuitePO)o;
        return this.getName().compareTo(ts.getName());
    }

    @Transient
    public Boolean isReused() {
        return true;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TestSuitePO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "stepDelay") {
            return this.stepDelay;
        }
        if (string == "cmdLineParameter") {
            return this.cmdLineParameter;
        }
        if (string == "autConfig") {
            return this.autConfig;
        }
        if (string == "defaultEventHandler") {
            return this.defaultEventHandler;
        }
        if (string == "aut") {
            return this.aut;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "stepDelay") {
            this.stepDelay = (Integer)object;
            return;
        }
        if (string == "cmdLineParameter") {
            this.cmdLineParameter = (String)object;
            return;
        }
        if (string == "autConfig") {
            this.autConfig = (IAUTConfigPO)object;
            return;
        }
        if (string == "defaultEventHandler") {
            this.defaultEventHandler = (Map)object;
            return;
        }
        if (string == "aut") {
            this.aut = (IAUTMainPO)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

