/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.search.refactor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.ui.rcp.handlers.project.RefreshProjectHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.pages.ChooseTestCasePage;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageInfo;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchReplaceTCRWizard
extends Wizard {
    private static final String CHOOSE_PAGE_ID = "ReplaceTCRWizard.ChoosePageId";
    private final Set<IExecTestCasePO> m_setOfExecsToReplace;
    private ChooseTestCasePage m_choosePage;
    private ISpecTestCasePO m_newSpec;

    public SearchReplaceTCRWizard(Set<IExecTestCasePO> execsToReplace) {
        this.m_setOfExecsToReplace = execsToReplace;
    }

    public boolean performFinish() {
        this.m_newSpec = this.m_choosePage.getChoosenTestCase();
        EntityManager session = GeneralStorage.getInstance().getMasterSession();
        try {
            Persistor.instance().lockPOSet(session, this.m_setOfExecsToReplace);
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new ReplaceTestCaseOperation());
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new RefreshProjectHandler.RefreshProjectOperation());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (JBException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
        }
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    public void addPages() {
        super.addPages();
        HashSet<INodePO> specSet = new HashSet<INodePO>();
        for (IExecTestCasePO exec : this.m_setOfExecsToReplace) {
            if (!ISpecTestCasePO.class.isAssignableFrom(exec.getParentNode().getClass())) continue;
            specSet.add(exec.getParentNode());
        }
        this.m_choosePage = new ChooseTestCasePage(specSet, CHOOSE_PAGE_ID);
        this.addPage((IWizardPage)this.m_choosePage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof ChooseTestCasePage) {
            this.m_newSpec = this.m_choosePage.getChoosenTestCase();
        }
        return super.getNextPage(page);
    }

    private class ReplaceTestCaseOperation
    implements IRunnableWithProgress {
        private ReplaceTestCaseOperation() {
        }

        public void run(IProgressMonitor monitor) {
            block7: {
                monitor.beginTask(Messages.ReplaceTestCasesActionDialog, -1);
                EntityManager session = GeneralStorage.getInstance().getMasterSession();
                try {
                    try {
                        Persistor.instance().lockPOSet(session, SearchReplaceTCRWizard.this.m_setOfExecsToReplace);
                        ArrayList<MultipleNodePM.UpdateTestCaseRefHandle> commands = new ArrayList<MultipleNodePM.UpdateTestCaseRefHandle>();
                        for (IExecTestCasePO exec : SearchReplaceTCRWizard.this.m_setOfExecsToReplace) {
                            commands.add(new MultipleNodePM.UpdateTestCaseRefHandle(exec, SearchReplaceTCRWizard.this.m_newSpec));
                        }
                        MessageInfo errorMessageInfo = MultipleNodePM.getInstance().executeCommands(commands, session);
                        if (errorMessageInfo != null) {
                            ErrorHandlingUtil.createMessageDialog((Integer)errorMessageInfo.getMessageId(), (Object[])errorMessageInfo.getParams(), null);
                        }
                    }
                    catch (JBException e) {
                        ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                        LockManager.instance().unlockPOs(session);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    LockManager.instance().unlockPOs(session);
                    throw throwable;
                }
                LockManager.instance().unlockPOs(session);
            }
            monitor.done();
        }
    }
}

