/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.adaptable;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.jubula.rc.common.adaptable.IAdapterFactory;
import org.eclipse.jubula.rc.common.classloader.DefaultUrlLocator;
import org.eclipse.jubula.rc.common.classloader.IUrlLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterFactoryRegistry {
    private static final String ADAPTER_PACKAGE_NAME = "org.eclipse.jubula.rc.common.adapter";
    private static Logger log;
    private static AdapterFactoryRegistry instance;
    private Map m_registrationMap = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        instance = new AdapterFactoryRegistry();
    }

    private AdapterFactoryRegistry() {
    }

    public static AdapterFactoryRegistry getInstance() {
        return instance;
    }

    public void registerFactory(IAdapterFactory factory) {
        Class[] supportedClasses = factory.getSupportedClasses();
        int i = 0;
        while (i < supportedClasses.length) {
            ArrayList<IAdapterFactory> registeredFactories = (ArrayList<IAdapterFactory>)this.m_registrationMap.get(supportedClasses[i]);
            if (registeredFactories == null) {
                registeredFactories = new ArrayList<IAdapterFactory>();
            }
            registeredFactories.add(factory);
            this.m_registrationMap.put(supportedClasses[i], registeredFactories);
            ++i;
        }
    }

    public void signOffFactory(IAdapterFactory factory) {
        Class[] supportedClasses = factory.getSupportedClasses();
        int i = 0;
        while (i < supportedClasses.length) {
            Class supportedClass = supportedClasses[i];
            Collection registeredFactories = (Collection)this.m_registrationMap.get(supportedClass);
            if (registeredFactories == null) {
                return;
            }
            registeredFactories.remove(factory);
            this.m_registrationMap.remove(supportedClass);
            ++i;
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getAdapter(Class targetAdapterClass, Object objectToAdapt) {
        Class<?> clazz;
        Collection registeredFactories = null;
        Class<?> superClass = objectToAdapt.getClass();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                registeredFactories = (Collection)this.m_registrationMap.get(superClass);
                superClass = superClass.getSuperclass();
            }
            if (registeredFactories != null) break;
            clazz = class$1;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (superClass != clazz);
        if (registeredFactories == null) {
            return null;
        }
        Iterator iterator = registeredFactories.iterator();
        while (iterator.hasNext()) {
            IAdapterFactory adapterFactory = (IAdapterFactory)iterator.next();
            Object object = adapterFactory.getAdapter(targetAdapterClass, objectToAdapt);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static void initRegistration(IUrlLocator urlLocator) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jubula.rc.common.adaptable.IAdapterFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class[] adapterFactories = AdapterFactoryRegistry.findClassesOfType(urlLocator, ADAPTER_PACKAGE_NAME, clazz);
        int i = 0;
        while (i < adapterFactories.length) {
            try {
                IAdapterFactory factory = (IAdapterFactory)adapterFactories[i].newInstance();
                AdapterFactoryRegistry.getInstance().registerFactory(factory);
            }
            catch (IllegalAccessException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
            ++i;
        }
    }

    public static void initRegistration() {
        AdapterFactoryRegistry.initRegistration(new DefaultUrlLocator());
    }

    private static Class[] findClassesOfType(IUrlLocator urlLocator, String packageName, Class superclass) {
        try {
            Class[] allClasses = AdapterFactoryRegistry.getClasses(urlLocator, packageName);
            ArrayList<Class> assignableClasses = new ArrayList<Class>();
            int i = 0;
            while (i < allClasses.length) {
                if (superclass.isAssignableFrom(allClasses[i]) && superclass != allClasses[i]) {
                    assignableClasses.add(allClasses[i]);
                }
                ++i;
            }
            return AdapterFactoryRegistry.castListToClassArray(assignableClasses);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Class[0];
        }
        catch (IOException iOException) {
            return new Class[0];
        }
    }

    private static Class[] castListToClassArray(List classes) {
        Class[] arrayClasses = new Class[classes.size()];
        int i = 0;
        while (i < arrayClasses.length) {
            arrayClasses[i] = (Class)classes.get(i);
            ++i;
        }
        return arrayClasses;
    }

    private static Class[] getClasses(IUrlLocator urlLocator, String packageName) throws ClassNotFoundException, IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<URL> dirs = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            try {
                resource = urlLocator.convertUrl(resource);
                dirs.add(resource);
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        ArrayList classes = new ArrayList();
        int i = 0;
        while (i < dirs.size()) {
            if (dirs.get(i).toString().startsWith("jar:")) {
                classes.addAll(AdapterFactoryRegistry.findClassesInJar((URL)dirs.get(i), packageName));
            } else {
                classes.addAll(AdapterFactoryRegistry.findClasses((URL)dirs.get(i), packageName));
            }
            ++i;
        }
        return AdapterFactoryRegistry.castListToClassArray(classes);
    }

    private static List findClasses(URL directoryUrl, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        File directory = new File(directoryUrl.getFile());
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String fileName = file.getName();
            if (file.isDirectory()) {
                try {
                    classes.addAll(AdapterFactoryRegistry.findClasses(file.toURI().toURL(), String.valueOf(packageName) + '.' + fileName));
                }
                catch (MalformedURLException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                }
            } else if (fileName.endsWith(".class")) {
                classes.add(Class.forName(String.valueOf(packageName) + '.' + fileName.substring(0, fileName.length() - 6)));
            }
            ++i;
        }
        return classes;
    }

    private static List findClassesInJar(URL resource, String pkgname) {
        String relPath = pkgname.replace('.', '/');
        String path = resource.getPath().replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
        ArrayList classes = new ArrayList();
        try {
            JarFile jarFile = new JarFile(path);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                String className = null;
                if (!entryName.endsWith(".class") || !entryName.startsWith(relPath) || (className = entryName.replace('/', '.').replace('\\', '.').replaceAll(".class", "")) == null) continue;
                try {
                    classes.add(Class.forName(className));
                }
                catch (ClassNotFoundException cnfe) {
                    log.error(cnfe.getLocalizedMessage(), (Throwable)cnfe);
                }
            }
        }
        catch (IOException ioe) {
            log.warn(ioe.getLocalizedMessage(), (Throwable)ioe);
        }
        return classes;
    }
}

