/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.components;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.components.AUTComponent;
import org.eclipse.jubula.rc.common.components.HierarchyContainer;
import org.eclipse.jubula.rc.common.components.IComponentFactory;
import org.eclipse.jubula.rc.common.exception.UnsupportedComponentException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.interfaces.ITester;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;

public abstract class AUTHierarchy {
    private static final AutServerLogger LOG;
    private volatile Map m_hierarchyMap = new Hashtable(1000);
    private volatile Map m_realHierarchyMap = new Hashtable(1000);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.common.components.AUTHierarchy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = new AutServerLogger(clazz);
    }

    public Map getHierarchyMap() {
        return this.m_hierarchyMap;
    }

    protected Map getRealMap() {
        return this.m_realHierarchyMap;
    }

    protected void addToHierachyMap(HierarchyContainer hierarchyContainer) {
        AUTComponent autComponent = hierarchyContainer.getCompID();
        Object realComponent = autComponent.getComp();
        this.m_hierarchyMap.put(autComponent, hierarchyContainer);
        this.m_realHierarchyMap.put(realComponent, autComponent);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add to HierarchyMap: " + String.valueOf(autComponent));
            LOG.debug("HierarchyMap size: " + this.m_hierarchyMap.size());
            LOG.debug("Add to RealHierarchyMap: " + String.valueOf(realComponent));
            LOG.debug("RealHierarchyMap size: " + this.m_realHierarchyMap.size());
        }
    }

    protected void removeFromHierachyMap(HierarchyContainer hierarchyContainer) {
        AUTComponent autComponent = hierarchyContainer.getCompID();
        Object realComponent = autComponent.getComp();
        this.m_hierarchyMap.remove(autComponent);
        this.m_realHierarchyMap.remove(realComponent);
    }

    public abstract void addToHierarchy(IComponentFactory var1, String var2, String var3) throws UnsupportedComponentException;

    public abstract IComponentIdentifier[] getAllComponentId();

    protected String createName(Object component, int postFix) {
        return String.valueOf(component.getClass().getName()) + "_" + postFix;
    }

    protected String createName(String componentName, int postFix) {
        return String.valueOf(componentName) + "_" + postFix;
    }

    protected Collection getHierarchyValues() {
        return this.m_hierarchyMap.values();
    }

    protected abstract List getComponentContext(Object var1);

    protected final void setAlternativeDisplayName(HierarchyContainer container, Object component, IComponentIdentifier identifier) {
        String displayName;
        if (container != null && (displayName = this.buildDisplayName(container, component)) != null && !displayName.equals(identifier.getComponentName())) {
            identifier.setAlternativeDisplayName(displayName);
        }
    }

    private final String buildDisplayName(HierarchyContainer container, Object component) {
        String containerName = container.getName();
        boolean containerNameGenerated = container.isNameGenerated();
        String[] componentTextArray = this.getTextArrayFromComponent(component);
        String improvedName = this.buildImprovedName(componentTextArray);
        if (containerNameGenerated) {
            containerName = AUTServerConfiguration.getInstance().getGDComponentName(component);
        }
        String displayName = this.combineNames(containerName, containerNameGenerated, improvedName);
        return displayName;
    }

    private String[] getTextArrayFromComponent(Object component) {
        String[] componentTextArray = null;
        if (component != null) {
            try {
                Object implClass = AUTServerConfiguration.getInstance().prepareImplementationClass(component, component.getClass());
                if (implClass instanceof ITester) {
                    ITester baseImpl = (ITester)implClass;
                    componentTextArray = baseImpl.getTextArrayFromComponent();
                }
            }
            catch (UnsupportedComponentException uce) {
                LOG.warn((Object)uce);
            }
            catch (IllegalArgumentException iae) {
                LOG.error(iae);
            }
        }
        return componentTextArray;
    }

    private String buildImprovedName(String[] componentTextArray) {
        String improvedName;
        if (componentTextArray == null || componentTextArray.length == 0 || componentTextArray.length == 1 && (componentTextArray[0] == null || componentTextArray[0].length() == 0)) {
            improvedName = null;
        } else {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < componentTextArray.length) {
                if (i > 0) {
                    buffer.append(",");
                    if (i == 3) {
                        buffer.append("...");
                        break;
                    }
                }
                buffer.append("\"");
                if (componentTextArray[i] != null) {
                    buffer.append(String.valueOf(componentTextArray[i]).trim());
                }
                buffer.append("\"");
                ++i;
            }
            improvedName = buffer.toString();
        }
        return improvedName;
    }

    private String combineNames(String containerName, boolean containerNameGenerated, String improvedName) {
        String displayName = improvedName == null ? containerName : String.valueOf(containerName) + " (" + improvedName + ")";
        if (displayName != null && displayName.length() > 200) {
            displayName = String.valueOf(displayName.substring(0, 199)) + "...";
            if (improvedName != null) {
                displayName = String.valueOf(displayName) + ")";
            }
        }
        return displayName;
    }
}

