/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.CellRangeAddressList;
import org.apache.poi.util.LittleEndian;

public final class MergeCellsRecord
extends Record {
    public static final short sid = 229;
    private CellRangeAddress[] _regions;
    private final int _startIndex;
    private final int _numberOfRegions;

    public MergeCellsRecord(CellRangeAddress[] regions, int startIndex, int numberOfRegions) {
        this._regions = regions;
        this._startIndex = startIndex;
        this._numberOfRegions = numberOfRegions;
    }

    public MergeCellsRecord(RecordInputStream in) {
        int nRegions = in.readUShort();
        CellRangeAddress[] cras = new CellRangeAddress[nRegions];
        int i = 0;
        while (i < nRegions) {
            cras[i] = new CellRangeAddress(in);
            ++i;
        }
        this._numberOfRegions = nRegions;
        this._startIndex = 0;
        this._regions = cras;
    }

    public short getNumAreas() {
        return (short)this._numberOfRegions;
    }

    public CellRangeAddress getAreaAt(int index) {
        return this._regions[this._startIndex + index];
    }

    public int getRecordSize() {
        return 4 + CellRangeAddressList.getEncodedSize(this._numberOfRegions);
    }

    public short getSid() {
        return 229;
    }

    public int serialize(int offset, byte[] data) {
        int dataSize = CellRangeAddressList.getEncodedSize(this._numberOfRegions);
        LittleEndian.putUShort(data, offset + 0, 229);
        LittleEndian.putUShort(data, offset + 2, dataSize);
        int nItems = this._numberOfRegions;
        LittleEndian.putUShort(data, offset + 4, nItems);
        int pos = 6;
        int i = 0;
        while (i < this._numberOfRegions) {
            pos += this._regions[this._startIndex + i].serialize(offset + pos, data);
            ++i;
        }
        return 4 + dataSize;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append("[MERGEDCELLS]").append("\n");
        retval.append("     .numregions =").append(this.getNumAreas()).append("\n");
        int k = 0;
        while (k < this._numberOfRegions) {
            CellRangeAddress region = this._regions[this._startIndex + k];
            retval.append("     .rowfrom    =").append(region.getFirstRow()).append("\n");
            retval.append("     .rowto      =").append(region.getLastRow()).append("\n");
            retval.append("     .colfrom    =").append(region.getFirstColumn()).append("\n");
            retval.append("     .colto      =").append(region.getLastColumn()).append("\n");
            ++k;
        }
        retval.append("[MERGEDCELLS]").append("\n");
        return retval.toString();
    }

    public Object clone() {
        int nRegions = this._numberOfRegions;
        CellRangeAddress[] clonedRegions = new CellRangeAddress[nRegions];
        int i = 0;
        while (i < clonedRegions.length) {
            clonedRegions[i] = this._regions[this._startIndex + i].copy();
            ++i;
        }
        return new MergeCellsRecord(clonedRegions, 0, nRegions);
    }
}

