/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.PColor;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public class PaletteRecord
extends Record {
    public static final short sid = 146;
    public static final byte STANDARD_PALETTE_SIZE = 56;
    public static final short FIRST_COLOR_INDEX = 8;
    private short field_1_numcolors;
    private List field_2_colors;

    public PaletteRecord() {
        this.createDefaultPalette();
    }

    public PaletteRecord(RecordInputStream in) {
        this.field_1_numcolors = in.readShort();
        this.field_2_colors = new ArrayList(this.field_1_numcolors);
        int k = 0;
        while (k < this.field_1_numcolors) {
            this.field_2_colors.add(new PColor(in.readByte(), in.readByte(), in.readByte()));
            in.readByte();
            ++k;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[PALETTE]\n");
        buffer.append("  numcolors     = ").append(this.field_1_numcolors).append('\n');
        int k = 0;
        while (k < this.field_1_numcolors) {
            PColor c = (PColor)this.field_2_colors.get(k);
            buffer.append("* colornum      = ").append(k).append('\n');
            buffer.append(c.toString());
            buffer.append("/*colornum      = ").append(k).append('\n');
            ++k;
        }
        buffer.append("[/PALETTE]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)146);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.field_1_numcolors);
        int k = 0;
        while (k < this.field_1_numcolors) {
            PColor c = (PColor)this.field_2_colors.get(k);
            c.serialize(data, 6 + offset + k * 4);
            ++k;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 6 + this.field_1_numcolors * 4;
    }

    public short getSid() {
        return 146;
    }

    public byte[] getColor(short byteIndex) {
        int i = byteIndex - 8;
        if (i < 0 || i >= this.field_2_colors.size()) {
            return null;
        }
        PColor color = (PColor)this.field_2_colors.get(i);
        return new byte[]{color.red, color.green, color.blue};
    }

    /*
     * Unable to fully structure code
     */
    public void setColor(short byteIndex, byte red, byte green, byte blue) {
        i = byteIndex - 8;
        if (i >= 0 && i < 56) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            this.field_2_colors.add(new PColor(0, 0, 0));
lbl6:
            // 2 sources

            ** while (this.field_2_colors.size() <= i)
        }
lbl7:
        // 1 sources

        custColor = new PColor(red, green, blue);
        this.field_2_colors.set(i, custColor);
    }

    private void createDefaultPalette() {
        this.field_1_numcolors = (short)56;
        this.field_2_colors = new ArrayList(this.field_1_numcolors);
        byte[] byArray = new byte[224];
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[8] = -1;
        byArray[13] = -1;
        byArray[18] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[24] = -1;
        byArray[26] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[32] = -128;
        byArray[37] = -128;
        byArray[42] = -128;
        byArray[44] = -128;
        byArray[45] = -128;
        byArray[48] = -128;
        byArray[50] = -128;
        byArray[53] = -128;
        byArray[54] = -128;
        byArray[56] = -64;
        byArray[57] = -64;
        byArray[58] = -64;
        byArray[60] = -128;
        byArray[61] = -128;
        byArray[62] = -128;
        byArray[64] = -103;
        byArray[65] = -103;
        byArray[66] = -1;
        byArray[68] = -103;
        byArray[69] = 51;
        byArray[70] = 102;
        byArray[72] = -1;
        byArray[73] = -1;
        byArray[74] = -52;
        byArray[76] = -52;
        byArray[77] = -1;
        byArray[78] = -1;
        byArray[80] = 102;
        byArray[82] = 102;
        byArray[84] = -1;
        byArray[85] = -128;
        byArray[86] = -128;
        byArray[89] = 102;
        byArray[90] = -52;
        byArray[92] = -52;
        byArray[93] = -52;
        byArray[94] = -1;
        byArray[98] = -128;
        byArray[100] = -1;
        byArray[102] = -1;
        byArray[104] = -1;
        byArray[105] = -1;
        byArray[109] = -1;
        byArray[110] = -1;
        byArray[112] = -128;
        byArray[114] = -128;
        byArray[116] = -128;
        byArray[121] = -128;
        byArray[122] = -128;
        byArray[126] = -1;
        byArray[129] = -52;
        byArray[130] = -1;
        byArray[132] = -52;
        byArray[133] = -1;
        byArray[134] = -1;
        byArray[136] = -52;
        byArray[137] = -1;
        byArray[138] = -52;
        byArray[140] = -1;
        byArray[141] = -1;
        byArray[142] = -103;
        byArray[144] = -103;
        byArray[145] = -52;
        byArray[146] = -1;
        byArray[148] = -1;
        byArray[149] = -103;
        byArray[150] = -52;
        byArray[152] = -52;
        byArray[153] = -103;
        byArray[154] = -1;
        byArray[156] = -1;
        byArray[157] = -52;
        byArray[158] = -103;
        byArray[160] = 51;
        byArray[161] = 102;
        byArray[162] = -1;
        byArray[164] = 51;
        byArray[165] = -52;
        byArray[166] = -52;
        byArray[168] = -103;
        byArray[169] = -52;
        byArray[172] = -1;
        byArray[173] = -52;
        byArray[176] = -1;
        byArray[177] = -103;
        byArray[180] = -1;
        byArray[181] = 102;
        byArray[184] = 102;
        byArray[185] = 102;
        byArray[186] = -103;
        byArray[188] = -106;
        byArray[189] = -106;
        byArray[190] = -106;
        byArray[193] = 51;
        byArray[194] = 102;
        byArray[196] = 51;
        byArray[197] = -103;
        byArray[198] = 102;
        byArray[201] = 51;
        byArray[204] = 51;
        byArray[205] = 51;
        byArray[208] = -103;
        byArray[209] = 51;
        byArray[212] = -103;
        byArray[213] = 51;
        byArray[214] = 102;
        byArray[216] = 51;
        byArray[217] = 51;
        byArray[218] = -103;
        byArray[220] = 51;
        byArray[221] = 51;
        byArray[222] = 51;
        byte[] palette = byArray;
        int k = 0;
        while (k < this.field_1_numcolors) {
            this.field_2_colors.add(new PColor(palette[k * 4], palette[k * 4 + 1], palette[k * 4 + 2]));
            ++k;
        }
    }
}

