/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.communication;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jubula.client.core.AutAgentEvent;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.communication.BaseConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.communication.Communicator;
import org.eclipse.jubula.communication.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutAgentConnection
extends BaseConnection {
    public static final Object CONNECT_TO_AGENT_JOB_FAMILY_ID = new Object();
    private static Logger log = LoggerFactory.getLogger(AutAgentConnection.class);
    private static AutAgentConnection instance = null;

    private AutAgentConnection(InetAddress inetAddress, int port) {
        Communicator communicator = new Communicator(inetAddress, port, this.getClass().getClassLoader());
        this.setCommunicator(communicator);
    }

    protected synchronized void setCommunicator(Communicator communicator) {
        super.setCommunicator(communicator);
        communicator.addCommunicationErrorListener((ICommunicationErrorListener)new ServerConnectionListener());
    }

    public static synchronized void createInstance(String serverName, String port) throws ConnectionException {
        try {
            InetAddress inetAddress = InetAddress.getByName(serverName);
            instance = new AutAgentConnection(inetAddress, new Integer(port));
        }
        catch (UnknownHostException uhe) {
            log.info(uhe.getLocalizedMessage(), (Throwable)uhe);
            throw new ConnectionException(uhe.getMessage(), MessageIDs.E_UNKNOWN_HOST);
        }
    }

    public static synchronized AutAgentConnection getInstance() throws ConnectionException {
        if (instance == null) {
            String message = Messages.ServerConnectionIsNotInitialized;
            throw new ConnectionException(message, MessageIDs.E_NO_SERVER_CONNECTION_INIT);
        }
        return instance;
    }

    private class ServerConnectionListener
    implements ICommunicationErrorListener {
        private ServerConnectionListener() {
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            if (log.isInfoEnabled()) {
                try {
                    String logMessage = String.valueOf(Messages.ConnectedTo) + " " + inetAddress.getHostName() + ":" + String.valueOf(port);
                    log.info(logMessage);
                }
                catch (SecurityException securityException) {
                    log.debug(Messages.SecurityViolationGettingHostNameFromIP);
                }
            }
            ClientTestFactory.getClientTest().fireAutAgentStateChanged(new AutAgentEvent(1));
        }

        public void shutDown() {
            log.info(Messages.ConnectionToAUTAgentClosed);
            log.info(Messages.ClosingConnectionToTheAUTServer);
            try {
                AUTConnection.getInstance().close();
                ClientTestFactory.getClientTest().fireAutAgentStateChanged(new AutAgentEvent(2));
            }
            catch (ConnectionException ce) {
                log.debug(ce.getLocalizedMessage(), (Throwable)((Object)ce));
            }
        }

        public void sendFailed(Message message) {
            log.warn(String.valueOf(Messages.SendingMessageFailed) + ":" + message.toString());
            log.info(Messages.ClosingConnectionToTheAUTAgent);
            AutAgentConnection.this.close();
        }

        public void acceptingFailed(int port) {
            log.error(String.valueOf(Messages.AcceptingFailedCalledAlthoughThisIsClient) + ":" + String.valueOf(port));
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
            log.warn(Messages.ConnectingTheAUTAgentFailed);
            ClientTestFactory.getClientTest().fireAutAgentStateChanged(new AutAgentEvent(3));
        }
    }
}

