/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;

public class TestDataCubeRefContentProposalProvider
implements IContentProposalProvider {
    private IProjectPO m_project;
    private IParameterInterfacePO m_paramInterface;

    public TestDataCubeRefContentProposalProvider(IProjectPO project, IParameterInterfacePO paramInterface) {
        Validate.notNull((Object)project);
        Validate.notNull((Object)paramInterface);
        this.m_project = project;
        this.m_paramInterface = paramInterface;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<TestDataCubeRefContentProposal> proposalList = new ArrayList<TestDataCubeRefContentProposal>();
        ITestDataCubePO[] iTestDataCubePOArray = TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)this.m_project);
        int n = iTestDataCubePOArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestDataCubePO dataCube = iTestDataCubePOArray[n2];
            if (TestDataCubeRefContentProposalProvider.dataCubeFulfillsNameRequirements((IParameterInterfacePO)dataCube, contents.substring(0, position)) && TestDataCubeRefContentProposalProvider.dataCubeFulfillsParameterRequirements((IParameterInterfacePO)dataCube, this.m_paramInterface)) {
                proposalList.add(new TestDataCubeRefContentProposal((IParameterInterfacePO)dataCube));
            }
            ++n2;
        }
        Collections.sort(proposalList);
        return proposalList.toArray(new TestDataCubeRefContentProposal[proposalList.size()]);
    }

    private static boolean dataCubeFulfillsParameterRequirements(IParameterInterfacePO dataCube, IParameterInterfacePO paramInterface) {
        for (IParamDescriptionPO requiredParameter : paramInterface.getParameterList()) {
            IParamDescriptionPO matchingParameter = dataCube.getParameterForName(requiredParameter.getName());
            if (matchingParameter != null && matchingParameter.getType().equals(requiredParameter.getType())) continue;
            return false;
        }
        return true;
    }

    private static boolean dataCubeFulfillsNameRequirements(IParameterInterfacePO dataCube, String prefixToMatch) {
        return StringUtils.startsWithIgnoreCase((String)dataCube.getName(), (String)prefixToMatch);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestDataCubeRefContentProposal
    implements IContentProposal,
    Comparable<TestDataCubeRefContentProposal> {
        private IParameterInterfacePO m_dataCube;

        public TestDataCubeRefContentProposal(IParameterInterfacePO dataCube) {
            Validate.notNull((Object)dataCube);
            this.m_dataCube = dataCube;
        }

        public String getContent() {
            return this.m_dataCube.getName();
        }

        public int getCursorPosition() {
            return this.m_dataCube.getName().length();
        }

        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            for (IParamDescriptionPO param : this.m_dataCube.getParameterList()) {
                sb.append(param.getName());
                sb.append("\t");
                sb.append("-");
                sb.append("\t");
                sb.append(CompSystemI18n.getString((String)param.getType()));
                sb.append("\n");
            }
            return sb.length() > 0 ? sb.toString() : null;
        }

        public String getLabel() {
            return null;
        }

        @Override
        public int compareTo(TestDataCubeRefContentProposal otherProposal) {
            if (otherProposal == null) {
                return -1;
            }
            if (this.getContent() == null) {
                return otherProposal.getContent() == null ? 0 : -1;
            }
            return this.getContent().compareTo(otherProposal.getContent());
        }
    }
}

