/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser;

public class TJEditorDndSupport {
    private TJEditorDndSupport() {
    }

    public static boolean performDrop(TestJobEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget, int dropPosition) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        List selectedElements = toDrop.toList();
        Collections.reverse(selectedElements);
        for (Object objectToDrop : selectedElements) {
            INodePO target;
            ITestSuitePO testSuite;
            if (objectToDrop instanceof ITestSuitePO && dropTarget != (testSuite = (ITestSuitePO)objectToDrop)) {
                try {
                    if (dropTarget instanceof IRefTestSuitePO) {
                        TJEditorDndSupport.dropOnRefTS(testSuite, dropTarget, dropPosition);
                    } else if (dropTarget instanceof ITestJobPO) {
                        TJEditorDndSupport.dropOnTJ(testSuite, dropTarget);
                    }
                }
                catch (PMException e) {
                    NodeEditorInput inp = (NodeEditorInput)targetEditor.getAdapter(NodeEditorInput.class);
                    INodePO inpNode = inp.getNode();
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                    if (!(e instanceof PMAlreadyLockedException) || ((PMAlreadyLockedException)((Object)e)).getLockedObject() == null || ((PMAlreadyLockedException)((Object)e)).getLockedObject().equals(inpNode) || !targetEditor.isDirty()) {
                        try {
                            targetEditor.reOpenEditor((IPersistentObject)inpNode);
                        }
                        catch (PMException pMException) {
                            PMExceptionHandler.handlePMExceptionForEditor(e, targetEditor);
                        }
                    }
                    return false;
                }
            }
            if (!(objectToDrop instanceof INodePO)) continue;
            INodePO nodeToDrop = (INodePO)objectToDrop;
            if (nodeToDrop instanceof IRefTestSuitePO && (target = dropTarget) != nodeToDrop && target instanceof IRefTestSuitePO) {
                TJEditorDndSupport.moveNode(nodeToDrop, target);
            }
            TJEditorDndSupport.postDropAction(nodeToDrop, targetEditor);
        }
        return true;
    }

    public static boolean validateDrop(Viewer sourceViewer, Viewer targetViewer, IStructuredSelection toDrop, INodePO dropTarget, boolean allowFromBrowser) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null) {
            return false;
        }
        if (sourceViewer != null && !sourceViewer.equals(targetViewer)) {
            TestSuiteBrowser tsb = TestSuiteBrowser.getInstance();
            if (tsb != null) {
                if (!allowFromBrowser || !sourceViewer.equals(tsb.getTreeViewer())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        Object[] objectArray = toDrop.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object toDropElement = objectArray[n2];
            if (!(toDropElement instanceof ITestSuitePO) && !(toDropElement instanceof IRefTestSuitePO)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static void dropOnTJ(ITestSuitePO node, INodePO target) throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException {
        TestSuiteBrowser tsb = TestSuiteBrowser.getInstance();
        if (tsb != null) {
            tsb.addReferencedTestSuite(node, target, 0);
        }
    }

    private static void dropOnRefTS(ITestSuitePO node, INodePO target, int location) throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException {
        TestSuiteBrowser tsb;
        INodePO parentGUI = target.getParentNode();
        int position = parentGUI.indexOf(target);
        if (location != 1) {
            ++position;
        }
        if ((tsb = TestSuiteBrowser.getInstance()) != null) {
            tsb.addReferencedTestSuite(node, parentGUI, position);
        }
    }

    private static INodePO moveNode(INodePO node, INodePO target) {
        int newPos = target.getParentNode().indexOf(target);
        node.getParentNode().removeNode(node);
        target.getParentNode().addNode(newPos, node);
        return node;
    }

    private static void postDropAction(INodePO node, TestJobEditor targetEditor) {
        targetEditor.setFocus();
        if (node != null) {
            targetEditor.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node));
        }
        targetEditor.getTreeViewer().refresh();
        targetEditor.getEditorHelper().setDirty(true);
        LocalSelectionTransfer.getInstance().setSelection(null);
    }
}

