/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.SearchReplaceTCRWizard;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchReplaceTestCaseHandler
extends AbstractSelectionBasedHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object executeImpl(ExecutionEvent event) {
        IStructuredSelection selectedObject = this.getSelection();
        List selectionList = selectedObject.toList();
        LinkedHashSet<IExecTestCasePO> execList = new LinkedHashSet<IExecTestCasePO>();
        EntityManager session = GeneralStorage.getInstance().getMasterSession();
        ISpecTestCasePO firstSpec = null;
        try {
            for (Object object : selectionList) {
                BasicSearchResult.SearchResultElement searchResult = (BasicSearchResult.SearchResultElement)object;
                INodePO nodePO = (INodePO)session.find(NodeMaker.getNodePOClass(), searchResult.getData());
                IExecTestCasePO exec = (IExecTestCasePO)nodePO;
                execList.add(exec);
                ISpecTestCasePO spec = exec.getSpecTestCase();
                if (firstSpec == null) {
                    firstSpec = spec;
                }
                if (firstSpec.equals((Object)spec)) continue;
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NOT_SAME_SPEC);
                return null;
            }
        }
        catch (Exception exception) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NO_EXEC);
            return null;
        }
        if (Plugin.getDefault().anyDirtyStar()) {
            if (!Plugin.getDefault().showSaveEditorDialog()) return null;
            if (Plugin.getDefault().anyDirtyStar()) return null;
            this.showWizardDialog(execList);
            return null;
        }
        this.showWizardDialog(execList);
        return null;
    }

    private void showWizardDialog(Set<IExecTestCasePO> execList) {
        WizardDialog dialog = new WizardDialog(this.getActiveShell(), (IWizard)new SearchReplaceTCRWizard(execList)){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                DialogUtils.adjustShellSizeRelativeToClientSize((Shell)newShell, (float)0.6f, (float)0.6f, (DialogUtils.SizeType)DialogUtils.SizeType.SIZE);
            }
        };
        dialog.setHelpAvailable(true);
        dialog.open();
    }
}

