/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.rename;

import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.RenameTestDataManagerDialog;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AddNewTestDataManagerHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.rename.AbstractRenameTreeItemHandler;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameTestDataCubeInEditorHandler
extends AbstractRenameTreeItemHandler {
    public Object executeImpl(final ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof CentralTestDataEditor) {
            final CentralTestDataEditor editor = (CentralTestDataEditor)activePart;
            editor.getEditorHelper().doEditorOperation(new IEditorOperation(){

                public void run(IPersistentObject workingPo) {
                    ITestDataCubePO tdc;
                    String newName;
                    IStructuredSelection structuredSelection = RenameTestDataCubeInEditorHandler.this.getSelection();
                    Object firstElement = structuredSelection.getFirstElement();
                    if (firstElement instanceof ITestDataCubePO && (newName = RenameTestDataCubeInEditorHandler.this.getNewTestDataCubeName(tdc = (ITestDataCubePO)firstElement, editor, event)) != null) {
                        tdc.setName(newName);
                        editor.getEditorHelper().setDirty(true);
                        DataEventDispatcher ded = DataEventDispatcher.getInstance();
                        ded.fireDataChangedListener((IPersistentObject)tdc, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.onlyInEditor);
                        ded.fireParamChangedListener();
                        ded.firePropertyChanged(false);
                    }
                }
            });
        }
        return null;
    }

    private String getNewTestDataCubeName(ITestDataCubePO tdc, CentralTestDataEditor editor, ExecutionEvent event) {
        return this.openDialog(tdc.getName(), HandlerUtil.getActiveShell((ExecutionEvent)event), AddNewTestDataManagerHandler.getSetOfUsedNames(editor));
    }

    private String openDialog(String initialName, Shell activeShell, Set<String> setOfUsedNames) {
        RenameTestDataManagerDialog newNameDialog = new RenameTestDataManagerDialog(initialName, activeShell, setOfUsedNames);
        newNameDialog.setHelpAvailable(true);
        newNameDialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)newNameDialog);
        Plugin.getHelpSystem().setHelp((Control)newNameDialog.getShell(), "org.eclipse.jubula.client.ua.help.newTestDataCubeNameContextId");
        if (newNameDialog.open() == 0) {
            return newNameDialog.getName();
        }
        return null;
    }
}

