/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractShowWhereUsedQuery;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.jubula.tools.exception.JBException;

public class ShowWhereUsedSpecTcQuery
extends AbstractShowWhereUsedQuery {
    private ISpecTestCasePO m_specTC;

    public ShowWhereUsedSpecTcQuery(ISpecTestCasePO specTC) {
        super(null);
        this.m_specTC = specTC;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.calculateReuseOfSpecTestCase(this.m_specTC, monitor);
        return Status.OK_STATUS;
    }

    private void calculateReuseOfSpecTestCase(ISpecTestCasePO specTC, IProgressMonitor monitor) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        LinkedList<Long> parentProjectIDs = new LinkedList<Long>();
        parentProjectIDs.add(currentProject.getId());
        for (IReusedProjectPO rp : currentProject.getUsedProjects()) {
            try {
                Long projID = ProjectPM.findProjectId((String)rp.getProjectGuid(), (Integer)rp.getMajorNumber(), (Integer)rp.getMinorNumber());
                if (projID == null) continue;
                parentProjectIDs.add(projID);
            }
            catch (JBException jBException) {}
        }
        List reuse = NodePM.getExecTestCases((String)specTC.getGuid(), parentProjectIDs);
        ArrayList<BasicSearchResult.SearchResultElement> reuseLoc = new ArrayList<BasicSearchResult.SearchResultElement>(reuse.size());
        ArrayList<INodePO> parentList = new ArrayList<INodePO>();
        monitor.beginTask("Searching for reusage of Test Case", reuse.size());
        for (IExecTestCasePO execTC : reuse) {
            INodePO parent = execTC.getParentNode();
            if (parent != null) {
                Long id = execTC.getId();
                String name = execTC.getName();
                parentList.add(parent);
                String resultName = String.valueOf(parent.getName()) + " " + "/" + " " + name;
                reuseLoc.add(new BasicSearchResult.SearchResultElement<Long>(resultName, id, ShowWhereUsedSpecTcQuery.getImageForNode((IPersistentObject)execTC), new BasicSearchResult.NodeSearchResultElementAction(), execTC.getComment()));
            }
            monitor.worked(1);
        }
        this.setSearchResult(reuseLoc);
        monitor.done();
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTimestamp());
        sb.append(":");
        sb.append(" ");
        sb.append(Messages.UIJobSearchingTestCases);
        sb.append(" \"");
        sb.append(this.m_specTC.getName());
        sb.append("\"");
        return sb.toString();
    }
}

