/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.search.refactor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.MultipleNodePM;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.pages.ChooseTestCasePage;
import org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages.ComponentNameMappingWizardPage;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.messagehandling.MessageInfo;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchReplaceTCRWizard
extends Wizard {
    private static final String CHOOSE_PAGE_ID = "ReplaceTCRWizard.ChoosePageId";
    private static final String COMPONENT_MAPPING_PAGE_ID = "ReplaceTCRWizard.ComponentMappingPageId";
    private final Set<IExecTestCasePO> m_setOfExecsToReplace;
    private List<ICompNamesPairPO> m_listOfNewCompNamePairs;
    private ChooseTestCasePage m_choosePage;
    private ISpecTestCasePO m_newSpec;
    private ComponentNameMappingWizardPage m_componentNamesPage;

    public SearchReplaceTCRWizard(Set<IExecTestCasePO> execsToReplace) {
        this.m_setOfExecsToReplace = execsToReplace;
    }

    public boolean performFinish() {
        this.m_newSpec = this.m_choosePage.getChoosenTestCase();
        this.m_listOfNewCompNamePairs = this.m_componentNamesPage.getCompMatching();
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new ReplaceTestCaseOperation());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    public boolean performCancel() {
        return true;
    }

    public void addPages() {
        super.addPages();
        HashSet<INodePO> specSet = new HashSet<INodePO>();
        for (IExecTestCasePO exec : this.m_setOfExecsToReplace) {
            if (!ISpecTestCasePO.class.isAssignableFrom(exec.getParentNode().getClass())) continue;
            specSet.add(exec.getParentNode());
        }
        this.m_choosePage = new ChooseTestCasePage(specSet, CHOOSE_PAGE_ID);
        this.m_componentNamesPage = new ComponentNameMappingWizardPage(COMPONENT_MAPPING_PAGE_ID, this.m_setOfExecsToReplace);
        this.addPage((IWizardPage)this.m_choosePage);
        this.addPage((IWizardPage)this.m_componentNamesPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof ChooseTestCasePage) {
            this.m_newSpec = this.m_choosePage.getChoosenTestCase();
            this.m_componentNamesPage.setNewSpec(this.m_newSpec);
        }
        return super.getNextPage(page);
    }

    private class ReplaceTestCaseOperation
    implements IRunnableWithProgress {
        private ReplaceTestCaseOperation() {
        }

        public void run(IProgressMonitor monitor) {
            block9: {
                monitor.beginTask(Messages.ReplaceTestCasesActionDialog, -1);
                EntityManager session = GeneralStorage.getInstance().getMasterSession();
                try {
                    try {
                        Persistor.instance().lockPOSet(session, SearchReplaceTCRWizard.this.m_setOfExecsToReplace);
                        Persistor.instance().lockPO(session, (IPersistentObject)SearchReplaceTCRWizard.this.m_newSpec);
                        ArrayList<Object> commands = new ArrayList<Object>();
                        for (IExecTestCasePO exec : SearchReplaceTCRWizard.this.m_setOfExecsToReplace) {
                            INodePO parent = exec.getParentNode();
                            int index = ((ISpecTestCasePO)exec.getParentNode()).indexOf((INodePO)exec);
                            IExecTestCasePO newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)SearchReplaceTCRWizard.this.m_newSpec);
                            newExec.setComment(exec.getComment());
                            newExec.setActive(exec.isActive());
                            newExec.setParentProjectId(exec.getParentProjectId());
                            if (exec.getSpecTestCase().getName() != exec.getName()) {
                                newExec.setName(exec.getName());
                            }
                            for (ICompNamesPairPO pair : SearchReplaceTCRWizard.this.m_listOfNewCompNamePairs) {
                                newExec.addCompNamesPair(this.createNewCompNamePair(pair));
                            }
                            commands.add(new MultipleNodePM.AddExecTCHandle(parent, newExec, Integer.valueOf(index)));
                            commands.add(new MultipleNodePM.DeleteExecTCHandle(exec));
                        }
                        MessageInfo errorMessageInfo = MultipleNodePM.getInstance().executeCommands(commands, session);
                        DataEventDispatcher.getInstance().fireProjectLoadedListener(monitor);
                        if (errorMessageInfo != null) {
                            ErrorHandlingUtil.createMessageDialog((Integer)errorMessageInfo.getMessageId(), (Object[])errorMessageInfo.getParams(), null);
                        }
                    }
                    catch (JBException e) {
                        ErrorHandlingUtil.createMessageDialog((JBException)e, null, null);
                        LockManager.instance().unlockPOs(session);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    LockManager.instance().unlockPOs(session);
                    throw throwable;
                }
                LockManager.instance().unlockPOs(session);
            }
            monitor.done();
        }

        private ICompNamesPairPO createNewCompNamePair(ICompNamesPairPO pair) {
            ICompNamesPairPO newPair = PoMaker.createCompNamesPairPO((String)pair.getFirstName(), (String)pair.getSecondName(), (String)pair.getType());
            newPair.setPropagated(pair.isPropagated());
            return newPair;
        }
    }
}

