/*******************************************************************************
 * Copyright (c) 2004, 2010 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.client.ui.handlers.open;

import java.util.Iterator;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TestResultPM;
import org.eclipse.jubula.client.ui.editors.TestResultEditorInput;
import org.eclipse.jubula.client.ui.editors.TestResultViewer;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.constants.StringConstants;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Handler to open the Test Result Viewer.
 *
 * @author BREDEX GmbH
 * @created Jun 14, 2010
 */
public class OpenTestResultViewerHandler 
    extends AbstractSelectionBasedHandler {
    /** the logger */
    private static final Logger LOG = 
        LoggerFactory.getLogger(OpenTestResultViewerHandler.class);
    
    /**
     * {@inheritDoc}
     */
    public Object executeImpl(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSel = getSelection();
        Iterator selectedTestResultSummaries = structuredSel.iterator();
        while (selectedTestResultSummaries.hasNext()) {
            Object firstElement = selectedTestResultSummaries.next();
            IEditorInput editorInput = null;
            if (firstElement instanceof ITestResultSummaryPO) {
                ITestResultSummaryPO result = 
                    (ITestResultSummaryPO)firstElement;
                if (TestResultPM.hasTestResultDetails(
                        GeneralStorage.getInstance()
                        .getMasterSession(), 
                        result.getId())) {
                    editorInput = new TestResultEditorInput(result);
                }
            } else {
                LOG.info(Messages.SelectedElementIsNotTestResultSummary
                        + StringConstants.DOT);
            }
            
            if (editorInput != null) {
                IWorkbenchPage currentPage = 
                    HandlerUtil.getActiveSiteChecked(event).getPage();
                
                if (currentPage != null) {
                    try {
                        currentPage.openEditor(
                                editorInput, 
                                TestResultViewer.EDITOR_ID);
                    } catch (PartInitException e) {
                        ErrorHandlingUtil.createMessageDialog(
                                MessageIDs.E_CANNOT_OPEN_EDITOR);
                    }
                }
            } else {
                LOG.info(Messages.NoEditorInputCouldBeCreated
                        + StringConstants.DOT);
            }
        }
        return null;
    }
}
