/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.dialogs;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnectionConverter;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.businessprocess.SecurePreferenceBP;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DBLoginDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_3 = 3;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 2;
    private Text m_userText;
    private Label m_userLabel;
    private Text m_pwdText;
    private Label m_pwdLabel;
    private ComboViewer m_connectionComboViewer;
    private Button m_profileSave;
    private Button m_automConn;
    private Link m_secureStorageLink;
    private String m_user;
    private String m_pwd;
    private DatabaseConnection m_dbConn;
    private List<DatabaseConnection> m_availableConnections;
    private boolean m_isEmbeddedOrNoSelection = false;

    public DBLoginDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.m_availableConnections = DatabaseConnectionConverter.computeAvailableConnections();
        this.setMessage(Messages.DBLoginDialogMessage);
        this.setTitle(Messages.DBLoginDialogTitle);
        this.setTitleImage(IconConstants.DB_LOGIN_DIALOG_IMAGE);
        this.getShell().setText(Messages.DBLoginDialogShell);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator(parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createSchemaCombobox(area);
        this.createUserTextField(area);
        this.createPasswordTextField(area);
        this.createSavePasswordCheckbox(area);
        this.createAutomaticConnectionCheckbox(area);
        this.fillConnectionCombobox();
        this.fillUserNameAndPasswordField();
        this.m_automConn.setEnabled(this.m_profileSave.getSelection());
        this.setUserAndPwdAndPwdCheckboxVisible(!this.m_isEmbeddedOrNoSelection);
        LayoutUtil.createSeparator(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.dbLoginContextId");
        this.setHelpAvailable(true);
        return area;
    }

    public int open() {
        this.setMessage(Messages.DBLoginDialogMessage);
        return super.open();
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (this.m_userText.getText().length() == 0 || this.m_connectionComboViewer.getSelection().isEmpty() || this.m_availableConnections.isEmpty()) {
            this.getButton(0).setEnabled(false);
        }
        return button;
    }

    private void createUserTextField(Composite area) {
        new Label(area, 0).setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        this.m_userLabel = new Label(area, 0);
        this.m_userLabel.setText(Messages.DBLoginDialogUserLabel);
        this.m_userLabel.setData("TEST_COMP_NAME", (Object)"DBLoginDialog.userLabel");
        this.m_userText = new Text(area, 2048);
        this.m_userText.setData("TEST_COMP_NAME", (Object)"DBLoginDialog.userTxf");
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth(gridData, (Control)this.m_userText);
        this.m_userText.setLayoutData((Object)gridData);
        LayoutUtil.setMaxChar(this.m_userText);
        IPreferenceStore store = Plugin.getDefault().getPreferenceStore();
        this.m_userText.setText(store.getString("USER_KEY"));
        this.m_userText.selectAll();
        this.m_userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DBLoginDialog.this.modifyUsernameFieldAction()) {
                    DBLoginDialog.this.modifyPasswordFieldAction();
                }
            }
        });
    }

    private void createPasswordTextField(Composite area) {
        new Label(area, 0).setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        this.m_pwdLabel = new Label(area, 0);
        this.m_pwdLabel.setText(Messages.DBLoginDialogPwdLabel);
        this.m_pwdLabel.setData("TEST_COMP_NAME", (Object)"DBLoginDialog.pwdLabel");
        this.m_pwdText = new Text(area, 0x400800);
        this.m_pwdText.setData("TEST_COMP_NAME", (Object)"DBLoginDialog.pwdTxf");
        GridData gridData = this.newGridData();
        LayoutUtil.addToolTipAndMaxWidth(gridData, (Control)this.m_pwdText);
        this.m_pwdText.setLayoutData((Object)gridData);
        LayoutUtil.setMaxChar(this.m_pwdText);
        if (!StringUtils.isEmpty((String)this.m_userText.getText())) {
            this.m_pwdText.setFocus();
        }
        this.m_pwdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DBLoginDialog.this.modifyPasswordFieldAction()) {
                    DBLoginDialog.this.modifyUsernameFieldAction();
                }
            }
        });
    }

    private void createSchemaCombobox(Composite area) {
        new Label(area, 0).setLayoutData((Object)new GridData(4, 2, false, false, 3, 1));
        new Label(area, 0).setText(Messages.DBLoginDialogConnectionLabel);
        Combo connectionCombo = new Combo(area, 12);
        GridData gridData = this.newGridData();
        connectionCombo.setLayoutData((Object)gridData);
        this.m_connectionComboViewer = new ComboViewer(connectionCombo);
        this.m_connectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_connectionComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof DatabaseConnection) {
                    return ((DatabaseConnection)element).getName();
                }
                return super.getText(element);
            }
        });
    }

    private void fillConnectionCombobox() {
        this.m_connectionComboViewer.setInput(this.m_availableConnections);
        if (this.m_availableConnections.size() == 1) {
            this.m_connectionComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.m_availableConnections.get(0)));
        } else {
            String previouslySelectedConn = Plugin.getDefault().getPreferenceStore().getString("SCHEMA_KEY");
            for (DatabaseConnection conn : this.m_availableConnections) {
                if (!conn.getName().equals(previouslySelectedConn)) continue;
                this.m_connectionComboViewer.setSelection((ISelection)new StructuredSelection((Object)conn));
                break;
            }
        }
        this.selectSchemaCbxAction();
        IStructuredSelection sel = (IStructuredSelection)this.m_connectionComboViewer.getSelection();
        this.selectSchemaCbxAction();
        this.checkEmbeddedDbOrNoSchemaSelected((DatabaseConnection)sel.getFirstElement());
        this.m_connectionComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection csel = (IStructuredSelection)event.getSelection();
                DBLoginDialog.this.selectSchemaCbxAction();
                DBLoginDialog.this.checkEmbeddedDbOrNoSchemaSelected((DatabaseConnection)csel.getFirstElement());
                DBLoginDialog.this.setUserAndPwdAndPwdCheckboxVisible(!DBLoginDialog.this.m_isEmbeddedOrNoSelection);
            }
        });
    }

    private void createSavePasswordCheckbox(Composite area) {
        new Label(area, 0).setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        new Label(area, 0).setText("");
        Composite saveProfileComp = new Composite(area, 0);
        saveProfileComp.setLayout((Layout)RowLayoutFactory.fillDefaults().spacing(0).create());
        this.m_profileSave = new Button(saveProfileComp, 32);
        this.m_profileSave.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DBLoginDialog.this.m_automConn.setEnabled(DBLoginDialog.this.m_profileSave.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_secureStorageLink = DialogUtils.createLinkToSecureStoragePreferencePage(saveProfileComp, Messages.DBLoginDialogSaveDBPassword);
    }

    private void fillUserNameAndPasswordField() {
        SecurePreferenceBP spBP = SecurePreferenceBP.getInstance();
        IStructuredSelection sel = (IStructuredSelection)this.m_connectionComboViewer.getSelection();
        DatabaseConnection conn = (DatabaseConnection)sel.getFirstElement();
        if (conn != null) {
            String profileName = conn.getName();
            this.m_profileSave.setSelection(spBP.isSaveCredentialsActive(profileName));
            if (this.m_profileSave.getSelection()) {
                String userName = spBP.getUserName(profileName);
                String databasePassword = spBP.getPassword(profileName);
                this.m_userText.setText(userName);
                this.m_pwdText.setText(databasePassword);
            } else {
                String userName = spBP.getUserName(profileName);
                this.m_userText.setText(userName);
                this.m_pwdText.setText("");
            }
        }
    }

    private void saveDatabaseProfile() {
        SecurePreferenceBP spBP = SecurePreferenceBP.getInstance();
        IStructuredSelection sel = (IStructuredSelection)this.m_connectionComboViewer.getSelection();
        DatabaseConnection conn = (DatabaseConnection)sel.getFirstElement();
        String profileName = conn.getName().toString();
        String userName = this.m_userText.getText();
        spBP.saveProfile(profileName, userName);
    }

    private void createAutomaticConnectionCheckbox(Composite area) {
        new Label(area, 0).setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        new Label(area, 0).setText("");
        this.m_automConn = new Button(area, 32);
        this.m_automConn.setText(Messages.DBLoginDialogAutoDbConnection);
    }

    private void checkEmbeddedDbOrNoSchemaSelected(DatabaseConnection connection) {
        if (connection == null) {
            this.m_isEmbeddedOrNoSelection = true;
            return;
        }
        DatabaseConnectionInfo connInfo = connection.getConnectionInfo();
        String username = connInfo.getProperty("javax.persistence.jdbc.user");
        String password = connInfo.getProperty("javax.persistence.jdbc.password");
        if (username != null && password != null) {
            this.m_isEmbeddedOrNoSelection = true;
            Persistor.setUser((String)username);
            Persistor.setPw((String)password);
            this.m_userText.setText(username);
            this.m_pwdText.setText(password);
            this.enableOKButton(true);
        } else {
            this.fillUserNameAndPasswordField();
            this.m_automConn.setEnabled(this.m_profileSave.getSelection());
            this.m_isEmbeddedOrNoSelection = false;
        }
    }

    private void setUserAndPwdAndPwdCheckboxVisible(boolean visible) {
        this.m_userText.setVisible(visible);
        this.m_userLabel.setVisible(visible);
        this.m_pwdText.setVisible(visible);
        this.m_pwdLabel.setVisible(visible);
        this.m_profileSave.setVisible(visible);
        this.m_secureStorageLink.setVisible(visible);
        this.m_automConn.setVisible(visible);
    }

    boolean modifyUsernameFieldAction() {
        this.m_userText.clearSelection();
        boolean isCorrect = true;
        int serverNameLength = this.m_userText.getText().length();
        if (serverNameLength == 0 || this.m_userText.getText().startsWith(" ") || this.m_userText.getText().charAt(serverNameLength - 1) == ' ') {
            isCorrect = false;
        }
        if (isCorrect) {
            this.setErrorMessage(null);
        } else if (serverNameLength == 0) {
            this.setErrorMessage(Messages.DBLoginDialogEmptyUser);
        } else {
            this.setErrorMessage(Messages.DBLoginDialogWrongUser);
        }
        this.enableOKButton(isCorrect);
        return isCorrect;
    }

    boolean modifyPasswordFieldAction() {
        boolean isCorrect = true;
        if (this.m_pwdText.getText().startsWith(" ") || this.m_pwdText.getText().endsWith(" ")) {
            isCorrect = false;
        }
        if (isCorrect) {
            this.setMessage(Messages.DBLoginDialogMessage);
        } else {
            this.setErrorMessage(Messages.DBLoginDialogWrongPwd);
        }
        this.enableOKButton(isCorrect);
        return isCorrect;
    }

    private void selectSchemaCbxAction() {
        boolean isCorrect = true;
        if (this.m_availableConnections.isEmpty()) {
            this.setErrorMessage(Messages.DBLoginDialogNoSchemaAvailable);
            isCorrect = false;
        } else if (this.m_connectionComboViewer.getSelection().isEmpty()) {
            this.setErrorMessage(Messages.DBLoginDialogNoSchemaSelected);
            isCorrect = false;
        } else {
            this.setErrorMessage(null);
        }
        this.enableOKButton(isCorrect);
    }

    void enableOKButton(boolean enabled) {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(enabled);
        }
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.m_connectionComboViewer.getSelection();
        this.m_user = this.m_userText.getText();
        this.m_pwd = this.m_pwdText.getText();
        this.m_dbConn = (DatabaseConnection)sel.getFirstElement();
        IPreferenceStore store = Plugin.getDefault().getPreferenceStore();
        store.setValue("USER_KEY", this.m_user);
        store.setValue("SCHEMA_KEY", this.m_dbConn.getName());
        this.saveDatabaseProfile();
        SecurePreferenceBP spBP = SecurePreferenceBP.getInstance();
        if (this.m_profileSave.getSelection()) {
            spBP.setSaveCredentialStatus(this.m_dbConn.getName(), true);
            String databasePassword = this.m_pwdText.getText();
            spBP.saveProfilePassword(this.m_dbConn.getName(), databasePassword);
            if (this.m_automConn.getSelection()) {
                store.setValue("AUTOMATIC_DATABASE_CONNECTION_KEY", this.m_dbConn.getName());
            } else {
                store.setToDefault("AUTOMATIC_DATABASE_CONNECTION_KEY");
            }
        } else {
            spBP.setSaveCredentialStatus(this.m_dbConn.getName(), false);
            spBP.removePassword(this.m_dbConn.getName());
        }
        this.setReturnCode(0);
        this.close();
    }

    private GridData newGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        return gridData;
    }

    public String getUser() {
        return this.m_user;
    }

    public String getPwd() {
        return this.m_pwd;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.m_dbConn;
    }

    public ComboViewer getConnectionComboViewer() {
        return this.m_connectionComboViewer;
    }
}

