/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.AbstractTextVerifiableTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IListComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.ListSelectionVerifier;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.StringParsing;

public class ListTester
extends AbstractTextVerifiableTester {
    private String[] split(String values, String separator) {
        String[] list = StringParsing.splitToArray((String)values, (char)(separator == null || separator.length() == 0 ? (char)',' : separator.charAt(0)), (char)'\\');
        list = StringUtils.stripAll((String[])list);
        return list;
    }

    private int[] getCheckedSelectedIndices() throws StepExecutionException {
        int[] selected = this.getListAdapter().getSelectedIndices();
        if (selected.length == 0) {
            throw new StepExecutionException("No list element selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        return selected;
    }

    private IListComponent getListAdapter() {
        return (IListComponent)this.getComponent();
    }

    public void rcVerifySelectedIndex(String index, boolean expectSelected) {
        int implIndex;
        int[] selected = this.getCheckedSelectedIndices();
        boolean isSelected = ArrayUtils.contains((int[])selected, (int)(implIndex = IndexConverter.toImplementationIndex(Integer.parseInt(index))));
        if (expectSelected != isSelected) {
            throw new StepExecutionException("Selection check failed for index: " + index, EventFactory.createVerifyFailed((String)String.valueOf(expectSelected), (String)String.valueOf(isSelected)));
        }
    }

    public void rcVerifySelectedValue(String valueList) {
        this.rcVerifySelectedValue(valueList, "equals", true);
    }

    public void rcVerifySelectedValue(String value, String operator, boolean isSelected) {
        String[] current = this.getListAdapter().getSelectedValues();
        ListSelectionVerifier listSelVerifier = new ListSelectionVerifier();
        int i = 0;
        while (i < current.length) {
            listSelVerifier.addItem(i, current[i], true);
            ++i;
        }
        listSelVerifier.verifySelection(value, operator, isSelected);
    }

    public void rcVerifyText(String text, String operator) {
        String[] selected = this.getListAdapter().getSelectedValues();
        int selCount = selected.length;
        if (selCount < 1) {
            throw new StepExecutionException("No selection", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
        }
        int i = 0;
        while (i < selCount) {
            Verifier.match(selected[i], text, operator);
            ++i;
        }
    }

    public void rcSelectIndex(String indexList, String extendSelection, int button, int clickCount) {
        boolean isExtendSelection = extendSelection.equals("yes");
        this.selectIndices(IndexConverter.toImplementationIndices(this.parseIndices(indexList)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), isExtendSelection);
    }

    public void rcSelectValue(String valueList, String operator, String searchType, String extendSelection, int button, int clickCount) {
        boolean isExtendSelection = extendSelection.equals("yes");
        this.selectValue(valueList, String.valueOf(','), operator, searchType, ClickOptions.create().setClickCount(clickCount).setMouseButton(button), isExtendSelection);
    }

    public void rcVerifyContainsValue(String value) {
        Verifier.equals(true, this.containsValue(value));
    }

    public void rcVerifyContainsValue(String value, String operator, boolean exists) {
        Verifier.equals(exists, this.containsValue(value, operator));
    }

    public String rcReadValue(String variable) {
        String[] selected = this.getListAdapter().getSelectedValues();
        if (selected.length > 0) {
            return selected[0];
        }
        throw new StepExecutionException("No list item selected", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
    }

    public void rcDragValue(int mouseButton, String modifier, String value, String operator, String searchType) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        Integer[] indices = this.findIndicesOfValues(new String[]{value}, operator, searchType);
        this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), ClickOptions.create().setClickCount(0), false);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rcDropValue(String value, String operator, String searchType, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            Integer[] indices = this.findIndicesOfValues(new String[]{value}, operator, searchType);
            this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), ClickOptions.create().setClickCount(0), false);
            ListTester.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        }
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public void rcDragIndex(int mouseButton, String modifier, int index) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setModifier(modifier);
        dndHelper.setMouseButton(mouseButton);
        this.selectIndices(new int[]{IndexConverter.toImplementationIndex(index)}, ClickOptions.create().setClickCount(0), false);
        this.pressOrReleaseModifiers(modifier, true);
        this.getRobot().mousePress(null, null, mouseButton);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rcDropIndex(int index, int delayBeforeDrop) {
        DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        try {
            this.selectIndices(new int[]{IndexConverter.toImplementationIndex(index)}, ClickOptions.create().setClickCount(0), false);
            ListTester.waitBeforeDrop(delayBeforeDrop);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
            this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.getRobot().mouseRelease(null, null, dndHelper.getMouseButton());
        }
        this.pressOrReleaseModifiers(dndHelper.getModifier(), false);
    }

    public boolean containsValue(String value) {
        Integer[] indices = this.findIndicesOfValues(new String[]{value}, "equals", "absolute");
        return indices.length > 0;
    }

    public boolean containsValue(String value, String operator) {
        Integer[] indices = null;
        if (operator.equals("not equals")) {
            indices = this.findIndicesOfValues(new String[]{value}, "equals", "absolute");
            return indices.length == 0;
        }
        indices = this.findIndicesOfValues(new String[]{value}, operator, "absolute");
        return indices.length > 0;
    }

    private void selectValue(String valueList, String separator, String operator, String searchType, ClickOptions co, boolean isExtendSelection) {
        String[] values = null;
        values = "".equals(valueList) ? new String[]{""} : this.split(valueList, separator);
        Object[] indices = this.findIndicesOfValues(values, operator, searchType);
        Arrays.sort(indices);
        if (!operator.equals("not equals") && indices.length < values.length) {
            throw new StepExecutionException("One or more values not found of set: " + Arrays.asList(values).toString(), EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.selectIndices(ArrayUtils.toPrimitive((Integer[])indices), co, isExtendSelection);
    }

    private int[] parseIndices(String indexList) {
        String[] list = StringParsing.splitToArray((String)indexList, (char)',', (char)'\\');
        int[] indices = new int[list.length];
        int i = 0;
        while (i < list.length) {
            indices[i] = IndexConverter.intValue(list[i]);
            ++i;
        }
        return indices;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectIndices(int[] indices, ClickOptions co, boolean isExtendSelection) {
        block8: {
            list = this.getListAdapter().getRealComponent();
            if (indices.length <= 0) break block8;
            try {
                if (isExtendSelection) {
                    this.getRobot().keyPress(list, this.getSystemDefaultModifier());
                }
                this.getListAdapter().clickOnIndex(new Integer(indices[0]), co);
            }
            catch (Throwable var6_5) {
                var5_8 = null;
                if (isExtendSelection == false) throw var6_5;
                this.getRobot().keyRelease(list, this.getSystemDefaultModifier());
                throw var6_5;
            }
            {
                var5_9 = null;
                if (!isExtendSelection) break block8;
                this.getRobot().keyRelease(list, this.getSystemDefaultModifier());
                ** GOTO lbl-1000
            }
        }
        try lbl-1000:
        // 2 sources

        {
            this.getRobot().keyPress(list, this.getSystemDefaultModifier());
            i = 1;
            while (i < indices.length) {
                this.getListAdapter().clickOnIndex(new Integer(indices[i]), co);
                ++i;
            }
        }
        catch (Throwable var7_11) {
            var6_6 = null;
            this.getRobot().keyRelease(list, this.getSystemDefaultModifier());
            throw var7_11;
        }
        {
            var6_7 = null;
            this.getRobot().keyRelease(list, this.getSystemDefaultModifier());
            return;
        }
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    protected int getSystemDefaultModifier() {
        return -1;
    }

    private Integer[] findIndicesOfValues(String[] values, String operator, String searchType) {
        String[] listValues = this.getListAdapter().getValues();
        int startIndex = this.getStartingIndex(searchType);
        ArrayList<Integer> indexList = new ArrayList<Integer>(values.length);
        MatchUtil matchUtil = MatchUtil.getInstance();
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            int j = startIndex;
            while (j < listValues.length) {
                String listItem = listValues[j];
                if (matchUtil.match(listItem, value, operator)) {
                    indexList.add(new Integer(j));
                }
                ++j;
            }
            ++i;
        }
        Integer[] indices = new Integer[indexList.size()];
        indexList.toArray(indices);
        return indices;
    }

    private int getStartingIndex(String searchType) {
        int[] selectedIndices;
        int startingIndex = 0;
        if (searchType.equalsIgnoreCase("relative") && (selectedIndices = this.getListAdapter().getSelectedIndices()).length > 0) {
            startingIndex = selectedIndices[selectedIndices.length - 1] + 1;
        }
        return startingIndex;
    }
}

