/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.util;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class Verifier {
    private Verifier() {
    }

    public static void throwVerifyFailed(String expected, String actual) {
        throw new StepVerifyFailedException("Expected '" + expected + "' but was '" + actual + "'", EventFactory.createVerifyFailed((String)expected, (String)actual));
    }

    public static void equals(String expected, String actual) throws StepVerifyFailedException {
        if (!StringUtils.equals((String)expected, (String)actual)) {
            Verifier.throwVerifyFailed(expected, actual);
        }
    }

    public static void equals(boolean expected, boolean actual) throws StepVerifyFailedException {
        if (expected != actual) {
            Verifier.throwVerifyFailed(String.valueOf(expected), String.valueOf(actual));
        }
    }

    public static void equals(int expected, int actual) throws StepVerifyFailedException {
        if (expected != actual) {
            Verifier.throwVerifyFailed(String.valueOf(expected), String.valueOf(actual));
        }
    }

    public static void equals(int expected, int actual, boolean shouldEqual) throws StepVerifyFailedException {
        boolean equals = expected == actual;
        Verifier.equals(shouldEqual, equals);
    }

    public static void match(String text, String pattern, String operator) throws StepVerifyFailedException, StepExecutionException {
        Verifier.match(text, pattern, operator, true);
    }

    public static void match(String text, String pattern, String operator, boolean shouldMatch) throws StepVerifyFailedException, StepExecutionException {
        if (shouldMatch == !MatchUtil.getInstance().match(text, pattern, operator)) {
            throw new StepVerifyFailedException("verification failed", EventFactory.createVerifyFailed((String)text, (String)pattern, (String)operator));
        }
    }

    public static void match(String text, String[] pattern, String operator) throws StepVerifyFailedException, StepExecutionException {
        if (!MatchUtil.getInstance().match(text, pattern, operator)) {
            throw new StepVerifyFailedException("verification failed", EventFactory.createVerifyFailed((String)text, (String)pattern.toString(), (String)operator));
        }
    }
}

