/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.search.refactor.pages;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.MasterSessionComponentNameMapper;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentNameMappingWizardPage
extends WizardPage {
    private Map<String, ComboViewer> m_componentNamesMapping;
    private ScrolledComposite m_scroll;
    private Composite m_composite;
    private ISpecTestCasePO m_newSpec;
    private LinkedList<ICompNamesPairPO> m_oldCompNamePairs = new LinkedList();
    private CompNamesBP m_compNamesBP = new CompNamesBP();

    public ComponentNameMappingWizardPage(String pageName, Set<IExecTestCasePO> execTCList) {
        super(pageName, Messages.ReplaceTCRWizard_matchComponentNames_title, null);
        for (IExecTestCasePO exec : execTCList) {
            this.m_oldCompNamePairs.addAll(this.m_compNamesBP.getAllCompNamesPairs(exec));
        }
    }

    public void createControl(Composite parent) {
        this.m_scroll = new ScrolledComposite(parent, 768);
        this.m_scroll.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(1).create());
        this.m_scroll.setMinSize(parent.getSize());
        this.m_composite = new Composite((Composite)this.m_scroll, 0);
        this.setControl((Control)this.m_scroll);
    }

    public void setNewSpec(ISpecTestCasePO newSpec) {
        this.m_newSpec = newSpec;
        this.setPageComplete(false);
        this.m_composite.dispose();
        this.m_componentNamesMapping = new HashMap<String, ComboViewer>();
        Composite mappingGrid = new Composite((Composite)this.m_scroll, 0);
        mappingGrid.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).spacing(10, 10).create());
        GridData tableGridData = GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).create();
        mappingGrid.setLayoutData((Object)tableGridData);
        this.createLayoutWithData(mappingGrid);
        this.m_scroll.setContent((Control)mappingGrid);
        this.m_composite = mappingGrid;
        this.setPageComplete(true);
    }

    private void createLayoutWithData(Composite parent) {
        new Label(parent, 0).setText(Messages.ReplaceTCRWizard_ComponentNameMapping_newTC);
        new Label(parent, 514);
        new Label(parent, 0).setText(Messages.ReplaceTCRWizard_ComponentNameMapping_oldTC);
        Label seperatorHorizontal = new Label(parent, 258);
        GridData seperatorGridHorizontal = new GridData(4, 2, true, false);
        seperatorGridHorizontal.horizontalSpan = 3;
        seperatorHorizontal.setLayoutData((Object)seperatorGridHorizontal);
        this.createMatchingFields(parent);
        parent.pack();
    }

    private void createMatchingFields(Composite parent) {
        IExecTestCasePO newExec = NodeMaker.createExecTestCasePO((ISpecTestCasePO)this.m_newSpec);
        List compNamePairs = this.m_compNamesBP.getAllCompNamesPairs(newExec);
        GridData seperatorVertical = new GridData(2, 4, false, true);
        seperatorVertical.verticalSpan = compNamePairs.size();
        boolean first = true;
        for (ICompNamesPairPO compNamesPair : compNamePairs) {
            GridData leftGridData = new GridData();
            leftGridData.horizontalAlignment = 16384;
            leftGridData.verticalAlignment = 1;
            GridData rightGridData = new GridData();
            rightGridData.horizontalAlignment = 16384;
            rightGridData.verticalAlignment = 1;
            rightGridData.minimumWidth = 200;
            rightGridData.grabExcessHorizontalSpace = true;
            IComponentNamePO newComponentName = ComponentNamesBP.getInstance().getCompNamePo(compNamesPair.getFirstName());
            String displayName = this.getDisplayName(newComponentName.getName(), null, newComponentName.getComponentType());
            Label compname = new Label(parent, 0);
            compname.setText(displayName);
            compname.setLayoutData((Object)leftGridData);
            if (first) {
                Label seperator = new Label(parent, 514);
                seperator.setLayoutData((Object)seperatorVertical);
                first = false;
            }
            Combo oldCompNames = new Combo(parent, 8);
            oldCompNames.setLayoutData((Object)rightGridData);
            this.fillComboWithOldNames(newComponentName, oldCompNames);
            oldCompNames.pack();
        }
    }

    private void fillComboWithOldNames(IComponentNamePO componentName, Combo oldCompNames) {
        ComboViewer comboViewer = new ComboViewer(oldCompNames);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICompNamesPairPO) {
                    ICompNamesPairPO pair = (ICompNamesPairPO)element;
                    return ComponentNameMappingWizardPage.this.getDisplayName(pair.getFirstName(), pair.getSecondName(), pair.getType());
                }
                return " ";
            }
        });
        this.m_componentNamesMapping.put(componentName.getGuid(), comboViewer);
        int counter = 1;
        LinkedList<ICompNamesPairPO> list = new LinkedList<ICompNamesPairPO>();
        list.add(PoMaker.createCompNamesPairPO((String)" ", (String)" "));
        for (ICompNamesPairPO oldPairs : this.m_oldCompNamePairs) {
            IComponentNamePO oldComponent = ComponentNamesBP.getInstance().getCompNamePo(oldPairs.getFirstName());
            String isCompatible = ComponentNamesBP.getInstance().isCompatible(componentName.getComponentType(), oldComponent.getName(), (IComponentNameMapper)MasterSessionComponentNameMapper.getInstance(), this.m_newSpec.getParentProjectId(), true);
            if (isCompatible != null) continue;
            list.add(oldPairs);
            if (componentName.getName().equals(oldComponent.getName()) && componentName.getComponentType().equals(oldComponent.getComponentType())) {
                oldCompNames.select(counter);
            }
            ++counter;
        }
        comboViewer.setInput((Object)list.toArray());
    }

    private String getDisplayName(String guidName, String secondGuidName, String guidType) {
        String firstName = ComponentNamesBP.getInstance().getName(guidName);
        String secondName = ComponentNamesBP.getInstance().getName(secondGuidName);
        String type = CompSystemI18n.getString((String)guidType);
        String displayName = firstName;
        if (!StringUtils.isBlank((String)secondGuidName)) {
            displayName = String.valueOf(displayName) + " >" + secondName;
        }
        if (!StringUtils.isBlank((String)type)) {
            displayName = String.valueOf(displayName) + " [" + type + "]";
        }
        return displayName;
    }

    public List<ICompNamesPairPO> getCompMatching() {
        LinkedList<ICompNamesPairPO> compPairs = new LinkedList<ICompNamesPairPO>();
        for (Map.Entry<String, ComboViewer> entry : this.m_componentNamesMapping.entrySet()) {
            String guidOfCompName = entry.getKey();
            IViewerObservableValue test = ViewersObservables.observeSingleSelection((Viewer)((Viewer)entry.getValue()));
            ICompNamesPairPO oldPair = (ICompNamesPairPO)test.getValue();
            if (oldPair == null) continue;
            IComponentNamePO specComponent = ComponentNamesBP.getInstance().getCompNamePo(guidOfCompName);
            if (StringUtils.isBlank((String)oldPair.getSecondName())) continue;
            ICompNamesPairPO pair = PoMaker.createCompNamesPairPO((String)guidOfCompName, (String)oldPair.getSecondName(), (String)specComponent.getComponentType());
            pair.setPropagated(oldPair.isPropagated());
            compPairs.add(pair);
        }
        return compPairs;
    }
}

