/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.actions;

import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.action.Action;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.ui.IEditorPart;

public class LanguageAction
extends Action {
    private Locale m_language;

    public LanguageAction(String text, int style) {
        super(text, style);
    }

    public void run() {
        if (this.m_language.equals(WorkingLanguageBP.getInstance().getWorkingLanguage())) {
            return;
        }
        if (this.showUnsavedTestSuiteEditors()) {
            WorkingLanguageBP.getInstance().setCurrentLanguage(this.m_language);
            DataEventDispatcher.getInstance().fireLanguageChanged(this.m_language);
        }
    }

    public void setLanguage(Locale lang) {
        this.m_language = lang;
    }

    private boolean showUnsavedTestSuiteEditors() {
        String editorNames;
        IProjectPO project = GeneralStorage.getInstance().getProject();
        ArrayList<String> editorsToSave = new ArrayList<String>();
        ArrayList<String> editorsToClose = new ArrayList<String>();
        for (ITestSuitePO testSuite : TestSuiteBP.getListOfTestSuites((IProjectPO)project)) {
            IEditorPart editor = Utils.getEditorByPO((IPersistentObject)testSuite);
            if (testSuite.getAut() != null && !WorkingLanguageBP.getInstance().isTestSuiteLanguage(this.m_language, testSuite) && editor != null && !editor.isDirty()) {
                editorsToClose.add(editor.getTitle());
            }
            if (editor == null || !editor.isDirty()) continue;
            editorsToSave.add(editor.getTitle());
        }
        if (editorsToSave.isEmpty()) {
            if (editorsToClose.isEmpty()) {
                return true;
            }
            editorNames = "";
            for (String name : editorsToClose) {
                editorNames = String.valueOf(editorNames) + "   - " + name + "\n";
            }
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_EDITORS_TO_CLOSE, (Object[])new Object[]{editorNames}, null);
            for (String name : editorsToClose) {
                IEditorPart editor = Plugin.getEditorByTitle(name);
                Plugin.getActivePage().closeEditor(editor, false);
            }
            return true;
        }
        if (!editorsToSave.isEmpty()) {
            editorNames = "";
            for (String name : editorsToSave) {
                editorNames = String.valueOf(editorNames) + "   - " + name + "\n";
            }
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_EDITORS_TO_SAVE, (Object[])new Object[]{editorNames}, null);
            return false;
        }
        return true;
    }
}

