/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.lang.reflect.InvocationTargetException;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.core.businessprocess.progress.ProgressMonitorTracker;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.ui.PlatformUI;

public class RefreshProjectHandler
extends AbstractProjectHandler {
    public Object executeImpl(ExecutionEvent event) {
        return this.refreshProject();
    }

    public IStatus refreshProject() {
        Plugin.startLongRunning(Messages.RefreshTSBrowserActionProgressMessage);
        try {
            try {
                PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new RefreshProjectOperation());
            }
            catch (InvocationTargetException e) {
                Status status = new Status(4, "org.eclipse.jubula.client.ui.rcp", e.getLocalizedMessage());
                Plugin.stopLongRunning();
                DataEventDispatcher.getInstance().fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
                return status;
            }
            catch (InterruptedException interruptedException) {
                IStatus iStatus = Status.CANCEL_STATUS;
                Plugin.stopLongRunning();
                DataEventDispatcher.getInstance().fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
                return iStatus;
            }
        }
        finally {
            Plugin.stopLongRunning();
            DataEventDispatcher.getInstance().fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
        }
        return Status.OK_STATUS;
    }

    public static class RefreshProjectOperation
    implements IRunnableWithProgress {
        public void run(IProgressMonitor monitor) {
            int totalWork = this.getTotalWork();
            monitor.beginTask(Messages.RefreshProjectOperationRefreshing, totalWork);
            ProgressMonitorTracker.getInstance().setProgressMonitor(monitor);
            try {
                try {
                    GeneralStorage.getInstance().reloadMasterSession(monitor);
                }
                catch (ProjectDeletedException projectDeletedException) {
                    PMExceptionHandler.handleGDProjectDeletedException();
                    ProgressMonitorTracker.getInstance().setProgressMonitor(null);
                    monitor.done();
                }
            }
            finally {
                ProgressMonitorTracker.getInstance().setProgressMonitor(null);
                monitor.done();
            }
        }

        private int getTotalWork() {
            int totalWork = 0;
            EntityManager masterSession = GeneralStorage.getInstance().getMasterSession();
            IProjectPO currentProject = GeneralStorage.getInstance().getProject();
            long currentProjectId = currentProject.getId();
            totalWork = (int)((long)totalWork + NodePM.getNumNodes((long)currentProjectId, (EntityManager)masterSession));
            totalWork = (int)((long)totalWork + NodePM.getNumTestDataManagers((long)currentProjectId, (EntityManager)masterSession));
            totalWork = (int)((long)totalWork + NodePM.getNumExecTestCases((long)currentProjectId, (EntityManager)masterSession));
            for (IReusedProjectPO reused : currentProject.getUsedProjects()) {
                try {
                    IProjectPO reusedProject = ProjectPM.loadReusedProject((IReusedProjectPO)reused);
                    if (reusedProject == null) continue;
                    long reusedId = reusedProject.getId();
                    totalWork = (int)((long)totalWork + NodePM.getNumNodes((long)reusedId, (EntityManager)masterSession));
                    totalWork = (int)((long)totalWork + NodePM.getNumTestDataManagers((long)reusedId, (EntityManager)masterSession));
                    totalWork = (int)((long)totalWork + NodePM.getNumExecTestCases((long)reusedId, (EntityManager)masterSession));
                }
                catch (JBException jBException) {}
            }
            return totalWork;
        }
    }
}

