/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.filter.JBPatternFilter;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.AbstractTreeViewContentProvider;
import org.eclipse.jubula.client.ui.rcp.search.AbstractSearchResultPage;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PatternFilter;

public class SearchResultPage
extends AbstractSearchResultPage
implements DataEventDispatcher.IProjectLoadedListener {
    private DoubleClickListener m_doubleClickListener = new DoubleClickListener();
    private Control m_control;

    public void createControl(Composite parent) {
        Composite topLevelComposite = new Composite(parent, 0);
        this.setControl((Control)topLevelComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        topLevelComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        topLevelComposite.setLayoutData((Object)layoutData);
        JBFilteredTree ft = new JBFilteredTree(topLevelComposite, 2818, (PatternFilter)new JBPatternFilter(), true);
        this.setTreeViewer(ft.getViewer());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        this.getTreeViewer().addDoubleClickListener((IDoubleClickListener)this.m_doubleClickListener);
        this.getTreeViewer().setContentProvider((IContentProvider)new SearchResultContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new LabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.getTreeViewer().setSorter(new ViewerSorter());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
        DataEventDispatcher.getInstance().addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.searchResultViewContextId");
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
    }

    public void dispose() {
        this.getSite().setSelectionProvider(null);
        this.getTreeViewer().removeDoubleClickListener((IDoubleClickListener)this.m_doubleClickListener);
        DataEventDispatcher.getInstance().removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        super.dispose();
    }

    public String getLabel() {
        BasicSearchResult sr;
        ISearchQuery query;
        StringBuilder sb = new StringBuilder();
        sb.append(Messages.SearchResultPageResultPageLabel);
        Object viewerInput = this.getTreeViewer().getInput();
        if (viewerInput != null && (query = (sr = (BasicSearchResult)viewerInput).getQuery()) != null) {
            sb.append(query.getLabel());
        }
        return sb.toString();
    }

    private void setControl(Control control) {
        this.m_control = control;
    }

    public Control getControl() {
        return this.m_control;
    }

    public void handleProjectLoaded() {
        if (GeneralStorage.getInstance().getProject() == null) {
            Plugin.getDisplay().syncExec(new Runnable(){

                public void run() {
                    SearchResultPage.this.getTreeViewer().setInput(null);
                }
            });
        }
    }

    public void setSelection(ISelection selection) {
        this.getTreeViewer().setSelection(selection, true);
    }

    private static class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            BasicSearchResult.SearchResultElement element = (BasicSearchResult.SearchResultElement)((IStructuredSelection)event.getSelection()).getFirstElement();
            element.jumpToResult();
        }
    }

    private static class LabelProvider
    extends ColumnLabelProvider {
        private LabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof BasicSearchResult.SearchResultElement) {
                return ((BasicSearchResult.SearchResultElement)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof BasicSearchResult.SearchResultElement) {
                BasicSearchResult.SearchResultElement elem = (BasicSearchResult.SearchResultElement)element;
                return elem.getImage();
            }
            return super.getImage(element);
        }

        public String getToolTipText(Object element) {
            BasicSearchResult.SearchResultElement sr;
            String comment;
            if (element instanceof BasicSearchResult.SearchResultElement && (comment = (sr = (BasicSearchResult.SearchResultElement)element).getComment()) != null) {
                return comment;
            }
            return super.getToolTipText(element);
        }
    }

    private static class SearchResultContentProvider
    extends AbstractTreeViewContentProvider {
        private SearchResultContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof BasicSearchResult) {
                BasicSearchResult sr = (BasicSearchResult)parentElement;
                return sr.getResultList().toArray();
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
    }
}

